C
C
      DOUBLE PRECISION FUNCTION G01GBF$(T, DF, DELTA, TOL, MAXIT,
     +                                  IFAIL)
C
C ACTION: Non-central t using AS 243
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 20/12/99
C
C*****REAL FUNCTION TNC(T, DF, DELTA, IFAULT)
C
C     ALGORITHM AS 243  APPL. STATIST. (1989), VOL.38, NO. 1
C
C     Cumulative probability at T of the non-central t-distribution
C     with DF degrees of freedom (may be fractional) and non-centrality
C     parameter DELTA.
C
C     Note - requires the following auxiliary routines
C     ALOGAM (X)                         - ACM 291 or AS 245
C     BETAIN (X, A, B, ALBETA, IFAULT)   - AS 63 (updated in ASR 19)
C     ALNORM (X, UPPER)                  - AS 66
C
C
      IMPLICIT   NONE
      INTEGER    IFAIL, MAXIT
      INTEGER    IFAIL1, IFAULT
      DOUBLE PRECISION DELTA, DF, T, TOL
      DOUBLE PRECISION PDF, PP, QQ, U1, U2
      DOUBLE PRECISION A, ALBETA, ALNRPI, B, DEL, EN, ERRBD,
     +                 ERRMAX, GEVEN, GODD, ITRMAX, LAMBDA,
     +                 P, Q, R2PI, RXB, S, TT, X, XEVEN, XODD
      DOUBLE PRECISION TNC
      DOUBLE PRECISION ZERO, HALF, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00)
      DOUBLE PRECISION S14ABF$, G01EAF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      LOGICAL    NEGDEL
      EXTERNAL   S14ABF$, G01EAF$, G01EEF$
      INTRINSIC  EXP, LOG
C
C     Note - ITRMAX and ERRMAX may be changed to suit one's needs.
C
C     DATA ITRMAX/100.1/, ERRMAX/1.E-06/
C
C     Constants - R2PI = 1/ {GAMMA(1.5) * SQRT(2)} = SQRT(2 / PI)
C                 ALNRPI = LN(SQRT(PI))
C
      DATA       R2PI / 0.79788456080286535588D+00 /
      DATA       ALNRPI / 0.57236494292470008707D+00 /
C
C Is it safe ?
C
      IFAIL = 0
      G01GBF$ = ZERO
      IF (DF.LT.ONE) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (MAXIT.LT.1) THEN
         IFAIL = 2
         RETURN
      ENDIF
      ITRMAX = MAXIT
      ERRMAX = TOL
      TNC = ZERO
C     IFAULT = 2
C     IF (DF .LE. ZERO) RETURN
      IFAULT = 0
C
      TT = T
      DEL = DELTA
      NEGDEL = .FALSE.
      IF (T .GE. ZERO) GO TO 1
      NEGDEL = .TRUE.
      TT = -TT
      DEL = -DEL
    1 CONTINUE
C
C     Initialize twin series (Guenther, J. Statist. Computn. Simuln.
C     vol.6, 199, 1978).
C
      EN = ONE
      X = T * T / (T* T + DF)
      IF (X .LE. ZERO) GO TO 20
      LAMBDA = DEL * DEL
      P = HALF * EXP(-HALF * LAMBDA)
      Q = R2PI * P * DEL
      S = HALF - P
      A = HALF
      B = HALF * DF
      RXB = (ONE - X) ** B
      IFAIL1 = 0
      U1 = S14ABF$(B, IFAIL1)
      IFAIL1 = 0
      U2 = S14ABF$(A + B, IFAIL1)
C*****ALBETA = ALNRPI + ALOGAM(B, IFAULT) - ALOGAM(A + B, IFAULT)
      ALBETA = ALNRPI + U1 - U2
      IFAIL1 = 0
      CALL G01EEF$(X, A, B, TOL, PP, QQ, PDF, IFAIL1)
C*****XODD = BETAIN(X, A, B, ALBETA, IFAULT)
      XODD = PP
      GODD = TWO * RXB * EXP(A * LOG(X) - ALBETA)
      XEVEN = ONE - RXB
      GEVEN = B * X * RXB
      TNC = P * XODD + Q * XEVEN
C
C     Repeat until convergence
C
   10 A = A + ONE
      XODD = XODD - GODD
      XEVEN = XEVEN - GEVEN
      GODD = GODD * X * (A + B - ONE) / A
      GEVEN = GEVEN * X * (A + B - HALF) / (A + HALF)
      P = P * LAMBDA / (TWO * EN)
      Q = Q * LAMBDA / (TWO * EN + ONE)
      S = S - P
      EN = EN + ONE
      TNC = TNC + P * XODD + Q * XEVEN
      ERRBD = TWO * S * (XODD - GODD)
      IF (ERRBD .GT. ERRMAX .AND. EN .LE. ITRMAX) GO TO 10
C
   20 IFAULT = 1
      IF (EN .GT. ITRMAX) THEN
         G01GBF$ = TNC
         IF (G01GBF$.LT.ZERO) THEN
            G01GBF$ = ZERO
         ELSEIF (G01GBF$.GT.ONE) THEN
            G01GBF$ = ONE
         ENDIF
         RETURN
      ENDIF
      IFAULT = 0
      IFAIL1 = 0
C*****TNC = TNC + ALNORM(DEL, .TRUE.)
      TNC = TNC + G01EAF$(TAIL, DEL, IFAIL1)
      IF (NEGDEL) TNC = ONE - TNC
C
      G01GBF$ = TNC
      IF (G01GBF$.LT.ZERO) THEN
         G01GBF$ = ZERO
      ELSEIF (G01GBF$.GT.ONE) THEN
         G01GBF$ = ONE
      ENDIF
      IFAIL1 = IFAULT!to stop ftn95 complaining
      RETURN
      END
C
C
