C
C
      DOUBLE PRECISION FUNCTION G01GCF$(X, DF, RLAMDA, TOL, MAXIT,
     +                                  IFAIL)
C
C ACTION: non-central chi-square
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 16/12/99
C
C******REAL FUNCTION CHI2NC(X, F, THETA, IFAULT)
C
C       ALGORITHM AS 275 APPL.STATIST. (1992), VOL.41, NO.2
C
C       Computes the noncentral chi-square distribution function
C       with positive real degrees of freedom f and nonnegative
C       noncentrality parameter theta
C
      IMPLICIT   NONE
      INTEGER    IFAIL, MAXIT
      INTEGER    IFAIL1, IFAULT
      INTEGER    ITRMAX
      DOUBLE PRECISION X, DF, RLAMDA, TOL
      DOUBLE PRECISION ALOGAM, CHI2NC, F, THETA
      DOUBLE PRECISION EPSI
      PARAMETER (EPSI = 1.0D-10)
      DOUBLE PRECISION S14ABF$
C
      DOUBLE PRECISION ERRMAX, ZERO, ONE, TWO, LAM, N, U, V, X2, F2,
     +                 T, TERM, BOUND
C
      LOGICAL    FLAG
      EXTERNAL   S14ABF$
      INTRINSIC  EXP, INT
C
C*****DATA ERRMAX, ITRMAX / 1.0E-6, 50 /
      DATA       ZERO, ONE, TWO / 0.0D+00, 1.0D+00, 2.0D+00 /
C
C
C Is it safe ?
C
      IFAIL = 0
      G01GCF$ = ZERO
      IF (DF.LT.ZERO .OR. RLAMDA.LT.ZERO .OR.
     +   (DF.LE.EPSI .AND. RLAMDA.LE.EPSI) .OR.
     +    X.LT.ZERO .OR. MAXIT.LT.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
      ERRMAX = TOL
      ITRMAX = MAXIT
      F = DF
      THETA = RLAMDA


      CHI2NC = X
      IFAULT = 2
C*****IF (F .LE. ZERO .OR. THETA .LT. ZERO) RETURN
C*****IFAULT = 3
C*****IF (X .LT. ZERO) RETURN
      IFAULT = 0
C*****IF (X .EQ. ZERO) RETURN
      LAM = THETA / TWO
C
C       Evaluate the first term
C
      N = ONE
      U = EXP(-LAM)
      V = U
      X2 = X / TWO
      F2 = F / TWO
C*****T = X2 ** F2 * EXP(-X2) / EXP(ALOGAM((F2 + ONE), IFAULT))
      IFAIL1 = 0
      ALOGAM = S14ABF$(F2 + ONE, IFAIL1)
      T = X2 ** F2 * EXP(-X2) / EXP(ALOGAM)
C
C       There is no need to test IFAULT si
C       already been checked
C
      TERM = V * T
      CHI2NC = TERM
C
C       Check if (f+2n) is greater than x
C
      FLAG = .FALSE.
   10 IF ((F + TWO * N - X) .LE. ZERO) GO TO 30
C
C       Find the error bound and check for convergence
C
      FLAG = .TRUE.
   20 BOUND = T * X / (F + TWO * N - X)
      IF (BOUND .GT. ERRMAX .AND. INT(N) .LE. ITRMAX) GO TO 30
      IF (BOUND .GT. ERRMAX) IFAULT = 1
      IF (IFAULT.EQ.1) IFAIL = 3
      G01GCF$ = CHI2NC
      IF (G01GCF$.LT.ZERO) THEN
         G01GCF$ = ZERO
      ELSEIF (G01GCF$.GT.ONE) THEN
         G01GCF$ = ONE
      ENDIF
      RETURN
C
C       Evaluate the next term of the expansion and then the
C       partial sum
C
   30 U = U * LAM / N
      V = V + U
      T = T * X / (F + TWO * N)
      TERM = V * T
      CHI2NC = CHI2NC + TERM
      N = N + ONE
      IF (FLAG) GO TO 20
      GO TO 10
      END
C
C
