C
C
      DOUBLE PRECISION FUNCTION G01GDF$(F, DF1, DF2, RLAMDA, TOL, MAXIT,
     +                                  IFAIL)
C
C ACTION: noncentral F
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 17/12/99
C         Tiko, Biometrika 53, 606-610 (1966)
C
      IMPLICIT NONE
      INTEGER  IFAIL, MAXIT
      INTEGER  IFAIL1
      DOUBLE PRECISION F, DF1, DF2, RLAMDA, TOL
      DOUBLE PRECISION A, B, X
      DOUBLE PRECISION ZBOT, ZTOP, Z0, Z1, Z2, Z3
      DOUBLE PRECISION G01GEF$, X02AMF$, G01EAF$
      DOUBLE PRECISION ZERO, ONE, TWO, NINE, BIG, TWOTHD, U
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           NINE = 9.0D+00, BIG = 1.0D+06,
     +           TWOTHD = 2.0D+00/3.0D+00)
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL G01GEF$, X02AMF$, G01EAF$
      INTRINSIC LOG, SQRT
      IFAIL = 0
      G01GDF$ = ZERO
      U = - TWO*LOG(X02AMF$())
      IF (DF1.LE.ZERO .OR. DF1.GT.BIG .OR.
     +    DF2.LE.ZERO .OR.
     +    F.LE.ZERO   .OR. RLAMDA.LT.ZERO .OR.
     +    MAXIT.LT.1 .OR. RLAMDA.GT.U) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (DF2.GT.BIG) THEN
         Z1 = DF1*F/(DF1 + RLAMDA)
         Z2 = TWO*(DF1 + TWO*RLAMDA)/(NINE*(DF1 + RLAMDA)**2)
         Z3 = TWO/(NINE*DF2)
         ZBOT = SQRT(Z2 + Z3*(Z1**TWOTHD))
         ZTOP = SQRT(Z1)*(ONE - Z3) - (ONE - Z2)
         Z0 = ZTOP/ZBOT
         IFAIL1 = 0
         G01GDF$ = G01EAF$(TAIL, Z0, IFAIL1)
      ELSE
         A = DF1/TWO
         B = DF2/TWO
         X = DF1*F/(DF1*F + DF2)
         G01GDF$ = G01GEF$(X, A, B, RLAMDA, TOL, MAXIT, IFAIL)
      ENDIF
      IF (G01GDF$.LT.ZERO) THEN
         G01GDF$ = ZERO
      ELSEIF (G01GDF$.GT.ONE) THEN
         G01GDF$ = ONE
      ENDIF
      END
C
C
