C
C
      DOUBLE PRECISION FUNCTION G01GEF$(X, A, B, RLAMDA, TOL, MAXIT,
     +                                  IFAIL)
C
C ACTION: Non-central beta by a development of AS226
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/12/99
C         Used S14ABF$ and G01DDEF$ instead of ALOGAM and BETAIN
C
C*****Original definition
C*****REAL FUNCTION BETANC(X, A, B, LAMBDA, IFAULT)
C
C     ALGORITHM AS226 APPL. STATIST. (1987) VOL. 36, NO. 2
C     Incorporates modification AS R84 from AS vol. 39, pp311-2, 1990
C
C     Returns the cumulative probability of X for the non-central beta
C     distribution with parameters A, B and non-centrality LAMBDA
C
C     Auxiliary routines required: ALOGAM - log-gamma function (ACM
C     291 or AS 245), and BETAIN - incomplete-beta function (AS 63)
C
C
      IMPLICIT  NONE
      INTEGER   IFAIL, MAXIT
      INTEGER   IFAIL1, IFAULT, ITRMAX
      DOUBLE PRECISION A, B, RLAMDA, TOL, X
      DOUBLE PRECISION TOL1, UMAX, X02AJF$, X02AMF$, S14ABF$
      DOUBLE PRECISION PDF, PP, QQ
      DOUBLE PRECISION AX, BETA, BETANC, C, ERRBD, ERRMAX, GX, HALF,
     +                 LAMBDA, ONE, Q, SUMQ, TEMP, XJ, ZERO
      DOUBLE PRECISION A0, X0, UALPHA, U1, U2, U3
      EXTERNAL  X02AJF$, X02AMF$, G01EEF$, S14ABF$
      INTRINSIC LOG, INT, SQRT, MAX, EXP
C
C     Now supplied in argument list except for UALPHA which stays at 5.0
C     Change ERRMAX and ITRMAX if desired ...
C
      DATA      UALPHA / 5.0D+00 /
      DATA      ZERO, HALF, ONE / 0.0D+00, 0.5D+00, 1.0D+00 /

      UMAX = - 2.0D+00*LOG(X02AMF$())
      G01GEF$ = ZERO
      IFAIL = 0
C
C Is it safe ?
C
      IF (A.LE.ZERO    .OR. A.GT.1.0D+06   .OR. B.LE.ZERO      .OR.
     +    B.GT.1.0D+06 .OR. RLAMDA.LT.ZERO .OR. RLAMDA.GT.UMAX .OR.
     +    X.LT.ZERO    .OR. X.GT.ONE       .OR. MAXIT.LT.1) THEN
          IFAIL = 1
          RETURN
      ENDIF
      ITRMAX = MAXIT
      ERRMAX = TOL
      LAMBDA = RLAMDA
      TOL1 = 10.0D+00*X02AJF$()
C
      BETANC = X
C
C*****IFAULT = 2
C*****IF (LAMBDA .LT. ZERO .OR. A .LE. ZERO .OR. B .LE. ZERO) RETURN
C*****IFAULT = 3
C*****IF (X .LT. ZERO .OR. X .GT. ONE) RETURN
      IFAULT = 0
C*****IF (X .EQ. ZERO .OR. X .EQ. ONE) RETURN
C
      C = LAMBDA * HALF
C
C     Initialize the series ...
C
      X0 = INT(MAX(C - UALPHA*SQRT(C), ZERO))
      A0 = A + X0
C*****BETA = ALOGAM(A0, IFAULT) + ALOGAM(B, IFAULT) -
C****+       ALOGAM(A0+B, IFAULT)
      IFAIL1 = 0
      U1 = S14ABF$(A0, IFAIL1)
      IFAIL1 = 0
      U2 = S14ABF$(B, IFAIL1)
      IFAIL1 = 0
      U3 = S14ABF$(A0 + B, IFAIL1)
      BETA = U1 + U2 - U3

C=======================================================================
C Note:
C Originally BETAIN required the complete beta function but it was
C subsequently modified to accept the log as in the next call

C*****TEMP = BETAIN(X, A0, B, BETA, IFAULT)

C========================================================================

      IFAIL1 = 0
      CALL G01EEF$(X, A0, B, TOL1, PP, QQ, PDF, IFAIL1)
      TEMP = PP
      GX = EXP(A0 * LOG(X) + B * LOG(ONE - X) - BETA - LOG(A0))
      IF (A0 .GT. A) THEN
C*******Q = EXP(-C + X0*LOG(C) - ALOGAM(X0 + ONE, IFAULT)
        IFAIL1 = 0
        U1 = S14ABF$(X0 + ONE, IFAIL1)
        Q = EXP(-C  + X0*LOG(C) - U1)
      ELSE
        Q = EXP(-C)
      END IF
      XJ = ZERO
      AX = Q * TEMP
      SUMQ = ONE - Q
      BETANC = AX
C
C     Recur over subsequent terms until convergence is achieved...
C
   10 XJ = XJ + ONE
      TEMP = TEMP - GX
      GX = X * (A + B + XJ - ONE) * GX / (A + XJ)
      Q = Q * C / XJ
      SUMQ = SUMQ - Q
      AX = TEMP * Q
      BETANC = BETANC + AX
C
C     Check for convergence and act accordingly...
C
      ERRBD = (TEMP - GX) * SUMQ
      IF ((INT(XJ) .LT. ITRMAX) .AND. (ERRBD .GT. ERRMAX)) GO TO 10
      IF (ERRBD .GT. ERRMAX) IFAULT = 1
C
      IF (IFAULT.EQ.1) IFAIL = 2
      G01GEF$ = BETANC
      IF (G01GEF$.LT.ZERO) THEN
         G01GEF$ = ZERO
      ELSEIF (G01GEF$.GT.ONE) THEN
         G01GEF$ = ONE
      ENDIF
      RETURN
      END
C
C
