C
C
      SUBROUTINE G02BAF$(N, M, X, IX, XBAR, STD, SSP, ISSP, R, IR,
     +                   IFAIL)
C
C ACTION : Correlation coefficients
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/3/97
C
C          IFAIL is not checked on entry so it is like IFAIL = 1
C
      IMPLICIT NONE
      INTEGER    IFAIL, IR, ISSP, IX, M, N
      DOUBLE PRECISION R(IR,M), SSP(ISSP,M), STD(M), X(IX,M), XBAR(M)
C
C Local variables
C
      INTEGER    I, J, K
      DOUBLE PRECISION ZERO, ONE, EPSI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPSI = 1.0D-300)
      DOUBLE PRECISION DN, DNM1, TEMP, XB, XJ, XK
      INTRINSIC  DBLE, SQRT
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LT.2) THEN
         IFAIL = 1
         RETURN
      ELSEIF (M.LT.2) THEN
         IFAIL = 2
         RETURN
      ELSEIF (IX.LT.N .OR. ISSP.LT.M .OR. IR.LT.M) THEN
         IFAIL = 3
         RETURN
      ENDIF
C
C Initialise all variables to be calculated as sums
C
      DO I = 1, M
         STD(I) = ZERO
         XBAR(I) = ZERO
         DO J = 1, M
            R(J,I) = ZERO
            SSP(J,I) = ZERO
         ENDDO
      ENDDO
C
C XBAR
C
      DN = DBLE(N)
      DNM1 = DN - ONE
      DO I = 1, M
         DO J = 1, N
            XBAR(I) = XBAR(I) + X(J,I)
         ENDDO
         XBAR(I) = XBAR(I)/DN
      ENDDO
C
C STD
C
      DO I = 1, M
         XB = XBAR(I)
         DO J = 1, N
            STD(I) = STD(I) + (X(J,I) - XB)**2
         ENDDO
         STD(I) = SQRT(STD(I)/DNM1)
      ENDDO
C
C SSP
C
      DO J = 1, M
         DO K = J, M
            XJ = XBAR(J)
            XK = XBAR(K)
            DO I = 1, N
               SSP(J,K) = SSP(J,K) + (X(I,J) - XJ)*(X(I,K) - XK)
            ENDDO
            IF (J.NE.K) SSP(K,J) = SSP(J,K)
         ENDDO
      ENDDO

C
C R
C
      DO J = 1, M
         R(J,J) = ONE
         DO K = J + 1, M
            TEMP = SQRT(SSP(J,J)*SSP(K,K))
            IF (TEMP.GT.EPSI) R(J,K) = SSP(J,K)/TEMP
            R(K,J) = R(J,K)
         ENDDO
      ENDDO
      END
C
C
