      
C
C G02BNF$ ... replacement for NAG G02BNF
C G02BNF1 ... version of RANKER (but returning two factors)
C G02BNF2 ... replaced by INDEXR
C G02BNF3 ... replaced by RANKER
C
      SUBROUTINE G02BNF$(N, M, X, IX, ITYPE, RR, IRR, KWORKA, KWORKB,
     +                   WORK1, WORK2, IFAIL)
C
C ACTION : Spearman and Kendall nonparametric correlations
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 21/3/97
C          24/09/2012 extensive revision
C
C          IFAIL is not tested on entry so it is like IFAIL = 1
C
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    IFAIL, IRR, ITYPE, IX, N, M
      INTEGER    KWORKA(N), KWORKB(N)
      DOUBLE PRECISION RR(IRR,M), WORK1(M), WORK2(M), X(IX,M)
C
C Allocatable
C   
      DOUBLE PRECISION, ALLOCATABLE :: Y(:), Z(:)   
C
C Local variables
C
      INTEGER    I, IERR, J, K, L
      DOUBLE PRECISION ZERO, HALF, ONE, SIX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           SIX = 6.0D+00)
      DOUBLE PRECISION DENOM, EPSI, FACTOR(2)
      PARAMETER (EPSI = 1.0D-150)
      DOUBLE PRECISION D1, D2, TK, TS, U1, U2
      EXTERNAL   G02BNF1
      INTRINSIC  ABS, SQRT, DBLE
C
C Check the input parameters
C
      KWORKA(1) = 0
      KWORKB(1) = 0
      IF (N.LT.2) THEN
         IFAIL = 1
         RETURN
      ELSEIF (M.LT.2) THEN
         IFAIL = 2
         RETURN
      ELSEIF (IX.LT.N .OR. IRR.LT.M) THEN
         IFAIL = 3
         RETURN
      ELSEIF (ITYPE.LT.-1 .OR. ITYPE.GT.1) THEN
         IFAIL = 4
         RETURN
      ENDIF
      IFAIL = -100
      IERR = 0
      IF (ALLOCATED(Y)) DEALLOCATE(Y, STAT = IERR)
      IF (IERR.NE.0) RETURN
      J = N  
      ALLOCATE (Y(J), STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(Z)) DEALLOCATE(Z, STAT = IERR)
      IF (IERR.NE.0) RETURN
      J = N  
      ALLOCATE (Z(J), STAT = IERR)
      IF (IERR.NE.0) RETURN      
C
C Replace X by ranks and save TK and TS in workspace
C
      IFAIL = 0
      DO J = 1, M
         DO I = 1, N
            Y(I) = X(I,J)
         ENDDO   
         CALL G02BNF1 (N,
     +                 Y, FACTOR, Z)
         DO I = 1, N
            X(I,J) = Z(I)
         ENDDO
         TS = FACTOR(1)            
         TK = FACTOR(2)
         WORK1(J) = TK
         WORK2(J) = TS
      ENDDO
C
C Calculate D1 and D2
C
      D1 = DBLE(N*(N - 1))
      D2 = DBLE(N*(N**2 - 1))
C
C Kendall's tau in lower triangle if ITYPE .LE. 0
C
      IF (ITYPE.LE.0) THEN
         DO J = 1, M
c            RR(J,J) = ONE
            DO K = 1, M - 1
               RR(J,K) = ZERO
               DO I = 1, N
                  DO L = 1, N
                     U1 = X(L,J) - X(I,J)
                     IF (U1.GT.ZERO) THEN
                        U1 = ONE
                     ELSEIF (U1.LT.ZERO) THEN
                        U1 = - ONE
                     ELSE
                        U1 = ZERO
                     ENDIF
                     U2 = X(L,K) - X(I,K)
                     IF (U2.GT.ZERO) THEN
                        U2 = ONE
                     ELSEIF (U2.LT.ZERO) THEN
                        U2 = - ONE
                     ELSE
                        U2 = ZERO
                     ENDIF
                     RR(J,K) = RR(J,K) + U1*U2
                  ENDDO
               ENDDO
               DENOM = SQRT(ABS((D1 - WORK1(J))*(D1 - WORK1(K))))
               IF (DENOM.GT.EPSI) THEN
                  RR(J,K) = RR(J,K)/DENOM
               ELSE
                  RR(J,K) = ZERO
               ENDIF
C
C Fill in upper triangle if ITYPE = - 1
C
               IF (ITYPE.EQ.-1) RR(K,J) = RR(J,K)
            ENDDO
            RR(J,J) = ONE
         ENDDO
      ENDIF
C
C Spearmans in upper triangle if ITYPE .GE. 0
C
      IF (ITYPE.GE.0) THEN
         DO J = 1, M
c            RR(J,J) = ONE
            DO K = J + 1, M
               RR(J,K) = ZERO
               DO I = 1, N
                  RR(J,K) = RR(J,K) + (X(I,J) - X(I,K))**2
               ENDDO
               RR(J,K) = D2 - SIX*RR(J,K) - HALF*(WORK2(J) + WORK2(K))
               DENOM = SQRT(ABS((D2 - WORK2(J))*(D2 - WORK2(K))))
               IF (DENOM.GT.EPSI) THEN
                  RR(J,K) = RR(J,K)/DENOM
               ELSE
                  RR(J,K) = ZERO
               ENDIF
C
C Fill in lower triangle if ITYPE = 1
C
               IF (ITYPE.EQ.1) RR(K,J) = RR(J,K)
            ENDDO
            RR(J,J) = ONE
         ENDDO
      ENDIF
      DEALLOCATE(Y, STAT = IERR)
      DEALLOCATE(Z, STAT = IERR)
      END
C
C----------------------------------------------------------------------
C
      SUBROUTINE G02BNF1 (N, 
     +                    DATA1, FACTOR, RANK)
C
C ACTION : Calculate ranks and correction factors
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          24/09/2012 developed from RANKIT for use by G02BNF$
C
C              N: (input/unchanged)
C          DATA1: (input/unchanged)
C         FACTOR: (output) tie correction factors
C           RANK: (output) ranks for DATA1
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)  :: N
      DOUBLE PRECISION, INTENT (IN)  :: DATA1(N)
      DOUBLE PRECISION, INTENT (OUT) :: FACTOR(2), RANK(N)
C
C Allocatable
C      
      INTEGER, ALLOCATABLE :: IX(:), IR(:) 
C
C Locals
C
      INTEGER    I, IERR, J, NSTART, NSTOP, NTIES
      INTEGER    N1
      PARAMETER (N1 = 1)
      DOUBLE PRECISION TEMP, XTIE
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL   ACTION
      EXTERNAL  INDEXR, RANKER
      INTRINSIC DBLE
C
C Error exit if N =< 1
C
      FACTOR(1) = ZERO
      FACTOR(2) = ZERO
      DO I = 1, N
         RANK(I) = ZERO
      ENDDO   
      IF (N.LE.N1) RETURN
C
C Allocate
C  
      IERR = 0
      IF (ALLOCATED(IX)) DEALLOCATE(IX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(IR)) DEALLOCATE(IR, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      J = N
      ALLOCATE (IX(J), STAT = IERR)  
      IF (IERR.NE.0) RETURN 
      ALLOCATE (IR(J), STAT = IERR)  
      IF (IERR.NE.0) RETURN
C
C Get the index IX
C        
      CALL INDEXR (IX, N,
     +              DATA1)
C
C Get the ranks IR
C     
      CALL RANKER (IX, IR, N)
C
C Initialise RANK
C      
      DO I = 1, N
         RANK(I) = DBLE(IR(I))
      ENDDO
C
C Search for ties by looping up through nondecreasing data values
C      
      ACTION = .FALSE.        
      NSTART = 0
      NSTOP = 0
      NTIES = 0
        DO I = 2, N
         IF (DATA1(IX(I)).GT.DATA1(IX(I - 1))) THEN
C
C The data are increasing at this point
C           
            IF (ACTION) THEN
C
C Existing ties have to be handled
C              
               ACTION = .FALSE.
               XTIE = DBLE(NTIES + 1)
               TEMP = TEMP + RANK(IX(I - 1))
               TEMP = TEMP/XTIE
               FACTOR(1) = FACTOR(1) + XTIE*(XTIE**2 - ONE)
               FACTOR(2) = FACTOR(2) + XTIE*(XTIE - ONE)
               NSTOP = I - 1
               DO J = NSTART, NSTOP
                  RANK(IX(J)) = TEMP  
               ENDDO  
               NTIES = 0
            ENDIF     
         ELSE
C
C The data are not increasing at this point
C           
            ACTION = .TRUE.
            IF (NTIES.EQ.0) THEN
               NTIES = 1
               NSTART = I - 1
               TEMP = RANK(IX(I - 1))
            ELSE
               NTIES = NTIES + 1
               TEMP = TEMP + RANK(IX(I - 1))
            ENDIF 
            IF (I.EQ.N) THEN
C
C Special action is required if it is the last point
C              
               NSTOP = N 
               XTIE = DBLE(NTIES + 1)
               TEMP = TEMP + RANK(IX(I))
               TEMP = TEMP/XTIE
               FACTOR(1) = FACTOR(1) + XTIE*(XTIE**2 - ONE)
               FACTOR(2) = FACTOR(2) + XTIE*(XTIE - ONE)
               NSTOP = N
               DO J = NSTART, NSTOP
                  RANK(IX(J)) = TEMP  
               ENDDO
            ENDIF   
         ENDIF
      ENDDO  
      DEALLOCATE (IX, STAT = IERR)
      DEALLOCATE (IR, STAT = IERR)
      END
C
C
    


      




