C                
C Includes auxiliary routine BYFG02$
C ---------------------------------- 
C
      SUBROUTINE G02BYF$(M, NY, NX, ISZ, R, LDR, P, LDP, WK, IFAIL)      
C
C ACTION: substitute for G02BYF
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 08/11/2006
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    M, NY, NX, ISZ(M), LDR, LDP, IFAIL
      DOUBLE PRECISION R(LDR,M), P(LDP,NY), WK(NY*NX + NX*(NX + 1)/2)  
C
C Locals
C      
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      INTEGER    I, II, J, JJ, K, NBIG, NCOL, NPOS, NROW, NUMX1,
     +           NUMX2, NUMY1, NUMY2 
      INTEGER    IXX, IXY, IYY
      EXTERNAL   BYFG02$  
      INTRINSIC  MAX, MIN
C
C Initialise IFAIL then check input arguments
C      
      IFAIL = 0
      IF ( M.LT.3      .OR.
     +    NY.LT.2      .OR.      
     +    NX.LT.1      .OR.
     +    NY + NX.GT.M .OR.
     +    LDR.LT.M     .OR.
     +    LDP.LT.NY) THEN
         IFAIL = 1
         RETURN
      ENDIF 
      J = 0
      K = 0
      DO I = 1, M 
         IF (ISZ(I).GT.0) THEN
            J = J + 1
         ELSEIF (ISZ(I).LT.0) THEN
            K = K + 1
         ENDIF      
      ENDDO   
      IF (J.NE.NX .OR. K.NE.NY) THEN
         IFAIL = 2
         RETURN
      ENDIF    
C
C Zeroise the arrays (not really necessary) then counters (mandatory)
C      
      DO J = 1, NY
         DO I = 1, NY
            P(I,J) = ZERO
         ENDDO
      ENDDO          
      DO I = 1, NX*NY + NX*(NX + 1)/2
         WK(I) = ZERO        
      ENDDO
      IXX = 0
      IXY = NX*(NX + 1)/2
      IYY = 0
      II = 1 
      JJ = 0 
      NBIG = NX*(NX + 1)/2
C
C Manipulate R as follows:
C ------------------------
C 1) Copy XX into the first NX*(NX + 1)/2 positions of WK   
C    as an upper triangle by columns
C 2) Copy YY into the lower triangle of supplied matrix P
C 3) Copy XY into positions NX*(NX + 1)/2 + 1 to NX*NY of WK   
C    as full column major order for a NX by NY matrix
C
C NUMX1 and NUMY1 index the X and Y variables progressivley across the columns   
C NUMX2 and NUMY2 index the X and Y variables dynamically down the rows 
C                 
      NUMX1 = 0
      NUMY1 = 0
      DO J = 1, M 
         IF (ISZ(J).GT.0) THEN 
C
C variable j is an X-variable
C ===========================
C           
            NUMX1 = NUMX1 + 1
            NUMX2 = 0
            NUMY2 = 0                    
            DO I = 1, J  
               IF (ISZ(I).GT.0) THEN 
C
C Store as for XX matrix upper triangle
C               
                  IXX = IXX + 1
                  NUMX2 = NUMX2 + 1  
                  NCOL = MAX(NUMX1,NUMX2)
                  NROW = MIN(NUMX1,NUMX2)
                  NPOS = NCOL*(NCOL - 1)/2 + NROW
                  WK(NPOS) = R(I,J) 
               ELSEIF (ISZ(I).LT.0) THEN 
C
C Store as for XY matrix in column major order
C               
                  IXY = IXY + 1
                  NUMY2 = NUMY2 + 1
                  NROW = NUMX1   
                  NCOL = NUMY2  
                  NPOS = NBIG + NROW + (NCOL - 1)*NX
                  WK(NPOS) = R(I,J)
               ENDIF   
            ENDDO
         ELSEIF (ISZ(J).LT.0) THEN 
C
C variable j is a Y-variable 
C ==========================
C                         
            NUMY1 = NUMY1 + 1 
            NUMX2 = 0
            NUMY2 = 0
            DO I = 1, J
               IF (ISZ(I).GT.0) THEN
C
C Store as for XY matrix in column major order
C               
                  IXY = IXY + 1 
                  NUMX2 = NUMX2 + 1   
                  NCOL = NUMY1
                  NROW = NUMX2
                  NPOS = NBIG + NROW + (NCOL - 1)*NX
                  WK(NPOS) = R(I,J)
               ELSEIF (ISZ(I).LT.0) THEN
C
C Store as for YY matrix in lower triangular order
C               
                  IYY = IYY + 1
                  NUMY2 = NUMY2 + 1
                  II = MAX(NUMY1,NUMY2)
                  JJ = MIN(NUMY1,NUMY2)
                  P(II,JJ) = R(I,J)   
               ENDIF   
            ENDDO
         ENDIF
      ENDDO     
C
C Call BYFG02$ for rest of calculations
C      
      CALL BYFG02$(IFAIL, IXX, IXY, IYY, LDP, NX, NY,
     +             P, WK)                 
      END
C
C
C-------------------------------------------------------------------                                              
C
C
      SUBROUTINE BYFG02$(IFAIL, IXX, IXY, IYY, LDP, NX, NY,
     +                   P, WK)
C
C ACTION: Auxiliary routine for G02BYF$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 08/11/2006
C         This is very much a preliminary effort and can easily
C         be improved when I get the time as it is over-dimensioned
C         in that local arrays of size (LDC,LDC) are allocated
C         rather than using the workspace supplied. It is easier to
C         use LAPACK with matrices and less error prone than 
C         struggling to minimise storage when I am in a hurry.  
C 
      IMPLICIT NONE  
C
C Arguments
C      
      INTEGER  IFAIL, IXX, IXY, IYY, LDP, NX, NY
      DOUBLE PRECISION P(LDP,NY), WK(NY*NX + NX*(NX + 1)/2)
C
C Local allocatable arrays
C                                
      DOUBLE PRECISION, ALLOCATABLE :: C(:,:), XX(:,:), XY(:,:)
C
C Locals
C      
      INTEGER    I, IERR, J, K, LDC, M, N 
      DOUBLE PRECISION ALPHA, BETA, ZERO, ONE
      PARAMETER (ALPHA = 1.0D+00, BETA = 0.0D+00,
     +           ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  UPLO*1, TRANSA*1, TRANSB*1
      LOGICAL    SHOWIT
      EXTERNAL   DPOTRF, DPOTRI, DGEMM
      INTRINSIC  MAX, SQRT
C
C Check that IXX = NX*(NX + 1)/2
C            IYY = NY*(NY + 1)/2   
C            IXY = NX*(NX + 1)/2 + NX*NY    
C i.e. all the data has been accounted for
C                    
      SHOWIT = .FALSE. 
      IF (IXX.NE.NX*(NX + 1)/2) THEN
         IFAIL = 10
         RETURN
      ENDIF 
      IF (IYY.NE.NY*(NY + 1)/2) THEN
         IFAIL = 11
         RETURN
      ENDIF
      K = NX*(NX + 1)/2 + NX*NY                     
      IF (IXY.NE.K) THEN
         IFAIL = 12
         RETURN
      ENDIF
C
C Allocate workspace for XX and XY
C                    
      LDC = MAX(NX,NY)
      IERR = 0
      ALLOCATE(XX(LDC,LDC), STAT = IERR)   
      IF (IERR.NE.0) THEN
         IFAIL = 13 
         RETURN    
      ENDIF 
      ALLOCATE(XY(LDC,LDC), STAT = IERR)   
      IF (IERR.NE.0) THEN
         IFAIL = 14 
         RETURN    
      ENDIF  
C
C Fill in XX and XY
C         
      K = 0
      DO J = 1, NX 
         DO I = 1, J  
            K = K + 1
            XX(I,J) = WK(K)
            IF (J.NE.I) XX(J,I) = XX(I,J)
         ENDDO
      ENDDO       
      K = NX*(NX + 1)/2
      DO J = 1, NY 
         DO I = 1, NX  
            K = K + 1
            XY(I,J) = WK(K)
         ENDDO
      ENDDO   
      IF (SHOWIT) THEN 
         WRITE (*,'(A)') 'XX......' 
         DO I = 1, NX
            WRITE (*,'(50f8.4)') (XX(I,J), J = 1, NX)
         ENDDO    
         WRITE (*,'(A)') 'YY......'
         DO I = 1, NY  
            WRITE (*,'(50f8.4)') (P(I,J), J = 1, NY) 
         ENDDO
         WRITE (*,'(A)') 'XY......'   
         DO I = 1, NX 
            WRITE (*,'(50f8.4)') (XY(I,J), J = 1, NY)
         ENDDO
      ENDIF                  
C
C Cholesky factors of XX
C  
      UPLO = 'U'    
      CALL DPOTRF (UPLO, NX, XX, LDC, IERR)
      IF (IERR.NE.0) THEN
         DEALLOCATE(XX, STAT = IERR)
         DEALLOCATE(XY, STAT = IERR)
         IFAIL = 3
         RETURN
      ENDIF        
C
C Inverse of XX
C               
      UPLO = 'U'
      CALL DPOTRI (UPLO, NX, XX, LDC, IERR) 
      IF (IERR.NE.0) THEN
         IFAIL = 3 
         DEALLOCATE(XX, STAT = IERR)
         DEALLOCATE(XY, STAT = IERR)
         RETURN
      ENDIF    
      DO I = 2, NX
         DO J = 1, I - 1
            XX(I,J) = XX(J,I)
         ENDDO
      ENDDO     
C
C Allocate C
C                                  
      IERR = 0
      ALLOCATE(C(LDC,LDC), STAT = IERR)
      IF (IERR.NE.0) THEN
         DEALLOCATE(C, STAT = IERR) 
         DEALLOCATE(XX, STAT = IERR)
         DEALLOCATE(XY, STAT = IERR)
         IFAIL = 15
         RETURN 
      ENDIF                     
C
C Define C(NX by NY) = (XX^{-1}*XY) where XX is NX by NX and XY is NX by NY        
C     
      TRANSA = 'N'   
      TRANSB = 'N'              
      M = NX 
      N = NY
      K = NX
      CALL DGEMM (TRANSA, TRANSB, M, N, K, ALPHA, XX, LDC, XY, LDC,
     +            BETA, C, LDC) 
C
C Define XX(NY by NY) = XY^{T}*(XX^{-1}*XY) 
C                 
      TRANSA = 'T'   
      TRANSB = 'N'              
      M = NY 
      N = NY
      K = NX
      CALL DGEMM (TRANSA, TRANSB, M, N, K, ALPHA, XY, LDC, C, LDC,
     +            BETA, XX, LDC)  
      DO I = 1, NY
         DO J = 1, I  
            P(I,J) = P(I,J) - XX(I,J)
         ENDDO
      ENDDO  
      DO J = 2, NY
         DO I = 1, J - 1  
            IF (P(I,I).LE.ZERO .OR. P(J,J).LE.ZERO) THEN
               IFAIL = 4
               DEALLOCATE(C, STAT = IERR) 
               DEALLOCATE(XX, STAT = IERR) 
               DEALLOCATE(XY, STAT = IERR) 
               RETURN   
            ENDIF   
            P(I,J) = P(J,I)/SQRT(P(I,I)*P(J,J)) 
            IF (P(I,J).LT. - ONE .OR. P(I,J).GT.ONE) THEN
               IFAIL = 4
               DEALLOCATE(C, STAT = IERR) 
               DEALLOCATE(XX, STAT = IERR) 
               DEALLOCATE(XY, STAT = IERR) 
               RETURN   
            ENDIF   
         ENDDO 
      ENDDO 
      DEALLOCATE(C, STAT = IERR) 
      DEALLOCATE(XX, STAT = IERR) 
      DEALLOCATE(XY, STAT = IERR)     
      END     
C
C      