C
C
      SUBROUTINE G02CAF$(N, X, Y, RESUL, IFAIL)
C
C ACTION : Simple linear regression
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 19/2/97
C
C          This subroutine is not very carefully sculptured for
C          accuracy and can easily be improved to increase both
C          the execution speed and accuracy. In particular the
C          error trapping is not very sophisticated and I hope
C          to revise it all eventually.
C
C          There is no test for IFAIL on entry so it is like IFAIL = 1
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      DOUBLE PRECISION X(N), Y(N), RESUL(20)
C
C Local variables
C
      INTEGER    I
      DOUBLE PRECISION ZERO, EPSI, EPSI10, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-150, EPSI10 = 1.0D+10*EPSI,
     +           ONE = 1.0D+00)
      DOUBLE PRECISION A, B, DFT, DFD, DN, DFR, F, P, R, RMSD, RMSR,
     +                 SEA, SEB, SSD, SSR, SST, SX, SY, TA, TB, XBAR,
     +                 YBAR
      LOGICAL    SAFE
      INTRINSIC  DBLE, SQRT
C
C Initialise
C
      IFAIL = 0
      DO I = 1, 20
         RESUL(I) = ZERO
      ENDDO
      IF (N.LE.2) THEN
         IFAIL = 1
         RETURN
      ENDIF
      DN = DBLE(N)
      DFT = DN - ONE
      DFD = DFT - ONE
      DFR = ONE
      R = ZERO
      B = ZERO
      F = ZERO
      SEB = ZERO
      SEA = ZERO
      TB = ZERO
      TA = ZERO
C
C XBAR, YBAR, SX and SY
C
      XBAR = ZERO
      YBAR = ZERO
      DO I = 1, N
         XBAR = XBAR + X(I)
         YBAR = YBAR + Y(I)
      ENDDO
      XBAR = XBAR/DN
      YBAR = YBAR/DN
      SX = ZERO
      SY = ZERO
      DO I = 1, N
         SX = SX + (XBAR - X(I))**2
         SY = SY + (YBAR - Y(I))**2
      ENDDO
      IF (SX.LE.EPSI .OR. SY.LE.EPSI) THEN
         IFAIL = 2
         RETURN
      ENDIF
      SX = SQRT(SX/DFT)
      SY = SQRT(SY/DFT)
      IF (SX.GT.EPSI10) THEN
         SAFE = .TRUE.
      ELSE
         SAFE = .FALSE.
      ENDIF
C
C P and R
C
      P = ZERO
      DO I = 1, N
         P = P + (X(I) - XBAR)*(Y(I) - YBAR)
      ENDDO
      IF (SAFE) R = P/(DFT*SX*SY)
C
C A and B
C
      IF (SAFE) B = P/(DFT*SX**2)
      A = YBAR - B*XBAR
C
C SST, SSD, SSR, RMSR, RMSD and F
C
      SST = DFT*SY**2
      SSD = ZERO
      DO I = 1, N
         SSD = SSD + (Y(I) - A - B*X(I))**2
      ENDDO
      SSR = SST - SSD
      RMSR = SSR/DFR
      RMSD = SSD/DFD
      IF (RMSD.GT.EPSI10) F = RMSR/RMSD
C
C SEA, SEB, TA and TB
C
      IF (SAFE) THEN
         SEB = SQRT(RMSD)/(SQRT(DFT)*SX)
         SEA = SQRT(RMSD*(ONE/DN + XBAR**2/(DFT*SX**2)))
      ENDIF
      IF (SEB.GT.EPSI10) TB = B/SEB
      IF (SEA.GT.EPSI10) TA = A/SEA
C
C RESULS
C
      RESUL(1) = XBAR
      RESUL(2) = YBAR
      RESUL(3) = SX
      RESUL(4) = SY
      RESUL(5) = R
      RESUL(6) = B
      RESUL(7) = A
      RESUL(8) = SEB
      RESUL(9) = SEA
      RESUL(10) = TB
      RESUL(11) = TA
      RESUL(12) = SSR
      RESUL(13) = DFR
      RESUL(14) = RMSR
      RESUL(15) = F
      RESUL(16) = SSD
      RESUL(17) = DFD
      RESUL(18) = RMSD
      RESUL(19) = SST
      RESUL(20) = DFT
      END
C
C
