C
C G02GBF$: wgb version
C ====================
C This file contains G02GBF$, GLIMB1 and GLIMB2
C G02GBF$ calls G02GLIM which calls GLIMB1 and GLIMB2
C ===================================================
C

C
C
      SUBROUTINE G02GBF$(LINK, MEAN, OFFSET, WEIGHT, N, X, LDX, M, ISX,
     +                   IP, Y, T, WT, DEV, IDF, B, IRANK, SE, COV,
     +                   V, LDV, TOL, MAXIT, IPRINT, EPS, WK, IFAIL)
C
C ACTION: Replacement for NAG GLIM routine
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/07/2000
C         18/05/2002 revised IFAIL = 6
C         12/07/2002 revised for calculation of offsets
C         19/04/2006 initialised IRANK = 0, etc and changed tests for IFAIL = 6 
C
C         Error type
C         ==========
C         NTYPE = 2: Binomial errors
C
C         Link type
C         =========
C         LTYPE = 1: Logistic
C         LTYPE = 2: Probit
C         LTYPE = 3: Complementary log-log
C
      IMPLICIT   NONE
      INTEGER    N, LDX, M, ISX(M), IP, IDF, IRANK, LDV, MAXIT, IPRINT,
     +           IFAIL
      INTEGER    NTYPE
      PARAMETER (NTYPE = 2)
      INTEGER    LTYPE
      INTEGER    I, J, K, MAXIT1
      DOUBLE PRECISION X(LDX,M), Y(N), T(N), WT(*), DEV, B(IP),
     +                 SE(IP), COV(IP*(IP + 1)/2), TOL, V(LDV,IP + 7),
     +                 EPS, WK((IP*IP + 3*IP + 22)/2)
      DOUBLE PRECISION A, HATMU, RSS, S
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  LINK*1, MEAN*1, OFFSET*1, WEIGHT*1
      LOGICAL    M1, O1, W1
      EXTERNAL   G02GLIM
C
C Initialise
C            
      IFAIL = 0            
      IDF = 0
      IRANK = 0
      DO I = 1, IP
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO    
      DO I = 1, IP*(IP + 1)/2
         COV(I) = ZERO
      ENDDO
      DO J = 1, IP + 7
         IF (J.NE.7) THEN
            DO I = 1, N
               V(I,J) = ZERO
            ENDDO
         ENDIF   
      ENDDO   
      DEV = ZERO
C
C Is it safe ?
C
      IF (N.LT.2      .OR.
     +    M.LT.1      .OR.
     +    LDX.LT.N    .OR.
     +    LDV.LT.N    .OR.
     +    IP.LT.1     .OR.
     +    MAXIT.LT.0  .OR.
     +    TOL.LT.ZERO .OR.
     +    EPS.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (LINK.EQ.'G' .OR. LINK.EQ.'g') THEN
         LTYPE = 1
      ELSEIF (LINK.EQ.'P' .OR. LINK.EQ.'p') THEN
         LTYPE = 2
      ELSEIF (LINK.EQ.'C' .OR. LINK.EQ.'c') THEN
         LTYPE = 3
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
         M1 = .TRUE.
         J = 1
      ELSEIF (MEAN.EQ.'Z' .OR. MEAN.EQ.'z') THEN
         M1 = .FALSE.
         J = 0
      ELSE
          IFAIL = 1
          RETURN
      ENDIF
      IF (OFFSET.EQ.'Y' .OR. OFFSET.EQ.'y') THEN
         O1 = .TRUE.
      ELSEIF (OFFSET.EQ.'N' .OR. OFFSET.EQ.'n') THEN
         O1 = .FALSE.
      ELSE
          IFAIL = 1
          RETURN
      ENDIF
      IF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         W1 = .FALSE.
      ELSEIF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         W1 = .TRUE.
      ELSE
          IFAIL = 1
          RETURN
      ENDIF
      IF (W1) THEN
         K = 0
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ELSEIF (WT(I).GT.ZERO) THEN
               K = K + 1
            ENDIF
         ENDDO
      ELSE
         K = N
      ENDIF
      DO I = 1, M
         IF (ISX(I).LT.0) THEN
            IFAIL = 3
            RETURN
         ELSEIF (ISX(I).GT.0) THEN
            J = J + 1
         ENDIF
      ENDDO
      IF (J.NE.IP) THEN
         IFAIL =  3
         RETURN
      ENDIF
      IF (IP.GT.K) THEN
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 1, N
         IF (T(I).LT.ZERO) THEN
             IFAIL = 4
             RETURN
         ENDIF
         IF (Y(I).LT.ZERO .OR. Y(I).GT.T(I)) THEN
            IFAIL = 5
            RETURN
         ENDIF
      ENDDO
      IDF = K - J
C
C Transfer control to the GLIM interface
C
      IF (MAXIT.GE.10) THEN
         MAXIT1 = MAXIT
      ELSE
         MAXIT1 = 10
      ENDIF       
      A = ZERO
      S = ZERO
      CALL G02GLIM(IDF, IFAIL, IP, IPRINT, IRANK, ISX, LDV, LDX, LTYPE,
     +             M, MAXIT1, N, NTYPE,
     +             A, B, COV, DEV, EPS, RSS, S, SE, T, TOL, V, WK, WT,
     +             X, Y,
     +             M1, O1, W1)
C
C Test IDF
C     
      IF (IFAIL.EQ.0 .AND. IDF.EQ.0) IFAIL = 10 
C
C Test for IFAIL = 6
C      
      IF (IFAIL.EQ.0) THEN 
          IF (W1) THEN
             DO I = 1, N 
                IF (WT(I).GT.ZERO) THEN
                   HATMU = V(I,2)
                   IF (HATMU.LE.ZERO .OR. HATMU.GE.T(I)) THEN
                      IFAIL = 6
                      RETURN
                   ENDIF   
                ENDIF
             ENDDO
          ELSE
             DO I = 1, N
                HATMU = V(I,2)
                IF (HATMU.LE.ZERO .OR. HATMU.GE.T(I)) THEN
                   IFAIL = 6
                   RETURN
                ENDIF   
             ENDDO
          ENDIF
      ENDIF
      END
C 
C......................................................................
C
      SUBROUTINE GLIMB1 (ICOUNT, IFAIL, LTYPE, MFREE, NFREE, NRHS, LDA,
     +                   LDB,
     +                   ANEW, ATEMP, BNEW, BTEMP, OFFNEW, TAU, TNEW,
     +                   WNEW, WRKWT, YNEW)
C
C ACTION: Generate Z ... Binomial errors
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/07/2000
C         14/04/2006 revised procedures to test for IFAIL = 6  
C
      IMPLICIT NONE
      INTEGER  ICOUNT, IFAIL, LTYPE, MFREE, NFREE, NRHS, LDA, LDB
      INTEGER  I, J
      DOUBLE PRECISION ANEW(LDA,MFREE), ATEMP(LDA,MFREE),
     +                 BNEW(MFREE), BTEMP(LDB,NRHS),
     +                 OFFNEW(NFREE), TAU(NFREE), TNEW(NFREE),
     +                 WNEW(NFREE), WRKWT(NFREE), YNEW(NFREE)
      DOUBLE PRECISION ETA, MU, DETADMU, ROOT, T, T1, W, Y, Y1, Z
      DOUBLE PRECISION ARG, BOT, TEMP, TOP
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION EMAX, EMIN, RTOL
      PARAMETER (EMAX = 100.0D+00, EMIN = - EMAX, RTOL = 1.0D-100)
      DOUBLE PRECISION R2PI
      PARAMETER (R2PI = 2.5066283D+00)
      DOUBLE PRECISION G01EAF$, G01FAF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   G01EAF$, G01FAF$
      INTRINSIC  LOG, EXP, SQRT, MAX
      IF (LTYPE.EQ.1) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            T = TNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.LE.ZERO .OR. Y.GE.T) THEN
                  Y1 = Y + HALF
                  T1 = T + ONE
               ELSE
                  Y1 = Y
                  T1 = T
               ENDIF
               MU = Y1
               ETA = LOG(Y1/(T1 - Y1))
               DETADMU = T1/(Y1*(T1 - Y1))
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               ARG = - ETA
               IF (ARG.LT.EMIN) THEN
                  ARG = EMIN
               ELSEIF (ARG.GT.EMAX) THEN
                  ARG = EMAX
               ENDIF
               MU = T/(ONE + EXP(ARG))
               IF (MU.LT.RTOL) THEN
                  MU = RTOL
               ELSEIF (MU.GT.T - RTOL) THEN
                  MU = T - RTOL
               ENDIF       
               TOP = T
               BOT = MAX(RTOL, MU*(T - MU))
               DETADMU = TOP/BOT
            ENDIF
            TAU(I) = ONE/SQRT(DETADMU)
            WRKWT(I) = DETADMU
            W = WNEW(I)*WRKWT(I)
            ROOT = SQRT(W)
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.2) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            T = TNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.LE.ZERO .OR. Y.GE.T) THEN
                  Y1 = Y + HALF
                  T1 = T + ONE
               ELSE
                  Y1 = Y
                  T1 = T
               ENDIF
               MU = Y1
               ARG = Y1/T1
               ETA = G01FAF$(TAIL, ARG, IFAIL)
               ARG = HALF*ETA**2
               DETADMU = R2PI*EXP(ARG)/T1
               TAU(I) = SQRT(Y1*(T1 - Y1)/T1)
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               MU = T*G01EAF$(TAIL, ETA, IFAIL)
               IF (MU.LT.RTOL) THEN
                  MU = RTOL
               ELSEIF (MU.GT.T - RTOL) THEN
                  MU = T - RTOL
               ENDIF      
               ARG = HALF*ETA**2
               IF (ARG.LT.EMIN) THEN
                  ARG = EMIN
               ELSEIF (ARG.GT.EMAX) THEN
                  ARG = EMAX
               ENDIF
               DETADMU = R2PI*EXP(ARG)/T
               TAU(I) = SQRT(MU*(T - MU)/T)
            ENDIF
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = SQRT(W)
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.3) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            T = TNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.LE.ZERO .OR. Y.GE.T) THEN
                  Y1 = Y + HALF
                  T1 = T + ONE
               ELSE
                  Y1 = Y
                  T1 = T
               ENDIF
               MU = Y1
               ARG = ONE - Y1/T1
               ETA = LOG( - LOG(ARG))
               DETADMU = - ONE/(T1*ARG*LOG(ARG))
               TAU(I) = SQRT(Y1*(T1 - Y1)/T1)
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               TEMP = ETA
               IF (TEMP.LT.EMIN) THEN
                  TEMP = EMIN
               ELSEIF (TEMP.GT.EMAX) THEN
                  TEMP = EMAX
               ENDIF
               ARG = - EXP(TEMP)
               IF (ARG.LT.EMIN) THEN
                  ARG = EMIN
               ELSEIF (ARG.GT.EMAX) THEN
                  ARG = EMAX
               ENDIF
               MU = T*(ONE - EXP(ARG))
               IF (MU.LT.RTOL) THEN
                  MU = RTOL
               ELSEIF (MU.GT.T - RTOL) THEN
                  MU = T - RTOL
               ENDIF      
               ARG = MAX(RTOL, ONE - MU/MAX(RTOL, T))
               BOT = T*ARG*LOG(ARG)
               DETADMU = - ONE/BOT
               TAU(I) = SQRT(MU*(T - MU)/T)
            ENDIF
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = SQRT(W)
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ENDIF
      END
C
C...................................................................
C
      SUBROUTINE GLIMB2 (IFAIL, LTYPE, MFREE, NFREE, LDA,
     +                   ANEW, BNEW, DEV, HATETA, HATMU, OFFNEW, RESID,
     +                   TNEW, YNEW)
C
C ACTION: Generate residuals ... Binomial errors
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 12/07/2000 
C         14/04/2006 revised tests for IFAIL = 6 
C
      IMPLICIT NONE
      INTEGER  IFAIL, LTYPE, MFREE, NFREE, LDA
      INTEGER  I, IFAIL1, J
      DOUBLE PRECISION ANEW(LDA,MFREE),
     +                 BNEW(MFREE), DEV, HATETA(NFREE), HATMU(NFREE),
     +                 OFFNEW(NFREE),
     +                 RESID(NFREE), TNEW(NFREE),
     +                 YNEW(NFREE)
      DOUBLE PRECISION ARG, ETA, MU, TEMP, TEMP1, TEMP2
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION EMAX, EMIN, RTOL
      PARAMETER (EMAX = 100.0D+00, EMIN = - EMAX, RTOL = 1.0D-100)
      DOUBLE PRECISION G01EAF$
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   G01EAF$
      INTRINSIC  LOG, EXP, SQRT, ABS 
      IF (IFAIL.NE.0) RETURN
      IF (LTYPE.EQ.1) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            ARG = - ETA
            IF (ARG.LT.EMIN) THEN
               ARG = EMIN
            ELSEIF (ARG.GT.EMAX) THEN
               ARG = EMAX
            ENDIF
            MU = TNEW(I)/(ONE + EXP(ARG))  
            IF (MU.LT.RTOL) THEN
               MU = RTOL
            ELSEIF (MU.GT.TNEW(I) - RTOL) THEN
               MU = TNEW(I) - RTOL
            ENDIF 
            HATETA(I) = ETA
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.2) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            IFAIL1 = 0
            MU = TNEW(I)*G01EAF$(TAIL, ETA, IFAIL1)
            IF (MU.LT.RTOL) THEN
               MU = RTOL
            ELSEIF (MU.GT.TNEW(I) - RTOL) THEN
               MU = TNEW(I) - RTOL
            ENDIF             
            HATETA(I) = ETA
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.3) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            TEMP = ETA
            IF (TEMP.LT.EMIN) THEN
               TEMP = EMIN
            ELSEIF (TEMP.GT.EMAX) THEN
               TEMP = EMAX
            ENDIF
            ARG = - EXP(TEMP)
            IF (ARG.LT.EMIN) THEN
               ARG = EMIN
            ELSEIF (ARG.GT.EMAX) THEN
               ARG = EMAX
            ENDIF
            MU = TNEW(I)*(ONE - EXP(ARG))
            IF (MU.LT.RTOL) THEN
               MU = RTOL
            ELSEIF (MU.GT.TNEW(I) - RTOL) THEN
               MU = TNEW(I) - RTOL
            ENDIF    
            HATETA(I) = ETA
            HATMU(I) = MU
         ENDDO
      ENDIF
      DEV = ZERO
      DO I = 1, NFREE
         RESID(I) = ZERO
         IF (YNEW(I).GT.RTOL .AND. HATMU(I).GT.RTOL) RESID(I) =
     +       RESID(I) + YNEW(I)*LOG(YNEW(I)) - YNEW(I)*LOG(HATMU(I))
         TEMP1 = TNEW(I) - YNEW(I)
         TEMP2 = TNEW(I) - HATMU(I)
         IF (TEMP1.GT.RTOL .AND. TEMP2.GT.RTOL) RESID(I) =
     +       RESID(I) + TEMP1*LOG(TEMP1) - TEMP1*LOG(TEMP2)
         RESID(I) = TWO*RESID(I)
         DEV = DEV + RESID(I)
         IF (YNEW(I).GE.HATMU(I)) THEN
            RESID(I) = SQRT(ABS(RESID(I)))
         ELSE
            RESID(I) = - SQRT(ABS(RESID(I)))
         ENDIF
      ENDDO
      END
C
C
