C
C G02GCF$: wgb version
C ====================
C This file contains G02GCF$, GLIMP1 and GLIMP2
C G02GCF$ calls G02GLIM which calls GLIMP and GLIMP2
C ==================================================
C

C
C
      SUBROUTINE G02GCF$(LINK, MEAN, OFFSET, WEIGHT, N, X, LDX, M, ISX,
     +                   IP, Y, WT, A, DEV, IDF, B, IRANK, SE, COV,
     +                   V, LDV, TOL, MAXIT, IPRINT, EPS, WK, IFAIL)
C
C ACTION: Replacement for NAG GLIM routine
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 14/07/2000
C         18/05/2002 revised IFAIL = 5
C         12/07/2002 revised offset calculation
C         14/04/2006 initialised IRANK = 0 and revised IFAIL = 5 conditions
C
C         Error type
C         ==========
C         NTYPE = 3: Poisson errors
C
C         Link type
C         =========
C         LTYPE = 1: Exponent
C         LTYPE = 2: Identity
C         LTYPE = 3: Log
C         LTYPE = 4: Square root
C         LTYPE = 5: Reciprocal
C
      IMPLICIT   NONE
      INTEGER    N, LDX, M, ISX(M), IP, IDF, IRANK, LDV, MAXIT, IPRINT,
     +           IFAIL
      INTEGER    NTYPE
      PARAMETER (NTYPE = 3)
      INTEGER    LDA
      PARAMETER (LDA = 1)
      INTEGER    LTYPE
      INTEGER    I, J, K, MAXIT1
      DOUBLE PRECISION X(LDX,M), Y(N), WT(*), A, DEV, B(IP),
     +                 SE(IP), COV(IP*(IP + 1)/2), V(LDV,IP + 7),
     +                 TOL, EPS, WK((IP*IP + 3*IP + 22)/2)
      DOUBLE PRECISION RSS, S, T(LDA)
      DOUBLE PRECISION SMALL, ZERO
      PARAMETER (SMALL = 1.0D-12, ZERO = 0.0D+00)
      CHARACTER  LINK*1, MEAN*1, OFFSET*1, WEIGHT*1
      LOGICAL    M1, O1, W1
      EXTERNAL   G02GLIM
      INTRINSIC  ABS
C
C Initialise
C
      IRANK = 0
      IFAIL = 0
      DO I = 1, IP
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO
      DEV = ZERO 
      DO I = 1, IP*(IP + 1)/2
         COV(I) = ZERO
      ENDDO
      DO J = 1, IP + 7
         IF (J.NE.7) THEN
            DO I = 1, N
               V(I,J) = ZERO
            ENDDO
         ENDIF
      ENDDO   
C
C Is it safe ?
C
      IF (N.LT.2      .OR.
     +    M.LT.1      .OR.
     +    LDX.LT.N    .OR.
     +    LDV.LT.N    .OR.
     +    IP.LT.1     .OR.
     +    MAXIT.LT.0  .OR.
     +    TOL.LT.ZERO .OR.
     +    EPS.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (LINK.EQ.'E' .OR. LINK.EQ.'e') THEN
         LTYPE = 1
      ELSEIF (LINK.EQ.'I' .OR. LINK.EQ.'i') THEN
         LTYPE = 2
      ELSEIF (LINK.EQ.'L' .OR. LINK.EQ.'l') THEN
         LTYPE = 3
      ELSEIF (LINK.EQ.'S' .OR. LINK.EQ.'s') THEN
         LTYPE = 4
      ELSEIF (LINK.EQ.'R' .OR. LINK.EQ.'r') THEN
         LTYPE = 5
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (LTYPE.EQ.1 .AND. ABS(A - ZERO).LE.SMALL) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (MEAN.EQ.'M' .OR. MEAN.EQ.'m') THEN
         M1 = .TRUE.
         J = 1
      ELSEIF (MEAN.EQ.'Z' .OR. MEAN.EQ.'z') THEN
         M1 = .FALSE.
         J = 0
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (OFFSET.EQ.'Y' .OR. OFFSET.EQ.'y') THEN
         O1 = .TRUE.
      ELSEIF (OFFSET.EQ.'N' .OR. OFFSET.EQ.'n') THEN
         O1 = .FALSE.
      ELSE
          IFAIL = 1
          RETURN
      ENDIF
      IF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         W1 = .FALSE.
      ELSEIF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         W1 = .TRUE.
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (W1) THEN
         K = 0
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ELSEIF (WT(I).GT.ZERO) THEN
               K = K + 1
            ENDIF
         ENDDO
      ELSE
         K = N
      ENDIF
      DO I = 1, M
         IF (ISX(I).LT.0) THEN
            IFAIL = 3
            RETURN
         ELSEIF (ISX(I).GT.0) THEN
            J = J + 1
         ENDIF
      ENDDO
      IF (J.NE.IP) THEN
         IFAIL =  3
         RETURN
      ENDIF
      IF (IP.GT.K) THEN
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 1, N
         IF (Y(I).LT.ZERO) THEN
            IFAIL = 4
            RETURN
         ENDIF
      ENDDO
      IDF = K - J
      IF (IDF.LT.0) THEN
          IFAIL = 3
          RETURN
      ENDIF
C
C Transfer control to the GLIM interface
C                               
      IF (MAXIT.GE.10) THEN
         MAXIT1 = MAXIT
      ELSE
         MAXIT1 = 10
      ENDIF      
      CALL G02GLIM(IDF, IFAIL, IP, IPRINT, IRANK, ISX, LDV, LDX, LTYPE,
     +             M, MAXIT1, N, NTYPE,
     +             A, B, COV, DEV, EPS, RSS, S, SE, T, TOL, V,
     +             WK, WT, X, Y,
     +             M1, O1, W1)
      IF (IFAIL.EQ.0 .AND. IDF.EQ.0) IFAIL = 9
      IF (IFAIL.EQ.0) THEN
         IF (W1) THEN
            DO I = 1, N
               IF (WT(I).GT.0) THEN
                  IF (V(I,2).LE.ZERO) THEN
                     IFAIL = 5
                     RETURN
                  ENDIF    
               ENDIF
            ENDDO
         ELSE 
            DO I = 1, N
               IF (V(I,2).LE.ZERO) THEN
                  IFAIL = 5
                  RETURN
               ENDIF   
            ENDDO
         ENDIF
      ENDIF
      END
C  
C........................................................................
C
      SUBROUTINE GLIMP1 (ICOUNT, IFAIL, LTYPE, MFREE, NFREE, NRHS, LDA,
     +                   LDB,
     +                   A, ANEW, ATEMP, BNEW, BTEMP, OFFNEW, TAU, WNEW,
     +                   WRKWT, YNEW)
C
C ACTION: Generate Z ... Poisson errors
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 13/04/2000
C
      IMPLICIT NONE
      INTEGER  ICOUNT, IFAIL, LTYPE, MFREE, NFREE, NRHS, LDA, LDB
      INTEGER  I, J
      DOUBLE PRECISION A, ANEW(LDA,MFREE), ATEMP(LDA,MFREE),
     +                 BNEW(MFREE), BTEMP(LDB,NRHS),
     +                 OFFNEW(NFREE), TAU(NFREE),
     +                 WNEW(NFREE), WRKWT(NFREE), YNEW(NFREE)
      DOUBLE PRECISION AINV, AM1, ETA, MU, DETADMU, ROOT, TEMP, W, Y, Z
      DOUBLE PRECISION ZERO, ONE, HALF
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, HALF = 0.5D+00)
      DOUBLE PRECISION EMAX, EMIN, EPSI, RTOL
      PARAMETER (EMAX = 200.0D+00, EMIN = - EMAX, EPSI = 1.0D-10,
     +           RTOL = 1.0D-100)
      LOGICAL    BYPASS
      INTRINSIC  LOG, EXP, SQRT, MAX, ABS
      IF (LTYPE.EQ.1) THEN
         AINV = ONE/A
         AM1 = A - ONE
         IF (ABS(AM1).LE.EPSI) THEN
            BYPASS = .TRUE.
         ELSE
            BYPASS = .FALSE.
         ENDIF
         DO I = 1, NFREE
            Y = YNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (BYPASS) THEN
                  ETA = Y
                  MU = Y
                  DETADMU = ONE
               ELSE
                  IF (Y.GE.ZERO) THEN
                     ETA = Y**A
                     MU = Y
                  ELSE
                     IFAIL = 4
                     RETURN
                  ENDIF
               ENDIF
               DETADMU = A*MU**AM1
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               IF (BYPASS) THEN
                  MU = ETA
                  DETADMU = ONE
               ELSE
                  IF (ETA.GE.ZERO) THEN
                     MU = ETA**AINV
                  ELSE
                     MU = ZERO
                  ENDIF
                  DETADMU = A*MU**AM1
               ENDIF
            ENDIF
            IF (MU.GE.ZERO) THEN
               TAU(I) = SQRT(MU)
            ELSE
               TAU(I) = ZERO
            ENDIF
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = MAX(RTOL, SQRT(W))
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.2) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            IF (ICOUNT.EQ.1) THEN
               ETA = Y
               MU = Y
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               MU = ETA
            ENDIF
            IF (MU.GE.ZERO) THEN
               TAU(I) = SQRT(MU)
            ELSE
               TAU(I) = ZERO
            ENDIF
            WRKWT(I) = TAU(I)**2
            ROOT = MAX(RTOL, SQRT(WNEW(I)*WRKWT(I)))
            Z = (Y - OFFNEW(I))/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.3) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.GE.ZERO) THEN
                  IF (Y.GT.RTOL) THEN
                     ETA = LOG(Y)
                  ELSE
                     ETA = LOG(RTOL)
                  ENDIF
                  MU = Y
               ELSE
                  IFAIL = 4
                  RETURN
               ENDIF
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               IF (ETA.LT.EMIN) THEN
                  ETA = EMIN
               ELSEIF (ETA.GT.EMAX) THEN
                  ETA = EMAX
               ENDIF
               MU = EXP(ETA)
            ENDIF
            IF (MU.LT.RTOL) MU = RTOL
            TAU(I) = SQRT(MU)
            DETADMU = ONE/MU
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = MAX(RTOL, SQRT(W))
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.4) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.GE.ZERO) THEN
                  IF (Y.GT.RTOL) THEN
                     ETA = SQRT(Y)
                  ELSE
                     ETA = ZERO
                  ENDIF
                  MU = Y
               ELSE
                  IFAIL = 4
                  RETURN
               ENDIF
               TEMP = SQRT(MU)
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               MU = ETA**2
               TEMP = SQRT(MU)
               IF (TEMP.LE.RTOL) TEMP = RTOL
            ENDIF
            IF (MU.GT.ZERO) THEN
               TAU(I) = TEMP
            ELSE
               TAU(I) = ZERO
            ENDIF
            DETADMU = HALF/MAX(RTOL, TEMP)
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = MAX(RTOL, SQRT(W))
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ELSEIF (LTYPE.EQ.5) THEN
         DO I = 1, NFREE
            Y = YNEW(I)
            IF (ICOUNT.EQ.1) THEN
               IF (Y.GE.ZERO) THEN
                  IF (ABS(Y).GT.RTOL) THEN
                     ETA = ONE/Y
                  ELSE
                     ETA = ONE/RTOL
                  ENDIF
                  MU = Y
               ELSE
                  IFAIL = 4
                  RETURN
               ENDIF
            ELSE
               ETA = OFFNEW(I)
               DO J = 1, MFREE
                  ETA = ETA + BNEW(J)*ANEW(I,J)
               ENDDO
               IF (ABS(ETA).LT.RTOL) THEN
                  IF (ETA.LT.ZERO) THEN
                     ETA = - RTOL
                  ELSE
                     ETA = RTOL
                  ENDIF
               ENDIF
               MU = ONE/ETA
            ENDIF
            TEMP = MU**2
            IF (TEMP.LT.RTOL) TEMP = RTOL
            DETADMU = - ONE/TEMP
            IF (MU.GT.ZERO) THEN
               TAU(I) = SQRT(MU)
            ELSE
               TAU(I) = ZERO
            ENDIF
            WRKWT(I) = (TAU(I)*DETADMU)**2
            W = WNEW(I)*WRKWT(I)
            ROOT = MAX(RTOL, SQRT(W))
            Z = (ETA - OFFNEW(I) + (Y - MU)*DETADMU)/ROOT
            BTEMP(I,1) = Z
            DO J = 1, MFREE
               ATEMP(I,J) = ANEW(I,J)/ROOT
            ENDDO
         ENDDO
      ENDIF
      END
C
C...................................................................
C
      SUBROUTINE GLIMP2 (IFAIL, LTYPE, MFREE, NFREE, LDA,
     +                   A, ANEW, BNEW, DEV, HATETA, HATMU, OFFNEW,
     +                   RESID, YNEW)
C
C ACTION: Generate residuals ... Poisson errors
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 20/06/2000
C
      IMPLICIT NONE
      INTEGER  IFAIL, LTYPE, MFREE, NFREE, LDA
      INTEGER  I, J
      DOUBLE PRECISION A, ANEW(LDA,MFREE),
     +                 BNEW(MFREE), DEV, HATETA(NFREE), HATMU(NFREE),
     +                 OFFNEW(NFREE),
     +                 RESID(NFREE),
     +                 YNEW(NFREE)
      DOUBLE PRECISION AINV, ETA, MU, TEMP
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION EMAX, EMIN, EPSI, RTOL
      PARAMETER (EMAX = 200.0D+00, EMIN = - EMAX, EPSI = 1.0D-10,
     +           RTOL = 1.0D-100)
      LOGICAL    BYPASS
      INTRINSIC  LOG, EXP, SQRT, ABS
      IF (IFAIL.NE.0) RETURN
      IF (LTYPE.EQ.1) THEN
         IF (ABS(A - ONE).LE.EPSI) THEN
            BYPASS = .TRUE.
         ELSE
            BYPASS = .FALSE.
            AINV = ONE/A
         ENDIF
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            IF (BYPASS) THEN
               MU = ETA
            ELSE
               IF (ETA.GE.ZERO) THEN
                  MU = ETA**AINV
               ELSE
                  MU = ZERO
               ENDIF
            ENDIF
            HATETA(I) = ETA
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.2) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            MU = ETA
            HATETA(I) = ETA
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.3) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            TEMP = ETA
            IF (TEMP.LT.EMIN) THEN
               TEMP = EMIN
            ELSEIF (TEMP.GT.EMAX) THEN
               TEMP = EMAX
            ENDIF
            HATETA(I) = ETA
            MU = EXP(TEMP)
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.4) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            HATETA(I) = ETA
            MU = ETA**2
            HATMU(I) = MU
         ENDDO
      ELSEIF (LTYPE.EQ.5) THEN
         DO I = 1, NFREE
            ETA = OFFNEW(I)
            DO J = 1, MFREE
               ETA = ETA + BNEW(J)*ANEW(I,J)
            ENDDO
            HATETA(I) = ETA
            MU = ONE/ETA
            HATMU(I) = MU
         ENDDO
      ENDIF
      DEV = ZERO
      DO I = 1, NFREE
         IF (YNEW(I).GT.RTOL .AND. HATMU(I).GT.RTOL) THEN
            RESID(I) = TWO*(YNEW(I)*LOG(YNEW(I)) -
     +                      YNEW(I)*LOG(HATMU(I)) -
     +                     (YNEW(I) - HATMU(I)))
            DEV = DEV + RESID(I)
            IF (YNEW(I).GE.HATMU(I)) THEN
               RESID(I) = SQRT(ABS(RESID(I)))
            ELSE
               RESID(I) = - SQRT(ABS(RESID(I)))
            ENDIF
         ELSE
            RESID(I) = ZERO
         ENDIF
      ENDDO
      END
C
C
