C
C ************************************************************
C This routine is in development and is not yet ready for use.
C It must be checked AT SOME STAGE and simplified so as to use
C WK instead of defining internal workspaces A, P0, and Z.
C Note that LWORK = 5*IP*IP which is suggested as sufficient
C for G02GKF. The workspace WK provided is used for matrix
C inversion and defioning the new parameter vector.
C ************************************************************
C
C
      SUBROUTINE G02GKF$(IP, ICONST, V, LDV, C, LDC, B, S, SE, COV,
     +                   WK, IFAIL)
C
C ACTION: GLM parameter estimates by SVD in the rank-deficient case
C AUTHOR: w.g.bardsley, university of manchester, u.k., 14/06/2002
C         This routine was hastily thrown together and MUST be
C         re-worked at some stage to use WK instead of A, P0, Z.
C         Note: WK(5*IP*IP) since temporary arrays A, P0 and Z are
C               used for the time being
C               ICONST = IP - IRANK
C               P0 is (IP,ICONST)
C               P1 is (IP,IP - ICONST)
C               C is (IP,ICONST)
C               D is (IRANK*IRANK)
C               V contains D{-1}P1^{T}|P0^{T} stored rowwise
C
      IMPLICIT   NONE
      INTEGER    IP, ICONST, LDV, LDC, IFAIL
      INTEGER    I, IRANK, J, K, M, N
      INTEGER    LWORK, NMAX
      PARAMETER (NMAX = 250)
      INTEGER    IPIV(NMAX)
      DOUBLE PRECISION V(LDV,IP + 7), C(LDC,ICONST), B(IP), S, SE(IP),
     +                 COV(IP*(IP + 1)/2), WK(5*IP*IP)
      DOUBLE PRECISION A(NMAX,NMAX), P0(NMAX,NMAX), Z(NMAX,NMAX)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      EXTERNAL   F07ADF$, F07AJF$
      INTRINSIC  SQRT
C
C Check input parameters
C
      IFAIL = 0
      IF (IP.LT.1 .OR. ICONST.GE.IP .OR. ICONST.LE.0 .OR.
     +    LDV.LT.IP .OR. LDC.LT.IP .OR. S.LE.ZERO) THEN
          IFAIL = 1
          RETURN
      ENDIF
C
C Check temporary array size
C
      IF (IP.GT.NMAX) THEN
         IFAIL = 3
         RETURN
      ENDIF
C
C Define IRANK then Construct P0 from V using IRANK as offset
C
      IRANK = IP - ICONST
      DO I = 1, IP
         DO J = 1, ICONST
            P0(I,J) = V(IRANK + J,7 + I)
         ENDDO
      ENDDO
C
C Construct A = [C^{T}P0] = (ICONST,ICONST)
C
      DO I = 1, ICONST
         DO J = 1, ICONST
            A(I,J) = ZERO
            DO K = 1, IP
C***************A(I,J) = A(I,J) + C(K,I)*V(IRANK + J,K + 7)
                A(I,J) = A(I,J) + C(K,I)*P0(K,J)
            ENDDO
         ENDDO
      ENDDO
C
C Invert A
C
      LWORK = 5*IP*IP
      M = ICONST
      N = ICONST
      CALL F07ADF$(M, N, A, NMAX, IPIV, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
      CALL F07AJF$(N, A, NMAX, IPIV, WK, LWORK, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Construct Z = [P0(C^{T}P0)^{-1}], dimension = (IP,ICONST)
C
      DO I = 1, IP
         DO J = 1, ICONST
            Z(I,J) = ZERO
            DO K = 1, ICONST
C***************Z(I,J) = Z(I,J) + V(IRANK + K, I + 7)*A(K,J)
               Z(I,J) = Z(I,J) + P0(I,K)*A(K,J)
            ENDDO
         ENDDO
      ENDDO
C
C Post multiply by C^T so that Z dimension = (IP,IP)
C
      DO I = 1, IP
         DO J = 1, IP
            A(I,J) = ZERO
            DO K = 1, ICONST
               A(I,J) = A(I,J) + Z(I,K)*C(J,K)
            ENDDO
         ENDDO
      ENDDO
      DO J = 1, IP
         DO I = 1, IP
            Z(I,J) = A(I,J)
         ENDDO
      ENDDO
C
C Construct A = [I - P0(C^{T}P0)^{-1}C^T], dimension = (IP,IP)
C
      DO J = 1, IP
         DO I = 1, IP
            IF (I.EQ.J) THEN
               A(I,J) = ONE
            ELSE
               A(I,J) = ZERO
            ENDIF
         ENDDO
      ENDDO
      DO J = 1, IP
        DO I = 1, IP
           A(I,J) = A(I,J) - Z(I,J)
        ENDDO
      ENDDO
C
C Construct new parameters B_NEW = [I - P0^{T}P0)^{-1}C^T]B_OLD
C
      DO I = 1, IP
         WK(I) = ZERO
         DO J = 1, IP
            WK(I) = WK(I) + A(I,J)*B(J)
         ENDDO
      ENDDO
      DO I = 1, IP
         B(I) = WK(I)
      ENDDO
C
C Form the covariance matrix from P1*P1^T
C
      DO I = 1, IP
         DO J = 1, IP
            Z(I,J) = ZERO
            DO K = 1, IRANK
               Z(I,J) = Z(I,J) + V(K,I + 7)*V(K,J + 7)
            ENDDO
         ENDDO
      ENDDO
C
C Premultiply the covariance matrix by A to create P0
C
      DO I = 1, IP
         DO J = 1, IP
            P0(I,J) = ZERO
            DO K = 1, IP
               P0(I,J) = P0(I,J) + A(I,K)*Z(K,J)
            ENDDO
         ENDDO
      ENDDO
C
C Postmultiply the product P0 by A^T
C
      DO I = 1, IP
         DO J = 1, IP
            Z(I,J) = ZERO
            DO K = 1, IP
               Z(I,J) = Z(I,J) + P0(I,K)*A(J,K)
            ENDDO
         ENDDO
      ENDDO
C
C Define COV and SE
C
      K = 0
      DO J = 1, IP
         DO I = 1, J
            K = K + 1
            COV(K) = Z(I,J)
            IF (I.EQ.J) SE(I) = SQRT(COV(K)*S)
         ENDDO
      ENDDO
      END
C
C
