c
c-----------------------------------------------------------------------                                  
c   action: Simfit substitute for NAG routine G02LAF
c   author: w.g.bardsley@manchester.ac.uk, 04/07/2011
c-----------------------------------------------------------------------
c
c comments: This version allocates more space than strictly necessary
c           as deallocation and reallocation has not been used systematically
c           to conserve memory. Instead, allocation of total workspace
c           is used as a starting block with nonzero ifail exits if
c           space cannot be allocated. Further, several two pass loops
c           are used for clarity where single pass would do, and in-line
c           loops are often used instead of BLAS. I shall clean this up
c           in a future edit when the Simfit PLS project is completed. 
c
c     bnipalsb 
      subroutine g02laf$(n, mx, x, ldx, isx, ip, my, y, ldy, xbar,
     +                   ybar, iscale, xstd, ystd, maxfac, xres,
     +                   ldxres, yres, ldyres, w, ldw, p, ldp, t,
     +                   ldt, c, ldc, u, ldu, xcv, ycv,
     +                   ldycv, ifail) 
      implicit none
c
c arguments
c      
      integer n, mx, ldx, isx(mx), ip, my, ldy, iscale, maxfac, ldxres,
     +        ldyres, ldw, ldp, ldt, ldc, ldu, ldycv, ifail  
      double precision x(ldx,mx), y(ldy,my), xbar(ip), ybar(my),
     +                 xstd(ip), ystd(my), xres(ldxres,ip),
     +                 yres(ldyres,my), w(ldw,maxfac), p(ldp,maxfac),
     +                 t(ldt,maxfac), c(ldc,maxfac), u(ldu,maxfac),
     +                 xcv(maxfac), ycv(ldycv,my)
c
c allocatables
c     
      double precision, allocatable :: c1(:), p1(:), t1(:), u1(:),
     +                                 w1(:), x1hat(:,:), y1hat(:,:),
     +                                 ymean(:), yvar(:), yvar1(:)
c
c locals
c     
      integer    i, iadd1, ierr, j, jadd1, kadd1, ncolx, ncoly, nrmax
      integer    incx, incy
      parameter (incx = 1, incy = 1)
      double precision sumsq, xmean, xvar, xvar1
      double precision dn, dnm1, dtotal
      double precision zero, one, percent
      parameter (zero = 0.0d+00, one = 1.0d+00, percent = 100.0d+00)
      external   g02laf_1, g02laf_2, dgemv
      intrinsic  dble, sqrt
c
c Part 1: check arguments supplied
c      
      ifail = 1
      if (n.lt.2  .or.
     +    mx.lt.2 .or.   
     +    my.lt.1 .or.   
     +    iscale.lt.-1 .or.   
     +    iscale.gt.2) return 
      iadd1 = 0
      do i = 1, mx
         if (isx(i).lt.0 .or.isx(i).gt.1) return
         if (isx(i).eq.1) iadd1 = iadd1 + 1  
      enddo  
      if (iadd1.ne.ip) then
         ifail = 3
         return
      endif  
      if (ldx.lt.n     .or.
     +    ip.lt.2      .or.
     +    ip.gt.mx     .or.
     +    ldy.lt.n     .or.
     +    maxfac.lt.1  .or.
     +    maxfac.gt.ip .or.
     +    ldxres.lt.n  .or.
     +    ldyres.lt.n  .or.
     +    ldw.lt.ip    .or.
     +    ldp.lt.ip    .or.
     +    ldc.lt.my    .or.
     +    ldt.lt.n     .or.
     +    ldu.lt.n     .or.
     +    ldycv.lt.maxfac) then
         ifail = 2
         return
      endif

c
c-----------------------------------------------------------------
c arguments are ok so try to allocate workspace 
c note that nonzero ifails are returned if allocation fails      
c-----------------------------------------------------------------
c            
        
      ierr = 0
      ifail = 12
      ncolx = ip
      ncoly = my
      nrmax = n
      if (allocated(w1)) deallocate(w1,stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (w1(ncolx), stat = ierr)  
      if (ierr.ne.0) goto 20

      ifail = 13
      if (allocated(t1)) deallocate(t1,stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (t1(nrmax), stat = ierr) 
      if (ierr.ne.0) goto 20
 
      ifail = 14
      if (allocated(p1)) deallocate(p1,stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (p1(ncolx), stat = ierr) 
      if (ierr.ne.0) goto 20

      ifail = 15 
      if (allocated(c1)) deallocate(c1,stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (c1(ncoly), stat = ierr) 
      if (ierr.ne.0) goto 20

      ifail = 16 
      if (allocated(u1)) deallocate(u1,stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (u1(nrmax), stat = ierr) 
      if (ierr.ne.0) goto 20
      
      ifail = 17
      if (allocated(x1hat)) deallocate(x1hat, stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (x1hat(nrmax,ncolx + 2), stat = ierr)
      if (ierr.ne.0) goto 20  

      ifail = 18
      if (allocated(y1hat)) deallocate(y1hat, stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (y1hat(nrmax,ncoly + 2), stat = ierr)
      if (ierr.ne.0) goto 20 

      ifail = 19
      if (allocated(ymean)) deallocate(ymean, stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (ymean(ncoly), stat = ierr)
      if (ierr.ne.0) goto 20

      ifail = 20
      if (allocated(yvar)) deallocate(yvar, stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (yvar(ncoly), stat = ierr)
      if (ierr.ne.0) goto 20

      ifail = 21
      if (allocated(yvar1)) deallocate(yvar1, stat = ierr)
      if (ierr.ne.0) goto 20
      allocate (yvar1(ncoly), stat = ierr)
      if (ierr.ne.0) goto 20   
c
c Part 2: calculate xbar and ybar
c
      do i = 1, ip
         xbar(i) = zero
      enddo
      jadd1 = 0
      do j = 1, mx
         if (isx(j).eq.1) then
            jadd1 = jadd1 + 1
            do i = 1, n
               xbar(jadd1) = xbar(jadd1) + x(i,j)
            enddo  
         endif  
      enddo  
      dn = dble(n)
      dnm1 = dn - one
      do i = 1, ip
         xbar(i) = xbar(i)/dn
      enddo
       
      do i = 1, my
         ybar(i) = zero
      enddo
      do j = 1, my
         do i = 1, n
            ybar(j) = ybar(j) + y(i,j)
         enddo
      enddo
      do i = 1, my
         ybar(i) = ybar(i)/dn
      enddo
c
c Part 3: calculate standard deviations
c      
      if (iscale.eq.1) then
         do i = 1, ip
            xstd(i) = zero
         enddo
         jadd1 = 0
         do j = 1, mx
            if (isx(j).eq.1) then
               jadd1 = jadd1 + 1
               do i = 1, n
                  xstd(jadd1) = xstd(jadd1) +
     +                         (x(i,j) - xbar(jadd1))**2
               enddo
            endif   
         enddo 
         do i = 1, ip 
            xstd(i) = sqrt(xstd(i)/dnm1)
         enddo 
         do i = 1, my
            ystd(i) = zero
         enddo
         do j = 1, my
            do i = 1, n
               ystd(j) = ystd(j) + (y(i,j) - ybar(j))**2
            enddo   
         enddo
         do i = 1, my
            ystd(i) = sqrt(ystd(i)/dnm1)
         enddo   
      endif 
c
c Part 4: calculate x1, y1, then xvar and yvar first time round
c         ierr is returned as 22 if the calculation cannot be done 
c     
      call g02laf_1 (ifail, iscale, isx, ldx, ldy, mx, my, ncolx, nrmax,
     +               x, xbar, xstd, xres, y, ybar, ystd, yres) 
      if (ifail.ne.0) goto 20
      xmean = zero
      xvar = zero
      do j = 1, ncolx
         do i = 1, nrmax
            xmean = xmean + xres(i,j)
         enddo  
      enddo   
      dtotal = dble(nrmax*ncolx)
      xmean = xmean/dtotal
      do j = 1, ncolx
         do i = 1, nrmax
            xvar = xvar + (xmean - xres(i,j))**2
         enddo  
      enddo  
      xvar = xvar/(dtotal - one)
      do i = 1, ncoly
         ymean(i) = zero
         yvar(i) = zero
      enddo   
      do j = 1, ncoly
         do i = 1, nrmax
            ymean(j) = ymean(j) + yres(i,j)
         enddo
         ymean(j) = ymean(j)/dn  
      enddo   
      do j = 1, ncoly
         do i = 1, nrmax
            yvar(j) = yvar(j) + (ymean(j) - yres(i,j))**2
         enddo  
         yvar(j) = yvar(j)/dnm1
      enddo  
c
c Part 5: the main loop ... calculate svd of x^ty then w for kadd1 = 1, 2, ..., maxfac
c      
      kadd1 = 0
      do while (kadd1.lt.maxfac)
        
         kadd1 = kadd1 + 1

         call g02laf_2 (ifail, ldx, ldy, ncolx, ncoly, nrmax,
     +                  w1, xres, yres) 
         if (ifail.ne.0) goto 20
c
c define w1
c      
         do i = 1, ip
            w(i,kadd1) = w1(i)
         enddo   
c
c Part 6: define t1
c      
      
         call dgemv ('N', nrmax, ncolx, one, xres, ldx, w1,
     +               incx, zero, t1, incy)
         sumsq = zero
         do i = 1, n
            sumsq = sumsq + t1(i)**2
         enddo  
         sumsq = sqrt(sumsq)
         do i = 1, n
            t1(i) = t1(i)/sumsq
            t(i,kadd1) = t1(i)
         enddo  
c
c Part 7: define p1
c      
         do j = 1, ncolx
            p1(j) = zero
            do i = 1, n
               p1(j) = p1(j) + t1(i)*xres(i,j)
            enddo  
         enddo  
         do i = 1, ncolx
            p(i,kadd1) = p1(i)
         enddo  
c
c part 8: define c1
c      
         do j = 1, my
            c1(j) = zero
            do i = 1, n
               c1(j) = c1(j) + t1(i)*yres(i,j)
            enddo  
         enddo 
         do i = 1, my
            c(i,kadd1) = c1(i)
         enddo  
c
c part 9: define u1
c       
         do i = 1, n
            u1(i) = zero
            do j = 1, ncoly
               u1(i) = u1(i) + yres(i,j)*c1(j) 
            enddo  
         enddo
         do i = 1, n
            u(i,kadd1) = u1(i)
         enddo  
c
c part 10: define x1hat and y1hat then xres and yres
c 
         do i = 1, nrmax
            do j = 1, ncolx
               x1hat(i,j) = t1(i)*p1(j)
            enddo  
         enddo  
         do i = 1, nrmax
            do j = 1, ncoly
               y1hat(i,j) = t1(i)*c1(j)
            enddo  
         enddo  
         do j = 1, ncolx
            do i = 1, nrmax
              xres(i,j) = xres(i,j) - x1hat(i,j)
            enddo  
         enddo  
         do j = 1, ncoly
            do i = 1, nrmax
              yres(i,j) = yres(i,j) - y1hat(i,j)
            enddo  
         enddo
c
c part 11: calculate xcv and ycv
c      
         xmean = zero
         xvar1 = zero
         do j = 1, ncolx
            do i = 1, nrmax
               xmean = xmean + x1hat(i,j)
            enddo  
         enddo   
         xmean = xmean/dtotal
         do j = 1, ncolx
            do i = 1, nrmax
               xvar1 = xvar1 + (xmean - x1hat(i,j))**2
            enddo  
         enddo  
         xvar1 = xvar1/(dtotal - one)
         do i = 1, ncoly
            ymean(i) = zero
            yvar1(i) = zero
         enddo   
         do j = 1, ncoly
            do i = 1, nrmax
               ymean(j) = ymean(j) + y1hat(i,j)
            enddo  
            ymean(j) = ymean(j)/dn
         enddo   
         do j = 1, ncoly
            do i = 1, nrmax
               yvar1(j) = yvar1(j) + (ymean(j) - y1hat(i,j))**2
            enddo  
            yvar1(j) = yvar1(j)/dnm1
         enddo  
         xcv(kadd1) = percent*xvar1/xvar
         do j = 1, ncoly
            ycv(kadd1,j) = percent*yvar1(j)/yvar(j)
         enddo 
         if (kadd1.gt.1) then
            xcv(kadd1) = xcv(kadd1) + xcv(kadd1 - 1)
            do i = 1, ncoly
               ycv(kadd1,i) = ycv(kadd1,i) + ycv(kadd1 - 1,i)
            enddo    
         endif
         

      enddo
c
c set ifail = 0 then deallocate
c
      ifail = 0
c
c statement 20: crash out point or normal exit
c 
   20 continue
c
c make sure everything is deallocated
c         
      deallocate (u1, stat = ierr)
      deallocate (c1, stat = ierr)
      deallocate (p1, stat = ierr)
      deallocate (t1, stat = ierr)
      deallocate (w1, stat = ierr)
      deallocate (x1hat, stat = ierr)
      deallocate (y1hat, stat = ierr)
      deallocate (ymean, stat = ierr)
      deallocate (yvar, stat = ierr)
      deallocate (yvar1, stat = ierr) 
      end
c
c---------------------------------------------------------------------
c
      subroutine g02laf_1 (ifail, iscale, isx, ldx, ldy, mx, my, ncolx,
     +                     nrmax,
     +                     x, xbar, xstd, x1, y, ybar, ystd, y1)
c
c calculate x1 and y1: note that nrmax = n, the number of observations
c iafil is returned as 0 or 22 if division by zero is requested                   
c     
      implicit none
c
c arguments
c      
      integer,          intent (out) :: ifail 
      integer,          intent (in)  :: iscale, ldx, ldy, mx, my, ncolx, 
     +                                  nrmax
      integer,          intent (in)  :: isx(mx)
      double precision, intent (in)  :: x(ldx,mx), xbar(ncolx),
     +                                  xstd(ncolx), 
     +                                  y(ldy,my), ybar(my),
     +                                  ystd(my)
      double precision, intent (out) :: x1(ldx,ncolx), y1(ldy,my) 
c
c locals
c      
      integer    i, j, jadd1, n 
      double precision zero
      parameter (zero = 0.0d+00)       
c
c generate x1
c            
      ifail = 22
      n = nrmax
      jadd1 = 0  
      do j = 1, mx
         if (isx(j).eq.1) then
            jadd1 = jadd1 + 1
            do i = 1, n
               x1(i,jadd1) = x(i,j) - xbar(jadd1)
            enddo
         endif        
      enddo 
      if (iscale.gt.0) then
         do j = 1, ncolx
            if (xstd(j).le.zero) return
            do i = 1, n
               x1(i,j) = x1(i,j)/xstd(j)
            enddo  
         enddo  
      endif  
c
c generate y1
c
      do j = 1, my
         do i = 1, n
            y1(i,j) = y(i,j) - ybar(j)
         enddo
      enddo 
      if (iscale.gt.0) then
         do j = 1, my
            if (ystd(j).le.zero) return
            do i = 1, n
               y1(i,j) = y1(i,j)/ystd(j)
            enddo  
         enddo  
      endif 
      ifail = 0 
      end
c
c----------------------------------------------------------------------------------
c        
      subroutine g02laf_2 (ifail, ldx, ldy, ncolx, ncoly, nrmax,
     +                     w, x, y)
c
c svd: nrmax = n = number of rows of data
c ifail is returned as zero unless failure to allocate is encountered
c     
      implicit none
c
c arguments
c          
      integer,          intent (in)    :: ldx, ldy, ncolx, ncoly, nrmax
      integer,          intent (out)   :: ifail 
      double precision, intent (in)    :: x(ldx,ncolx), y(ldy,ncoly)
      double precision, intent (out)   :: w(ncolx) 
c
c allocatable
c           
      double precision, allocatable :: xty(:,:), s(:), u(:,:), vt(:,:)
c
c locals
c       
      integer    i, ierr, isend, ncol, nmax, nrow
      integer    lda, ldu, ldvt
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      external   dgemm, svd000
      intrinsic  max
c
c allocate xty
c      
      ierr = 0
      if (allocated(xty)) deallocate (xty, stat = ierr)
      ifail = 23       
      if (ierr.ne.0) return
      if (allocated(s)) deallocate (s, stat = ierr)
      ifail = 24       
      if (ierr.ne.0) return
      if (allocated(u)) deallocate (u, stat = ierr)
      ifail = 25       
      if (ierr.ne.0) return
      if (allocated(vt)) deallocate (vt, stat = ierr)
      ifail = 26       
      if (ierr.ne.0) return  
      ncol = ncoly
      nrow = ncolx  
      nmax = max(ncolx,ncoly)
      lda = nrow
      allocate (xty(lda,ncol + 2), stat = ierr)
      ifail = 27       
      if (ierr.ne.0) return 
      allocate (s(nmax), stat = ierr)
      ifail = 28       
      if (ierr.ne.0) return
      ldu = nrow  
      allocate (u(ldu,ldu + 2), stat = ierr)
      ifail = 29       
      if (ierr.ne.0) return
      ldvt = ncol
      allocate (vt(ldvt,ldvt + 2), stat = ierr)
      ifail = 30       
      if (ierr.ne.0) return   
      call dgemm ('T', 'N', ncolx, ncoly, nrmax, one, x, ldx, y,
     +            ldy, zero, xty, lda)
      isend = 2
      call svd000 (isend, lda, ldu, ldvt, ncolx, ncoly,
     +             xty, s, u, vt)
      do i = 1, ncolx
         w(i) = u(i,1)
      enddo
      ifail = 0
      deallocate (xty, stat = ierr)        
      deallocate (s, stat = ierr)        
      deallocate (u, stat = ierr)        
      deallocate (vt, stat = ierr)  
      end   
c      
c
 




