
c
c action: simfit substitute for g02lcf 
c author: w.g.bardsley, university of manchester, u.k., 09/08/2011
c
      subroutine g02lcf$(ip, my, maxfac, nfact, p, ldp, c, ldc, w, ldw,
     +                   rcond, b, ldb, orig, xbar, ybar, iscale, xstd,
     +                   ystd, ob, ldob, vipopt, ycv, ldycv, vip, ldvip,
     +                   ifail)
      implicit   none
c
c arguments
c      
      integer    ip, my, maxfac, nfact, ldp, ldc, ldw, ldb, orig, 
     +           iscale, ldob, vipopt, ldycv, ldvip, ifail
      double precision p(ldp,maxfac), c(ldc,maxfac), w(ldw,maxfac),
     +                 rcond, b(ldb,my), xbar(ip), ybar(my), xstd(ip),
     +                 ystd(my), ob(ldob,my), ycv(ldycv,my),
     +                 vip(ldvip,vipopt)
c
c allocatables
c   
      double precision, allocatable :: ptw(:,:), wptwi(:,:)  
c
c locals
c     
      integer    ierr
      integer    i, j, k
      integer    ip1, nfact1
      integer    nrank  
      double precision dip, sumsq, sumij, var
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      external   dgemm, pseudo
      intrinsic  dble, sqrt
c
c check
c      
      ifail = 1
      if (ip.lt.2 .or. 
     +    my.lt.1 .or.
     +    orig.ne.-1.and.orig.ne.1) return
      if (orig.eq.1) then
         if (iscale.ne.-1 .and. iscale.ne.1 .and. iscale.ne.2) return
      endif  
      if (vipopt.ne.0 .and. vipopt.ne.1 .and. vipopt.ne.my) return
      ifail = 2
      if (maxfac.lt.1                  .or. 
     +    maxfac.gt.ip                 .or.
     +    nfact.lt.1                   .or.
     +    nfact.gt.maxfac              .or.
     +    ldp.lt.ip                    .or.
     +    ldc.lt.my                    .or.
     +    ldw.lt.ip                    .or.
     +    ldb.lt.ip                    .or.
     +    orig.eq.1.and.ldob.lt.ip + 1 .or.
     +    ldycv.lt.nfact               .or.
     +    vipopt.ne.0.and.ldvip.lt.ip) return
c
c allocate
c     
      ifail = 12 
      ierr = 0
      if (allocated(ptw)) deallocate(ptw, stat = ierr)
      if (ierr.ne.0) return
      nfact1 = nfact    
      allocate (ptw(nfact1,nfact1 + 2), stat = ierr)  
      if (ierr.ne.0) return 
      ifail = 13
      if (allocated(wptwi)) deallocate (wptwi, stat = ierr)
      if (ierr.ne.0) return
      ip1 = ip  
      allocate (wptwi(ip1,nfact1 + 2), stat = ierr)
      if (ierr.ne.0) return
      ifail = 0
c
c form p^T*w
c      
      call dgemm ('T', 'N', nfact, nfact, ip, one, p, ldp, w, ldw, zero,
     +            ptw, nfact) 
c
c form (p^T*w)^{-1}
c       
      call pseudo (nfact, nrank, nfact, nfact,
     +             ptw, rcond)
c
c form w*(p^T*w)^{-1}
c     
      call dgemm ('N', 'N', ip, nfact, nfact, one, w, ldw, ptw,
     +            nfact, zero, wptwi, ip)
c
c form b = w*(p^T*w)^{-1}*c^T
c     
      call dgemm ('N', 'T', ip, my, nfact, one, wptwi, ip,
     +            c, ldc, zero, b, ldb)    
c
c calculate vip
c      
      if (vipopt.eq.my) then
         dip = dble(ip)
         do i = 1, ip
            do j = 1, my
               sumsq = zero
               var = ycv(1,j)
               do k = 1, nfact
                  if (k.gt.1) var = ycv(k,j) - ycv(k - 1,j)
                  sumsq = sumsq + var*w(i,k)**2
               enddo
               vip(i,j) = sqrt(dip*sumsq/ycv(nfact,j))    
            enddo  
         enddo 
      elseif (vipopt.eq.1) then
         sumij = zero
         do j = 1, my
            sumij = sumij + ycv(nfact,j)
         enddo  
         dip = dble(ip)
         do i = 1, ip
            vip(i,1) = zero
            do j = 1, my
               sumsq = zero
               var = ycv(1,j)
               do k = 1, nfact
                  if (k.gt.1) var = ycv(k,j) - ycv(k - 1,j)
                  sumsq = sumsq + var*w(i,k)**2
               enddo
               vip(i,1) = vip(i,1) + sumsq  
            enddo
            vip(i,1) = sqrt(dip*vip(i,1)/sumij)
         enddo    
      endif
      if (orig.eq.1) then
c
c calculate for B-new = B-old, Intercept = Y-bar - X-bar*B 
c        
         if (iscale.eq.-1) then
            do j = 1, my
               sumij = zero
               do i = 1, ip
                  sumij = sumij + xbar(i)*b(i,j)
               enddo  
               ob(1,j) = ybar(j) - sumij
            enddo  
            do j = 1, my
               do i = 1, ip
                  ob(i + 1,j) = b(i,j)
               enddo   
            enddo 
         else
c
c calculate for B-new = xstd^{-1}*B*ystd, intercept = ybar - xbar*xstd^{-1}*B*ystd
c where xstd and ystd are taken to be diagonal matrices
c           
            do j = 1, my
               sumij = zero
               do i = 1, ip
                  sumij = sumij + xbar(i)*b(i,j)*ystd(j)/xstd(i)
               enddo  
               ob(1,j) = ybar(j) - sumij
            enddo  
            do j = 1, my
               do i = 1, ip
                  ob(i + 1,j) = b(i,j)*ystd(j)/xstd(i)
               enddo   
            enddo      
         endif  
      endif
c
c deallocate
c      
      deallocate (ptw, stat = ierr)
      deallocate (wptwi, stat = ierr)
      end     
c
c



