c
c action: simfit version of g02ldf
c author: w.g.bardsley, university of manchester, u.k.,09/08/2011
c
      subroutine g02ldf$(ip, my, orig, xbar, ybar, iscale, xstd, ystd,
     +                   b, ldb, n, mz, isz, z, ldz, yhat, ldyhat,
     +                   ifail)
      implicit none
c
c arguments
c    
      integer ip, my, orig, iscale, ldb, n, mz, isz(mz), ldz,
     +        ldyhat, ifail
      double precision xbar(ip), ybar(my), xstd(ip), ystd(my),
     +                 b(ldb,my), z(ldz,mz), yhat(ldyhat,my)
c
c locals
c       
      integer    i, iadd1, j, k, l
      double precision xvalue, ymean
      double precision zero, epsi
      parameter (zero = 0.0d+00, epsi = 1.0d-200)
c
c check
c      
      ifail = 1
      
      if (ip.le.1                  .or.
     +    my.lt.1                  .or.
     +    orig.ne.-1.and.orig.ne.1 .or. 
     +    n.lt.1) return
      if (orig.eq.-1) then
         if (iscale.ne.-1.and.iscale.ne.1.and.iscale.ne.2) return
      endif   
      iadd1 = 0
      do i = 1, mz                 
         if (isz(i).lt.0 .or. isz(i).gt.1) return
         if (isz(i).eq.1) iadd1 = iadd1 + 1  
      enddo

      ifail = 3
      
      if (iadd1.ne.ip) return
      
      ifail = 2
      
      if (orig.eq.-1.and.ldb.lt.ip    .or.
     +    orig.eq.1.and.ldb.lt.ip + 1 .or.
     +    mz.lt.ip                    .or.        
     +    ldz.lt.n                    .or.
     +    ldyhat.lt.n) return  
      
      ifail = 0
                 
      if (orig.eq.1) then                                                                          
c
c Case 1 (work out yhat using b = origb): step 1...set Y columns equal to the intercepts
c              
         do j = 1, my    
            ymean = b(1,j)
            do i = 1, n 
               yhat(i,j) = ymean
            enddo
         enddo  
c
c Case 1 (work out y using b = origb): step 2...add X*B to the Y intercepts
c            
         do i = 1, n
            do j = 1, my 
               l = 1
               do k = 1, mz  
                  if (isz(k).eq.1) then 
                      l = l + 1
                      yhat(i,j) = yhat(i,j) + z(i,k)*b(l,j)
                  endif 
               enddo   
            enddo
         enddo 
      else
c
c Case 2 (work out y using b): step 1...set Y columns equal to 0
c                               Note: first Z is transformed to Z1
c                                     then Y-hat1 is calculated
c                                     finally Y-hat1 is transformed into Y-hat 
c                    
         do j = 1, my
            do i = 1, n 
               yhat(i,j) = zero
            enddo
         enddo  
c
c Case 2 (work out y using b): step 2...action depends on iscale           

c            
          if (iscale.eq.1) then        
            do i = 1, n  
               do j = 1, my 
                  l = 0
                  do k = 1, mz 
                     if (isz(k).eq.1) then
                         l = l + 1
                         xvalue = z(i,k) - xbar(l)
                         xvalue = xvalue/max(xstd(l),epsi)
                         yhat(i,j) = yhat(i,j) + b(l,j)*xvalue 
                     endif
                  enddo 
                  yhat(i,j) = yhat(i,j)*ystd(j) + ybar(j)
               enddo
            enddo
         else 
            do i = 1, n  
               do j = 1, my 
                  l = 0
                  do k = 1, mz 
                     if (isz(k).eq.1) then
                        l = l + 1
                        xvalue = z(i,k) - xbar(l)
                        yhat(i,j) = yhat(i,j) + b(l,j)*xvalue 
                     endif
                  enddo
                  yhat(i,j) = yhat(i,j) + ybar(j)
               enddo
            enddo
         endif   
      endif
      end
c
c             