C
C
      SUBROUTINE G03AAF$(MATRIX, STD, WEIGHT, N, M, Z, LDZ, ISX, S, WT,
     +                   NVAR, E, LDE, P, LDP, V, LDV, WK, IFAIL)
C
C ACTION: Version of G03AAF
C AUTHOR: W.G.Bardsley, University of manchester, U.K., 30/07/2001
C         14/01/2006 changed X and LDX in argument list to Z and LDZ, and
C                    introduced allocatable workspace so Z is now unchanged
C         09/03/2006 used X for intermediate calls to LAPACK instead of P to
C                    avoid LDP < NCASE in calls to F08KFF and F08MEF then
C                    copied required elements of X into P before exit
C
C         Notes:
C         ======
C         1) The dimension of WK should be at least NVAR*NVAR + 5*(NVAR - 1)
C            to agree with the NAG routine.
C         2) This version defines internal workspace of dimension LWORK
C            and does not use WK supplied for SVD workspace
C         3) In this version the SVD calls LAPACK routines indirectly
C            through F08 and does not use the workspace provided in WK
C         4) IFAIL is returned as 10 if workspace allocation fails
C         5) Uses LDX > N and NCMAX > M to avoid crashes in LAPACK
C            Specifically: F08KEF$ to DGEBRD to DGEBD2 to DLARF to DGEMV
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    N, M, LDZ, ISX(M), NVAR, LDE, LDP, LDV, IFAIL
      DOUBLE PRECISION Z(LDZ,M), S(M), WT(*), E(LDE,6), P(LDP,NVAR),
     +                 V(LDV,NVAR), WK(NVAR*NVAR + 5*(NVAR - 1))
      CHARACTER  MATRIX*1, STD*1, WEIGHT*1
C
C Local allocatable arrays
C
      DOUBLE PRECISION, ALLOCATABLE :: D(:), EE(:), TAUP(:), TAUQ(:),
     +                                 WORK(:), X(:,:)
C
C Locals
C
      INTEGER    I, IADD1, IERR, IFSAV, INFO, J, K, LDC, MM, NCASE, NN
      INTEGER    LDX, LWORK, NCMAX, NMAX, NB, N0
      PARAMETER (NB = 64, N0 = 0)
      DOUBLE PRECISION C(1,1)
      DOUBLE PRECISION AIJ, AJI, ARG1, ARG2, CHISQD, DN, DNM1, DV, DOF,
     +                 PMK, PVAL, SDNM1, WSUM, XBAR, XSCALE, XSIG, XVAR
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, FIVE, SIX
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, FIVE = 5.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION G01ECF$
      EXTERNAL   F08KEF$, F08KFF$, F08MEF$, G01ECF$
      INTRINSIC  DBLE, SQRT, LOG
      WK(1) = ONE!to silence ftn95
C
C Part 1: Is it safe ?
C =======
C
      IF (M.LT.1 .OR. N.LT.2 .OR. NVAR.LT.1 .OR. NVAR.GT.M .OR.
     +    NVAR.GE.N .OR. LDZ.LT.N .OR. LDV.LT.N .OR. LDP.LT.NVAR .OR.
     +    LDE.LT.NVAR) THEN
          IFAIL = 1
          RETURN
      ENDIF
C
C MATRIX must be 'C', 'S', 'U', or 'V'
C
      IF (MATRIX.EQ.'C' .OR. MATRIX.EQ.'c') THEN
         IFAIL = 0
      ELSEIF (MATRIX.EQ.'S' .OR. MATRIX.EQ.'s') THEN
         IFAIL = 0
      ELSEIF (MATRIX.EQ.'U' .OR. MATRIX.EQ.'u') THEN
          IFAIL = 0
      ELSEIF (MATRIX.EQ.'V' .OR. MATRIX.EQ.'v' ) THEN
         IFAIL = 0
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C STD must be 'S', 'U', 'Z', or 'E'
C
      IF (STD.EQ.'S' .OR. STD.EQ.'s') THEN
         IFAIL = 0
      ELSEIF (STD.EQ.'U' .OR. STD.EQ.'u') THEN
         IFAIL = 0
      ELSEIF (STD.EQ.'Z' .OR. STD.EQ.'z') THEN
         IFAIL = 0
      ELSEIF (STD.EQ.'E' .OR. STD.EQ.'e') THEN
         IFAIL = 0
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C WEIGHT must be 'U', or 'W'
C
      IF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         IFAIL = 0
         NCASE = N
      ELSEIF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
C
C Check and calculate WSUM (the sum of the weights)
C
         IFAIL = 0
         NCASE = 0
         WSUM = ZERO
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ELSEIF (WT(I).GT.ZERO) THEN
               NCASE = NCASE + 1
               WSUM = WSUM + WT(I)
            ENDIF
         ENDDO
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Check for sufficient variables
C
      IADD1 = 0
      DO I = 1, M
         IF (ISX(I).GT.0) IADD1 = IADD1 + 1
      ENDDO
      IF (IADD1.NE.NVAR) THEN
         IFAIL = 3
         RETURN
      ENDIF
C
C Check for sufficient data
C
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         IADD1 = 0
         DO I = 1, N
            IF (WT(I).GT.ZERO) IADD1 = IADD1 + 1
         ENDDO
         IF (IADD1.LT.NVAR + 1) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDIF
C
C Check for S > 0
C
      IF (MATRIX.EQ.'S' .OR. MATRIX.EQ.'s') THEN
         DO I = 1, M
            IF (S(I).LE.ZERO .AND. ISX(I).GT.0) THEN
               IFAIL = 4
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C Allocate workspace and copy Z into X
C
      IFSAV = IFAIL
      IFAIL = 10
      LDX = N + 1
      LWORK = NB*(N + M)
      NCMAX = M + 2
      NMAX = M + N
      IERR = N0
      IF (ALLOCATED(D)) DEALLOCATE(D, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(EE)) DEALLOCATE(EE, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(TAUP)) DEALLOCATE(TAUP, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(TAUQ)) DEALLOCATE(TAUQ, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (D(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (EE(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (TAUP(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (TAUQ(NMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (WORK(LWORK), STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE (X(LDX,NCMAX), STAT = IERR)
      IF (IERR.NE.N0) RETURN
C
C Copy Z into X, and Z is not used again
C
      DO J = 1, M
         DO I = 1, N
            X(I,J) = Z(I,J)
         ENDDO
      ENDDO
      IFAIL = IFSAV
C
C Part 2: contract the X matrix if necessary
C =======
C Left shift the data matrix columns if necessary
C
      IF (NVAR.LT.M) THEN
         IADD1 = 0
         DO J = 1, M
            IF (ISX(J).GT.0) THEN
               IADD1 = IADD1 + 1
               DO I = 1, N
                 X(I,IADD1) = X(I,J)
               ENDDO
            ENDIF
         ENDDO
      ENDIF
C
C Up shift the data matrix rows if necessary
C
      IF (NCASE.LT.N) THEN
         IADD1 = 0
         DO I = 1, N
            IF (WT(I).GT.ZERO) THEN
               IADD1 = IADD1 + 1
               DO J = 1, NVAR
                  X(IADD1,J) = X(I,J)
               ENDDO
            ENDIF
         ENDDO
      ENDIF
C
C Part 3: Define DN, DNM1, DV and SDNM1 then manipulate the data matrix
C =======
C
      DN = DBLE(NCASE)
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         DNM1 = WSUM - ONE
      ELSE
         DNM1 = DBLE(NCASE - 1)
      ENDIF
      DV = DBLE(NVAR)
      SDNM1 = SQRT(DNM1)
      IADD1 = 0
      DO J = 1, M
C
C Calculate the column mean, etc.
C
         IF (ISX(J).GT.0) THEN
            IADD1 = IADD1 + 1
            XBAR = ZERO
            IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
C
C The weighted means
C
               K = 0
               DO I = 1, N
                  IF (WT(I).GT.ZERO) THEN
                     K = K + 1
                     XBAR = XBAR + WT(I)*X(K,IADD1)
                   ENDIF
               ENDDO
               XBAR = XBAR/WSUM
            ELSE
C
C The unweighted means
C
               DO I = 1, NCASE
                  XBAR = XBAR + X(I,IADD1)
               ENDDO
               XBAR = XBAR/DN
            ENDIF
            IF (MATRIX.EQ.'C' .OR. MATRIX.EQ.'c') THEN
C
C Correlation matrix so calculate the column standard deviation
C
               XVAR = ZERO
               IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
C
C The weighted standard deviations
C
                  K = 0
                  DO I = 1, N
                     IF (WT(I).GT.ZERO) THEN
                        K = K + 1
                        XVAR = XVAR + WT(I)*(X(K,IADD1) - XBAR)**2
                     ENDIF
                  ENDDO
               ELSE
C
C The unweighted standard deviations
C
                  DO I = 1, NCASE
                     XVAR = XVAR + (X(I,IADD1) - XBAR)**2
                  ENDDO
               ENDIF
               XVAR = XVAR/DNM1
               S(J) = XVAR
               XSIG = SQRT(XVAR)
               XSCALE = ONE/(XSIG*SDNM1)
            ELSEIF (MATRIX.EQ.'S' .OR. MATRIX.EQ.'s') THEN
C
C The standardised matrix
C
               XSCALE = ONE/S(J)
            ELSEIF (MATRIX.EQ.'U' .OR. MATRIX.EQ.'u') THEN
C
C The sums of squares and products matrix
C
               XSCALE = ONE
            ELSE
C
C The variance covariance matrix
C
               XSCALE = ONE/SDNM1
            ENDIF
C
C Now centralise and scale the data matrix
C
            DO I = 1, NCASE
               X(I,IADD1) = (X(I,IADD1) - XBAR)*XSCALE
            ENDDO
         ELSEIF (MATRIX.EQ.'C' .OR. MATRIX.EQ.'c') THEN
            S(J) = ZERO
         ENDIF
      ENDDO
C
C Use the weights supplied
C
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         IADD1 = 0
         DO I = 1, N
            IF (WT(I).GT.ZERO) THEN
               IADD1 = IADD1 + 1
               XSIG = SQRT(WT(I))
               DO J = 1, NVAR
                  X(IADD1,J) = XSIG*X(IADD1, J)
               ENDDO
            ENDIF
         ENDDO
      ENDIF
C
C Part 4: Now the SVD
C =======
C
      MM = NCASE
      NN = NVAR
      LDC = 1
C
C Reduce X to bidiagonal form
C
      CALL F08KEF$(MM, NN, X, LDX, D, EE, TAUQ, TAUP, WORK, LWORK,
     +             INFO)
      IF (INFO.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
C
C Copy X to V to use as workspace in calls to F08
C
      DO J = 1, NVAR
         DO I = 1, NCASE
            V(I,J) = X(I,J)
         ENDDO
      ENDDO
C
C The SVD using LAPACK (both options left in for possible future
C development but only 1 will be used since MM always > NN)
C
      IF (MM.GE.NN) THEN
          CALL F08KFF$('P', NN, NN, MM, X, LDX, TAUP, WORK, LWORK,
     +                 INFO)
          CALL F08KFF$('Q', MM, NN, NN, V, LDV, TAUQ, WORK, LWORK,
     +                 INFO)
          CALL F08MEF$('Upper', NN, NN, MM, N0, D, EE, X, LDX, V,
     +                  LDV, C, LDC, WORK, INFO)
      ELSE
          CALL F08KFF$('P', MM, NN, MM, X, LDX, TAUP, WORK, LWORK,
     +                 INFO)
          CALL F08KFF$('Q', MM, MM, NN, V, LDV, TAUQ, WORK, LWORK,
     +                 INFO)
          CALL F08MEF$('Lower', MM, NN, MM, N0, D, EE, X, LDX, V,
     +                 LDV, C, LDC, WORK, INFO)
      ENDIF
C
C Check for satisfactory SVD
C
      IF (INFO.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
C
C Part 5: prepare the E matrix for output
C =======
C Load the E matrix with zeros
C
      DO J = 1, 6
        DO I = 1, NVAR
           E(I,J) = ZERO
        ENDDO
      ENDDO
C
C Eigenvalues in column 1
C
      XSCALE = ZERO
      DO I = 1, NVAR
         E(I,1) = D(I)**2
         XSCALE = XSCALE + E(I,1)
      ENDDO
C
C Proportions in column 2
C
      DO I = 1, NVAR
         E(I,2) = E(I,1)/XSCALE
      ENDDO
C
C Cumulatives in column 3
C
      E(1,3) = E(1,2)
      DO I = 2, NVAR
         E(I,3) = E(I - 1,3) + E(I,2)
      ENDDO
C
C chi-square in column 4, dof in column 5, p in column 6
C
      IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
         XSCALE = WSUM - ONE -(TWO*DV + FIVE)/SIX
      ELSE
         XSCALE = DN - ONE -(TWO*DV + FIVE)/SIX
      ENDIF
      DO K = 0, NVAR - 2
         PMK = DV - DBLE(K)
         ARG1 = ZERO
         ARG2 = ZERO
         DO I = K + 1, NVAR
            IF (E(I,1).GT.ZERO) THEN
               ARG1 = ARG1 + LOG(E(I,1))
               ARG2 = ARG2 + E(I,1)
            ENDIF
         ENDDO
         IF (ARG2.GT.ZERO) THEN
            CHISQD = XSCALE*(-ARG1 + PMK*LOG(ARG2/PMK))
         ELSE
            CHISQD = ZERO
         ENDIF
         DOF = HALF*(PMK - ONE)*(PMK + TWO)
         E(K + 1,4) = CHISQD
         E(K + 1,5) = DOF
         IF (MATRIX.NE.'C' .AND. MATRIX.NE.'c') THEN
            INFO = 0
            PVAL = G01ECF$('U', CHISQD, DOF, INFO)
            IF (INFO.EQ.0) E(K + 1,6) = PVAL
         ENDIF
      ENDDO
C
C Part 6: Prepare P and V for output
C =======
C First copy relevent part of X into P then transpose P
C
      DO J = 1, NVAR
         DO I = 1, NVAR
            P(I,J) = X(I,J)
         ENDDO
      ENDDO
      DO I = 2, NVAR
         DO J = 1, I - 1
            AIJ = P(I,J)
            AJI = P(J,I)
            P(I,J) = AJI
            P(J,I) = AIJ
         ENDDO
      ENDDO
C
C Multiply V by D if STD = 'U'
C
      IF (STD.EQ.'U' .OR. STD.EQ.'u') THEN
         DO J = 1, NVAR
            DO I = 1, NCASE
               V(I,J) = V(I,J)*D(J)
            ENDDO
         ENDDO
      ENDIF
C
C Standardise the active part of V to unit variance if STD = 'Z' or 'E'
C
      IF (STD.EQ.'Z' .OR. STD.EQ.'z' .OR.
     +    STD.EQ.'E' .OR. STD.EQ.'e') THEN
         IF (WEIGHT.EQ.'W' .OR. WEIGHT.EQ.'w') THEN
            DO J = 1, NVAR
               IADD1 = 0
               XVAR = ZERO
               DO I = 1, N
                  IF (WT(I).GT.ZERO) THEN
                     IADD1 = IADD1 + 1
                     XVAR = XVAR + V(IADD1,J)**2
                  ENDIF
               ENDDO
               IF (WSUM.GT.ONE) THEN
                  XVAR = XVAR/(WSUM - ONE)
                  IF (XVAR.GT.ZERO) THEN
                     XSIG = SQRT(XVAR)
                     DO I = 1, NCASE
                        V(I,J) = V(I,J)/XSIG
                     ENDDO
                  ENDIF
               ENDIF
            ENDDO
         ELSE
            DO J = 1, NVAR
               XBAR = ZERO
               XVAR = ZERO
               DO I = 1, NCASE
                 XBAR = XBAR + V(I,J)
               ENDDO
               XBAR = XBAR/DN
               DO I = 1, NCASE
                  XVAR = XVAR + (V(I,J) - XBAR)**2
               ENDDO
               XVAR = XVAR/DBLE(NCASE - 1)
               IF (XVAR.GT.ZERO) THEN
                  XSIG = SQRT(XVAR)
                  DO I = 1, NCASE
                     V(I,J) = V(I,J)/XSIG
                  ENDDO
               ENDIF
            ENDDO
         ENDIF
      ENDIF
C
C Standardise the active part of V to eigenvalue variance if STD = 'E'
C
      IF (STD.EQ.'E' .OR. STD.EQ.'e') THEN
         DO J = 1, NVAR
            DO I = 1, NCASE
               V(I,J) = D(J)*V(I,J)
            ENDDO
         ENDDO
      ENDIF
C
C Introduce zero rows into V if cases have been suppressed
C
      IF (NCASE.LT.N) THEN
         DO J = 1, NVAR
            DO I = NCASE + 1, N
               V(I,J) = ZERO
            ENDDO
         ENDDO
         DO I = 1, N
            IF (WT(I).LE.ZERO) THEN
               IF (I.LT.N) THEN
                  DO J = N, I + 1, -1
                     DO K = 1, NVAR
                        V(J,K) = V(J - 1,K)
                     ENDDO
                  ENDDO
               ENDIF
               DO K = 1, NVAR
                  V(I,K) = ZERO
               ENDDO
            ENDIF
         ENDDO
      ENDIF
C
C Deallocate workspaces
C
      DEALLOCATE (D, STAT = IERR)
      DEALLOCATE (EE, STAT = IERR)
      DEALLOCATE (TAUP, STAT = IERR)
      DEALLOCATE (TAUQ, STAT = IERR)
      DEALLOCATE (WORK, STAT = IERR)
      DEALLOCATE (X, STAT = IERR)
      END
C
C
