C
C This version has DAFG03$ appended temporarily to prevent crash in academic version
C
C
      SUBROUTINE G03ACF$(WEIGHT, N, M, X, LDX, ISX, NX, ING, NG, WT,
     +                   NIG, CVM, LDCVM, E, LDE, NCV, CVX, LDCVX, TOL,
     +                   IRANKX, WK, IWK, IFAIL)
C
C ACTION: Substitute for G03ACF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 08/01/2004
C         15/04/2005 appended DAFG03$ to prevent crash in academic version
C         14/01/2006 introduces allocatable workspaces
C
C         The method uses eigenvalues/eigenvectors and not SVD like NAG so I must
C         revise it to use SVD and delete the local workspaces sometime soon
C
C         Note: this version does not use IFAIL as NAG does or apply weighting
C               In fact it returns IFAIL = -10 if weighting is requested but
C               IFAIL is returned as for NAG otherwise
C               Local arrays should not be necessary and could be removed
C               if required to just use the original WK workspace.
C               In this version it is best if IWK is an exact multiple of N
C               say IWK = N*(NX + 2) as WK is partitioned for use as a N by NX + 1
C               matrix in the calls to G03DAF$ and DAFG03$
C               GC must be dimensioned at least (NG + 2)*NX*(NX + 1)/2 otherwise,
C               if the problem is too large for G03DAF$/DAFG03$ then it exits
C               with IFAIL = -20
C               Failure to allocate workspace leads to exit with IFAIL = 10
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER N, M, LDX, ISX(M), NX, ING(N), NG, NIG(NG), LDCVM, LDE,
     +        NCV, LDCVX, IRANKX, IWK, IFAIL
      DOUBLE PRECISION X(LDX,M), WT(*), CVM(LDCVM,NX), E(LDE,6),
     +                 CVX(LDCVX,NG-1), TOL, WK(IWK)
      CHARACTER WEIGHT*1
C
C Local allocatable arays
C
      INTEGER, ALLOCATABLE :: IWORK(:)
      DOUBLE PRECISION, ALLOCATABLE :: D(:), DET(:), GC(:), TB(:,:),
     +                                 TW(:,:), TT(:,:)
C
C Locals
C
      INTEGER    I, IERR, IFSAV, ISEND, J, K, L
      INTEGER    IADD1, INFO, ITYPE, NBIG, NSTART
      INTEGER    NCMAX, NDMAX, NRMAX
      DOUBLE PRECISION DENOM, FACTOR, STAT, DF, SIG, XBAR
      DOUBLE PRECISION TOL1
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION X02AJF$, G01ECF$
      CHARACTER  JOBZ*1, TAIL*1, UPLO*1
      LOGICAL    ABORT
      INTRINSIC  MAX, MIN, SQRT, DBLE, LOG
      EXTERNAL   X02AJF$, G03DAF$, G01ECF$
      EXTERNAL   DAFG03$, UTRANU, DSYGV, SVDV01
C
C Initialise
C
      IFAIL = 0
      IRANKX = 0
      NCV = 0
      DO I = 1, NG
         NIG(I) = 0
      ENDDO
C
C Is it safe ?
C
      IF (NX.LT.1 .OR.
     +    NG.LT.2 .OR.
     +    M.LT.NX .OR.
     +    N.LT.NX + NG .OR.
     +    LDX.LT.N .OR.
     +    LDCVX.LT.NX .OR.
     +    LDCVM.LT.NG .OR.
     +    LDE.LT.MIN(NX,NG-1)) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (NX.GE.NG - 1) THEN
         I = N*NX + MAX(5*(NX - 1) + NX*(NX + 1), N)
      ELSE
         I = N*NX + MAX(5*(NX - 1) + NX*(NG - 1), N)
      ENDIF
      IF (IWK.LT.I) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (TOL.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ELSE
        TOL1 = SQRT(X02AJF$())                                                                                                                                                                                                             <nr
        IF (TOL.GT.TOL1) TOL1 = TOL
      ENDIF
      IF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         I = 1!to silence ftn95
      ELSE
C
C Error exit with IFAIL = -10 if weighting is requested
C
         IFAIL = -10
         RETURN
      ENDIF
      DO I = 1, N
         J = ING(I)
         IF (J.LT.1 .OR. J.GT.NG) THEN
            IFAIL = 3
            RETURN
         ELSE
            NIG(J) = NIG(J) + 1
         ENDIF
      ENDDO
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (NX.NE.J) THEN
         IFAIL = 4
         RETURN
      ENDIF
      J = 0
      DO I = 1, NG
         IF (NIG(I).GT.0) J = J + 1
      ENDDO
      IF (J.LT.2 .OR. J + NX.GT.N) THEN
         IFAIL = 7
         RETURN
      ENDIF
C
C Allocate workspaces
C
      IFSAV = IFAIL
      IFAIL = 10
      IERR = 0
      NCMAX = NX + 1
      NDMAX = NG + 2
      NRMAX = (NG + 2)*NX*(NX + 1)/2 + 1
      IF (ALLOCATED(IWORK)) DEALLOCATE(IWORK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(D)) DEALLOCATE(D, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(DET)) DEALLOCATE(DET, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(GC)) DEALLOCATE(GC, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TB)) DEALLOCATE(TB, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TW)) DEALLOCATE(TW, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(TT)) DEALLOCATE(TT, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (IWORK(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (D(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (DET(NDMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (GC(NRMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (TB(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (TW(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE (TT(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Find the rank
C
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            DO I = 1, N
               K = K + 1
               WK(K) = X(I,J)
            ENDDO
         ENDIF
      ENDDO
      I = 0
      CALL SVDV01 (I, IWK, N, NX, IRANKX, WK, TOL, ABORT)
      IF (ABORT .OR. IRANKX.EQ.0) THEN
         IFAIL = 8
         RETURN
      ENDIF
C
C Error exit with IFAIL = -20 if data set is too large
C
      IF ((NG + 2)*NX*(NX + 1)/2.GT.NRMAX .OR. NX.GT.NCMAX) THEN
         IFAIL = -20
         RETURN
      ENDIF
C
C ***********************
C start calculations here
C ***********************
C
      CALL G03DAF$(WEIGHT, N, M, X, LDX, ISX, NX, ING, NG, WT, NIG,
     +             CVM, LDCVM, DET, GC, STAT, DF, SIG, WK, IWORK, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
      CALL DAFG03$(WEIGHT, N, M, X, LDX, ISX, NX, ING, NG, WT, NIG,
     +             CVM, LDCVM, DET, GC, STAT, DF, SIG, WK, IWORK, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
c
c create tw
c
      nstart = 1
      isend = 1
      call utranu (isend, nx, ncmax, tw, gc(nstart), abort)
      if (abort) then
         ifail = 5
         return
      endif
      factor = dble(n - ng)
      do j = 1, nx
         do i = 1, nx
            tw(i,j) = factor*tw(i,j)
         enddo
      enddo
c
c create tt
c
      nbig = nx*(nx + 1)/2
      nstart = (ng + 1)*nbig + 1
      call utranu (isend, nx, ncmax, tt, gc(nstart), abort)
      if (abort) then
         ifail = 5
         return
      endif
      factor = dble(n - 1)
      do j = 1, nx
         do i = 1, nx
            tt(i,j) = factor*tt(i,j)
         enddo
      enddo
c
c create tb = tt - tw
c
      do j = 1, nx
         do i = 1, nx
            tb(i,j) = tt(i,j) - tw(i,j)
         enddo
      enddo
C
C eigenvalues and eigenvectors
C
      itype = 1
      jobz = 'V'
      uplo = 'U'
      call dsygv (itype, jobz, uplo, nx, tb, ncmax, tw, ncmax, d,
     +            wk, iwk, info)
      if (info.ne.0) then
         ifail = 5
         return
      endif
C
C fill in E(i,1) to E(i,3) by peeling off the eigenvalues in reverse order
C

      NCV = MIN(NG - 1, IRANKX)
      DENOM = ZERO
      DO I = 1, NCV
         E(I,2) = D(NX - I + 1)
         E(I,1) = SQRT(E(I,2)/(ONE + E(I,2)))
         IF (E(I,1).GE.ONE) THEN
            IFAIL = 6
            RETURN
         ENDIF
         DENOM = DENOM + E(I,2)
      ENDDO
      DO I = 1, NCV
         E(I,3) = E(I,2)/DENOM
      ENDDO
C
C the chi-square statistics for E(i,4) to E(i,6)
C
      FACTOR = DBLE(N - 1 - NG) - HALF*DBLE(IRANKX - NG)
      TAIL = 'U'
      DO I = 1, NCV
         STAT = ZERO
         DO J = I, NCV
            STAT = STAT + LOG(ONE + E(J,2))
         ENDDO
         J = 1
         STAT = FACTOR*STAT
         DF = DBLE((IRANKX - I + 1)*(NG - I))
         E(I,4) = STAT
         E(I,5) = DF
         E(I,6) =  G01ECF$(TAIL, STAT, DF, J)
      ENDDO
C
C fill in CVX by peeling off the eigenvectors in reverse order and re-scaling
C
      FACTOR = SQRT(DBLE(N - NG))
      DO J = 1, NCV
         DO I = 1, NX
            CVX(I,J) = FACTOR*TB(I,NX - J + 1)
         ENDDO
      ENDDO
C
C calculate the original column means to center the data matrix
C
      do i = 1, m
         wk(i) = zero
      enddo
      denom = dble(n)
      do j = 1, m
         if (isx(j).gt.0) then
            do i = 1, n
               wk(j) = wk(j) + x(i,j)
            enddo
            wk(j) = wk(j)/denom
         endif
      enddo
C
C calculate the means of the column centered data
C
      DO J = 1, NCV
         DO I = 1, NG
            XBAR = ZERO
            DO K = 1, N
               IF (ING(K).EQ.I) THEN
                  IADD1 = 0
                  DO L = 1, M
                     IF (ISX(L).GT.0) THEN
                        IADD1 = IADD1 + 1
                        XBAR = XBAR + CVX(IADD1,J)*(X(K,L) - WK(L))
                     ENDIF
                  ENDDO
               ENDIF
            ENDDO
            CVM(I,J) = XBAR/DBLE(NIG(I))
         ENDDO
      ENDDO
C
C Deallocate workspaces
C
      DEALLOCATE (IWORK, STAT = IERR)
      DEALLOCATE (D, STAT = IERR)
      DEALLOCATE (DET, STAT = IERR)
      DEALLOCATE (GC, STAT = IERR)
      DEALLOCATE (TB, STAT = IERR)
      DEALLOCATE (TW, STAT = IERR)
      DEALLOCATE (TT, STAT = IERR)
      END
C
C
      SUBROUTINE DAFG03$(WEIGHT, N, M, X, LDX, ISX, NVAR, ING, NG,
     +                   WT, NIG, GMEAN, LDG, DET, GC, STAT, DF,
     +                   SIG, WK, IWK, IFAIL)
C
c ACTION: further calculations to fill in the gaps left by G03DAF
C AUTHOR: W.G.Bardsley, University of Manchester, 23/10/2003
C         24/02/2005 replaced dgeqrf by f08aef$
C         14/01/2006 ibtroduced allocatable workspace
C
C WARNING: This version does not yet do weighting and it does not change X
C          It uses LAPACK/DGEQRF/QR and appends to the output from G03DAF as follows:
C GMEAN: appends the overall means as row NG + 1
C    GC: appends R from (NG + 1)*NVAR*(NVAR + 1)/2 + 1 onwards for overall CV
C   DET: appends DET(NG + 1) = log(pooled), DET(NG + 2) = log(overall)
C  Note: this requires increased dimensions for GMEAN, GC and DET
C
      IMPLICIT NONE
C
C Arguments supplied
C
      INTEGER N, M, LDX, ISX(M), NVAR, ING(N), NG, NIG(NG), LDG,
     +        IWK(NG), IFAIL
      DOUBLE PRECISION X(LDX,M), WT(*), GMEAN(LDG,NVAR), DET(NG + 2),
     +                 GC((NG + 2)*NVAR*(NVAR + 1)/2), STAT, DF, SIG,
     +                 WK(N,NVAR + 1)
      CHARACTER*1 WEIGHT
C
C Local variables (TAU and Work are required for LAPACK routine DGEQRF)
C
      INTEGER    I, IERR, IFSAV, INFO, J, K, K1, K2, L, NBIG
      INTEGER    NB, LWORK, NWORK
      PARAMETER (NB = 64)
      DOUBLE PRECISION DENOM
      DOUBLE PRECISION, ALLOCATABLE :: TAU(:), WORK(:)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  W*1
      INTRINSIC  DBLE, SQRT, LOG, MIN
      EXTERNAL   F08AEF$
C
C Use dummy arguments to stop ftn95 complaining. they may be needed for future revision.
C
      I = NIG(1)
      DENOM = STAT
      DENOM = DF
      DENOM = SIG
      I = IWK(1)
C
C Check WEIGHT and initialise IFAIL
C
      IF (WEIGHT.EQ.'u' .OR. WEIGHT.EQ.'U') THEN
         W = 'U'
         IFAIL = 0
      ELSEIF (WEIGHT.EQ.'w' .OR. WEIGHT.EQ.'W') THEN
         W = 'W'
         IFAIL = -10
         RETURN
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Is it safe ?
C
      IF (NVAR.LT.1 .OR. NG.LT.2 .OR. M.LT.NVAR .OR. LDX.LT.N .OR.
     +    LDG.LT.NG + 1) THEN
          IFAIL = 1
          RETURN
      ENDIF
      IF (W.EQ.'W') THEN
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ENDIF
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (J.NE.NVAR) THEN
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 1, N
         J = ING(I)
         IF (J.LT.1 .OR. J.GT.NG) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDDO
C
C Calculate the means
C
      L = NG + 1
      DO J = 1, NVAR
         GMEAN(L,J) = ZERO
      ENDDO
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            K = K + 1
            DO I = 1, N
               GMEAN(L,K) = GMEAN(L,K) + X(I,J)
            ENDDO
         ENDIF
      ENDDO
      DENOM = DBLE(N)
      DO J = 1, NVAR
         GMEAN(L,J) = GMEAN(L,J)/DENOM
      ENDDO
C
C QR factorisation 1. initialise GC then create the ordered and centered matrix
C
      NBIG = NVAR*(NVAR + 1)/2
      DO I = L*NBIG + 1, (L + 1)*NBIG
         GC(I) = ZERO
      ENDDO
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            K = K + 1
            DO I = 1, N
               WK(I,K) = X(I,J) - GMEAN(L,K)
            ENDDO
         ENDIF
      ENDDO
C
C QR factorisation 2: factorise the ordered and centered overall matrix
C
      IFSAV = IFAIL
      IFAIL = 10
      IERR = 0
      LWORK = NB*N
      NWORK = MIN(M,N) + 1
      IF (ALLOCATED(TAU)) DEALLOCATE(TAU, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(TAU(NWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
      CALL F08AEF$(N, NVAR, WK, N, TAU, WORK, LWORK, INFO)
      DEALLOCATE(TAU, STAT = IERR)
      DEALLOCATE(WORK, STAT = IERR)
      IF (INFO.NE.0) THEN
         IFAIL = 4
         RETURN
      ENDIF
C
C QR factorisation 3: store the factors in GC
C
      DENOM = SQRT(DBLE(N - 1))
      K = L*NBIG
      DO J = 1, NVAR
         DO I = 1, J
            K = K + 1
            GC(K) = WK(I,J)/DENOM
         ENDDO
      ENDDO
C
C Create the extra determinants
C
      K = NG + 1
      L = NG + 2
      DET(K) = ONE
      DET(L) = ONE
      K1 = 0
      K2 = (NG + 1)*NBIG
      DO J = 1, NVAR
         DO I = 1, J
            K1 = K1 + 1
            K2 = K2 + 1
            IF (I.EQ.J) THEN
               DET(K) = DET(K)*GC(K1)*GC(K1)
               DET(L) = DET(L)*GC(K2)*GC(K2)
            ENDIF
         ENDDO
      ENDDO
      DET(K) = LOG(DET(K))
      DET(L) = LOG(DET(L))
      END
C
C




