c
c
      SUBROUTINE G03ADF$(WEIGHT, N, M, Z, LDZ, ISZ, NX, NY, WT, E, LDE,
     +                   NCV, CVX, LDCVX, MCV, CVY, LDCVY, TOL, WK, IWK,
     +                   IFAIL)

C***********************************************************************
C NAG = .TRUE. THEN USE NAG FORMULA FOR EIGENVALUES O/W RETURN SQUARES
C Setting NAG = .FALSE. gives the correct result as there was an error
C in the NAG library at least up to Mark 21
C************************************************************************

C
C ACTION: Substitute for G03ADF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K. 03/02/2004
C         15/01/2006 introduced allocatable workspaces
C
C Note: this version does not use IFAIL exactly as NAG does or apply weighting.
C       In fact it returns IFAIL = -10 if weighting is requested and
C       IFAIL = -20 if IWK is too small but o/w IFAIL is returned as for NAG.
C       Local arrays CVXX, CVYY, and V should not be necessary and could be
C       removed if required to just use the original WK workspace.
C       The minimum dimension for WK is IWK >= N*(NX + NY) + NX*NX + NY*NY as
C       the arrays D_x*P_x^T and D_y*P_y^T are stored as well as Q_x and Q_y
C       This version returns IFAIL = 10 if it cannot allocate workspace
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER N, M, LDZ, ISZ(M), NX, NY, LDE, NCV, LDCVX, MCV, LDCVY,
     +        IWK, IFAIL
      DOUBLE PRECISION Z(LDZ,M), WT(*), E(LDE,6), CVX(LDCVX,MCV),
     +                 CVY(LDCVY,MCV), TOL, WK(IWK)
      CHARACTER WEIGHT*1
C
C Local allocatable arrays
C
      INTEGER, ALLOCATABLE :: IPIV(:)
      DOUBLE PRECISION, ALLOCATABLE :: CVXX(:,:), CVYY(:,:), V(:,:)
C
C Locals
C
      INTEGER    I, IERR, IFSAV, ISEND, J, K, L, LX, LY, L1, L2
      INTEGER    KX, KY, KSTART
      INTEGER    NCMAX
      DOUBLE PRECISION XBAR, YBAR
      DOUBLE PRECISION DENOM, DF, FACTOR, STAT
      DOUBLE PRECISION TOL1
      DOUBLE PRECISION ZERO, HALF, ONE
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00)
      DOUBLE PRECISION X02AJF$, G01ECF$
      CHARACTER  TAIL*1
      LOGICAL    ABORT, NAG
      INTRINSIC  MAX, MIN, SQRT, DBLE, LOG
      EXTERNAL   X02AJF$, G01ECF$
      EXTERNAL   SVDV01, SVD000, DGESV
C
C Part 1: Initialise then check input parameters
C =======
C
      NAG = .FALSE.
      IFAIL = 0
      NCV = 0
C
C Is it safe ?
C
      IF (NX.LT.1 .OR.
     +    NY.LT.1 .OR.
     +    M.LT.NX + NY .OR.
     +    N.LE.NX + NY .OR.
     +    MCV.LT.MIN(NX,NY) .OR.
     +    LDZ.LT.N .OR.
     +    LDCVX.LT.NX .OR.
     +    LDCVY.LT.NY .OR.
     +    LDE.LT.MIN(NX,NY)) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (NX.GE.NY) THEN
         I = N*NX + NX + NY + MAX((5*(NX - 1) + NX*NX), N*NY)
      ELSE
         I = N*NY + NX + NY + MAX((5*(NY - 1) + NY*NY), N*NX)
      ENDIF
      IF (IWK.LT.I) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (TOL.LT.ZERO) THEN
         IFAIL = 1
         RETURN
      ELSE
        TOL1 = SQRT(X02AJF$())                                                                                                                                                                                                             <nr
        IF (TOL.GT.TOL1) TOL1 = TOL
      ENDIF
      IF (WEIGHT.EQ.'U' .OR. WEIGHT.EQ.'u') THEN
         I = 1!to silence ftn95
      ELSE
C
C Error exit with IFAIL = -10 if weighting is requested
C
         IFAIL = -10
         DF = WT(1)!to silence ftn95
         RETURN
      ENDIF
      J = 0
      K = 0
      DO I = 1, M
         IF (ISZ(I).GT.0) THEN
            J = J + 1
         ELSEIF (ISZ(I).LT.0) THEN
            K = K + 1
         ENDIF
      ENDDO
      IF (NX.NE.J .OR. NY.NE.K) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (N.LT.NX + NY + 1) THEN
         IFAIL = 4
         RETURN
      ENDIF
C
C Error exit with IFAIL = -20 if insufficient storage space
C
      I =  N*(NX + NY) + NX*NX + NY*NY
      IF (I.GT.IWK) THEN
         IFAIL = -20
         RETURN
      ENDIF
C
C Allocate workspace
C
      IERR = 0
      IFSAV = IFAIL
      IFAIL = 10
      NCMAX = MAX(NX,NY) + 1
      IF (ALLOCATED(IPIV)) DEALLOCATE(IPIV, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(CVXX)) DEALLOCATE(CVXX, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(CVYY)) DEALLOCATE(CVYY, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(V)) DEALLOCATE(V, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(IPIV(NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(CVXX(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(CVYY(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(V(NCMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Part 2: centralise X then create Q_x
C =======
C
      DENOM = DBLE(N)
      DF = DBLE(N - 1)
      K = 0
      L = 0
      DO J = 1, M
         IF (ISZ(J).GT.0) THEN
            L = L + 1
            XBAR = ZERO
            DO I = 1, N
               XBAR = XBAR + Z(I,J)
            ENDDO
            XBAR = XBAR/DENOM
            DO I = 1, N
               K = K + 1
               WK(K) = Z(I,J) - XBAR
            ENDDO
         ENDIF
      ENDDO
C
C Perform partial SVD on X ... left singular vectors will be stacked columnwise
C
      K = N*NX + NX*NX
      ISEND = 7
      CALL SVDV01 (ISEND, K, N, NX, KX, WK, TOL, ABORT)
      IF (ABORT) THEN
         IFAIL = 5
         RETURN
      ENDIF
      IF (KX.LE.0) THEN
         IFAIL = 7
         RETURN
      ENDIF
C
C Store Q_x in the last N*NX consecutive cells of WK
C
       KSTART = IWK - N*NX
       K = KSTART
       DO I = 1, N*NX
          K = K + 1
          WK(K) = WK(I)
       ENDDO
C
C Store D*V^T in NX*NX locations before Q_x
C
       KSTART = IWK - N*NX - NX*NX
       K = KSTART
       DO I = N*NX + 1, N*NX + NX*NX
          K = K + 1
          WK(K) = WK(I)
       ENDDO
C
C Part 3: centralise Y then create Q_y
C ======
C
      K = 0
      L = 0
      DO J = 1, M
         IF (ISZ(J).LT.0) THEN
            L = L + 1
            YBAR = ZERO
            DO I = 1, N
               YBAR = YBAR + Z(I,J)
            ENDDO
            YBAR = YBAR/DENOM
            DO I = 1, N
               K = K + 1
               WK(K) = Z(I,J) - YBAR
            ENDDO
         ENDIF
      ENDDO
C
C Perform partial SVD on Y...left singular vectors will be stored stacked columnwise
C
      K = N*NY + NY*NY
      ISEND = 7
      CALL SVDV01 (ISEND, K, N, NY, KY, WK, TOL, ABORT)
      IF (ABORT) THEN
         IFAIL = 5
         RETURN
      ENDIF
      IF (KY.LE.0) THEN
         IFAIL = 7
         RETURN
      ENDIF
C
C---------------------------------------------------------
C The contents of WK are now as follows:
C WK(1) to WK(N*NY) the first NY columns of Q_y
C WK(N*NY + 1) to WK(N*NY + NY*NY) D*VT for Y
C WK(IWK - N*NX - NX*NX + 1) to WK(IWK - N*NX) D*VT for X
C WK(IWK - N*NX + 1) to WK(IWK) the first NX columns of Q_x
C-----------------------------------------------------------
C
C
C Part 4: Calculate NCV, V, then do SVD on V
C =======
C
      NCV = MIN(KX,KY)
C
C Calculate V as (Q_x^T)*Q_y
C
      KSTART = IWK - N*NX
      DO I = 1, KX
         LX = KSTART + (I - 1)*N
         DO J = 1, KY
            FACTOR = ZERO
            LY = (J - 1)*N
            L1 = LX
            L2 = LY
            DO K = 1, N
               L1 = L1 + 1
               L2 = L2 + 1
               FACTOR = FACTOR + WK(L1)*WK(L2)
            ENDDO
            V(I,J) = FACTOR
         ENDDO
      ENDDO
C
C Perform full SVD of V...left singular vectors in CVXX, S(i) in E(i,1), right in CVYY
C
      ISEND = 5
      CALL SVD000 (ISEND, NCMAX, NCMAX, NCMAX, KX, KY, V, E, CVXX, CVYY)
      IF (ISEND.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
C
C Part 5: fill in E
C =======
C
      DENOM = ZERO
      DO I = 1, NCV
         IF (E(I,1).GE.ONE) THEN
            IFAIL = 6
            RETURN
         ENDIF
         IF (NAG) THEN
            E(I,2) = E(I,1)**2/(ONE - E(I,1)**2)
         ELSE
            E(I,2) = E(I,1)**2
         ENDIF

         DENOM = DENOM + E(I,2)
      ENDDO
      DO I = 1, NCV
         E(I,3) = E(I,2)/DENOM
      ENDDO
C
C the chi-square statistics for E(i,4) to E(i,6)
C
      FACTOR = DBLE(N) - HALF*DBLE(KX + KY + 3)
      TAIL = 'U'
      DO I = 1, NCV
         STAT = ZERO
         IF (NAG) THEN
            DO J = I, NCV
               STAT = STAT + LOG(ONE + E(J,2))
            ENDDO
         ELSE
            DO J = I, NCV
               STAT = STAT - LOG(ONE - E(J,2))
            ENDDO
         ENDIF
         J = I - 1
         STAT = FACTOR*STAT
         DF = DBLE((KX - J)*(KY - J))
         E(I,4) = STAT
         E(I,5) = DF
         J = 1
         E(I,6) = G01ECF$(TAIL, STAT, DF, J)
      ENDDO
C
C Part 6: calculate and normalise loadings
C =======
C
      KSTART = IWK - N*NX - NX*NX
      K = KSTART
      DO J = 1, NX
         DO I = 1, NX
            K = K + 1
            V(I,J) = WK(K)
         ENDDO
      ENDDO
      CALL DGESV (KX, NCV, V, NCMAX, IPIV, CVXX, NCMAX, IFAIL)
      DF = SQRT(DBLE(N - 1))
      DO J = 1, NCV
         DO I = 1, KX
            CVX(I,J) = DF*CVXX(I,J)
         ENDDO
      ENDDO
      KSTART = N*NY
      K = KSTART
      DO J = 1, NY
         DO I = 1, NY
            K = K + 1
            V(I,J) = WK(K)
         ENDDO
      ENDDO
C
C Transpose CVYY before calculating loadings for Y
C
      DO J = 1, NY
         DO I = 1, NY
            CVXX(I,J) = CVYY(J,I)
         ENDDO
      ENDDO
      CALL DGESV (KY, NCV, V, NCMAX, IPIV, CVXX, NCMAX, IFAIL)
      DO J = 1, NCV
         DO I = 1, KY
            CVY(I,J) = DF*CVXX(I,J)
         ENDDO
      ENDDO
C
C Deallocate workspaces
C
      DEALLOCATE(IPIV, STAT = IERR)
      DEALLOCATE(CVXX, STAT = IERR)
      DEALLOCATE(CVYY, STAT = IERR)
      DEALLOCATE(V, STAT = IERR)
      END

C
C




