 
C
C 04/01/2013 simfit replacement for NAG routine G03BAF 
C
      SUBROUTINE G03BAF$(STAND, G, NVAR, K, FL, LDF, FLR, R, LDR, ACC, 
     +                   MAXIT, ITER, WK, IFAIL)
      IMPLICIT NONE
C
C Arguments
C       
      INTEGER NVAR, K, LDF, LDR, MAXIT, ITER, IFAIL
      DOUBLE PRECISION G, FL(LDF,K), FLR(LDF,K), R(LDR,K), ACC,
     +                 WK(2*NVAR + K*K + 5*(K - 1))
      CHARACTER*1 STAND
C
C Allocatables
C       
      INTEGER, ALLOCATABLE :: IPIV(:)
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:), B(:,:)
      INTEGER I, INFO, IOS, J, NNF
C
C Locals
C     
      DOUBLE PRECISION EPSI, GAMMA
      DOUBLE PRECISION ZERO, EMAX, EMIN
      PARAMETER (ZERO = 0.0D+00, EMAX = 1.0D+00, EMIN = 1.0D-14)
      CHARACTER (LEN = 1) STAND1
      EXTERNAL   VARMX, DGESV
      INTRINSIC  SQRT
C
C Initialise IFAIL then check input arguments to agree with NAG
C      
      IFAIL = 0
      IF  (K.LT.2      .OR.
     +     NVAR.LT.K   .OR.   
     +     G.LT.ZERO   .OR.
     +     LDF.LT.NVAR .OR.
     +     LDR.LT.K    .OR.
     +     ACC.LT.ZERO .OR.
     +     MAXIT.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF   
      IF (STAND.EQ.'S' .OR. STAND.EQ.'s') THEN
          STAND1 = 'S'
      ELSEIF (STAND.EQ.'U' .OR. STAND.EQ.'u') THEN
         STAND1 = 'U'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF          
      IF (ACC.LT.EMIN .OR. ACC.GT.EMAX) THEN
         EPSI = EMIN
      ELSE
         EPSI = ACC
      ENDIF      
c
c Allocate additional workspace for convenience
c
      ios = 0
      ifail = -10
      if (allocated(ipiv)) deallocate (ipiv, stat = ios)
      if (ios.ne.0) return 
      ifail = -11   
      if (allocated(a)) deallocate (a, stat = ios)
      if (ios.ne.0) return  
      ifail = -12
      if (allocated(b)) deallocate (b, stat = ios)
      if (ios.ne.0) return  
      ifail = -13
      i = k
      allocate (ipiv(k), stat = ios)
      if (ios.ne.0) return  
      ifail = -14 
      i = k
      allocate (a(i,i), stat = ios)  
      if (ios.ne.0) return  
      ifail = -15
      allocate (b(i,i), stat = ios)  
      if (ios.ne.0) return 
c
c copy fl into flr and save normalising factors in wk(1) to wk(nvar) if required
c
      if (stand1.eq.'S') then
         do i = 1, nvar
            wk(i) = zero
            do j = 1, k
               wk(i) = wk(i) +  fl(i,j)**2
            enddo
            wk(i) = sqrt(wk(i))
            do j = 1, k
               flr(i,j) = fl(i,j)/wk(i)
            enddo     
         enddo  
      else
         do i = 1, nvar
            do j = 1, k
               flr(i,j) = fl(i,j)
            enddo  
         enddo      
      endif  
c
c save a copy of the first k rows and columns of data or normalised data
c    
      do i = 1, k
         do j = 1, k
            b(i,j) = flr(i,j)
         enddo  
      enddo  
c
c call varmx with wk(nvar+1) to wk(2*nvar) for fnorm and nnf = -k to prevent rearranging
c
      nnf = -k
      gamma = g
      call varmx (iter, ldf, maxit, k, nvar, nnf,
     +            flr, epsi, wk(nvar + 1), gamma) 
     
      if (iter.eq.maxit) ifail = 3
c        
c---------------------------------------------------
c The SVD refinement used by NAG could be added here  
c before the rotation matrix is calculated
c---------------------------------------------------
c 
       
c
c copy the first k rows and columns of the rotated matrix into a
c
      do i = 1, k
         do j = 1, k
            a(i,j) = flr(i,j) 
         enddo   
      enddo  
c
c use lapack to solve a*x = b where the solution is the rotattion matrix
c      
      call dgesv (k, k, a, k, ipiv, b, k, info)
      if (info.ne.0) then
         ifail = 18
         deallocate(ipiv, stat = ios)
         deallocate(a, stat = ios)
         deallocate(b, stat = ios)
         return
      endif   
c
c copy the transpose into r
c
      do j = 1, k
         do i = 1, k
            r(i,j) = b(j,i)
         enddo   
      enddo  
c
c de-standardise if stand = 'S'
c        
      if (stand1.eq.'S') then
          do i = 1, nvar
             do j = 1, k
                flr(i,j) = flr(i,j)*wk(i)
             enddo   
          enddo   
      endif
c
c deallocate
c
      deallocate (ipiv, stat = ios)
      deallocate (a, stat = ios)
      deallocate (b, stat = ios)
c
c assign ifail
c      
      ifail = 0
      end
c
c------------------------------------------------------------------------------------------------
c
      subroutine varmx (iter, lda, maxit, ncol, nv, nnf,
     +                  aload, epsi, fnorm, gamma)
      implicit none
c
c 03/01/2012 Original code by Doug Hawkins edited by bill.bardsley@manchester.ac.uk as follows:
c            New arguments iter, lda, maxit, ncol, epsi, fnorm, gamma
c            Tabbed the do loops and added a couple of continue statements for better readability
c            Iterations are now returned as iter
c            Array fnorm is now supplied as an argument and maxit limits the number of attempts
c            Note that gamma is added to the calculation of the objective function and also 
c            to the numerator and denominator in the angle calculation
c            An additional exit test is made to agree with NAG

c------------------------------------------------------------------------------------------------  
c     Original header to subroutine varmx
c    
c     subroutine varmx (aload, nv, nnf)
c     implicit double precision (a-h,o-z)
c     routine to do a varimax rotation on the real array aload(nv,nnf).
c     if nnf is positive, the routine feels free to reverse and reorder
c     the factors; this is suppressed in nnf is entered as the negative
c     of its actual value.  this suppression is desirable when doing
c     a q-mode analysis.
c----------------------------------------------------------------------

c
c arguments
c      
      integer,          intent (out)   :: iter
      integer,          intent (in)    :: lda, maxit, ncol, nv, nnf
      double precision, intent (inout) :: aload(lda,ncol), fnorm(*)
      double precision, intent (in)    :: epsi, gamma 
c
c locals
c      
      integer    i, ict, iflip, inoim, irot, j, j1, k, nf,  nf1
      double precision a, angl, a1, a2, b, c, crit, d, fden,
     +                 fnum, fnv, ocrit, s, sq, ss, s2, t, trot, u, v
      double precision test
      double precision one, two, qrtr, zero
      parameter (one = 1.0d+00, two = 2.0d+00, qrtr = 0.25d+00,
     +           zero = 0.0d+00)
      double precision eps1, eps2, eps3
      parameter (eps1 = 1.0d-05, eps2 = 1.0d-05, eps3 = 1.0d-10)
      intrinsic  dabs, dble, cos, sin, max
c
c check arguments
c     
      nf = iabs(nnf)
      if (nv .le. 0 .or. nf .le. 1) return
c
c initialise and store the objective function before rotating
c        
      inoim = 0
      ict = 0
      iter = ict
      irot = 0
      crit = zero
      fnv = dble(nv)
      nf1 = nf - 1
      
      do 4 j = 1, nf
         s2 = zero
         do 5 i = 1, nv
            sq = aload(i,j) ** 2
            s2 = s2 + sq
            crit = crit + sq * sq
 5       continue
         crit = crit - gamma * (s2 * s2) / fnv
 4    continue
 
c
c enter the iteration loop
c
      
 10   continue
 
      iflip = 0
      do 1 j = 1, nf1
         j1 = j + 1
      do 1 k = j1, nf
         a = zero
         b = zero
         c = zero
         d = zero
         
         do 2 i = 1, nv
            u = aload(i,j) ** 2 - aload(i,k) ** 2
            v = two * aload(i,j) * aload(i,k)
            a = a + u
            b = b + v
            c = c + u * u - v * v
            d = d + u * v
 2       continue
 
         fden = fnv * c + gamma * (b * b - a * a)
         fnum = two * (fnv * d - gamma * a * b)
         if (dabs(fnum) .lt. eps1 * dabs(fden)) go to 1
         iflip = 1
         irot = irot + 1
         
         angl = qrtr * atan2(fnum, fden)

         a1 = cos(angl)
         a2 = sin (angl)
         do 3 i = 1, nv
            t = a1 * aload(i,j) + a2 * aload(i,k)
            aload(i,k) = -a2 * aload(i,j) + a1 * aload(i,k)
            aload(i,j) = t
 3       continue
 1    continue
 
      ict = ict + 1
      ocrit = crit
      crit = zero
      do 12 j = 1, nf
         s2 = zero
         do 13 i = 1, nv
            sq = aload(i,j) ** 2
            s2 = s2 + sq
            crit = crit + sq * sq
 13      continue
         crit = crit - gamma * (s2 * s2) / fnv
 12   continue
 
      if (dabs(crit).gt.eps3) then 
         trot = (crit - ocrit) / crit
      else   
         trot = (crit - ocrit) / eps3
      endif   
      inoim = inoim + 1
      if (dabs(trot) .gt. eps2) inoim = 0
c*****if (inoim .lt. 2 .and. ict .lt. 50 .and. iflip .ne. 0) go to 10
      if (inoim .lt. 2 .and. ict .lt. maxit .and. iflip .ne. 0) go to 10
        
c        
c The NAG test
c 
      if (iter.lt.maxit) then
         test = epsi*max(one,dabs(crit))
         if (dabs(ocrit - crit) .gt. test) go to 10
      endif  

c
c iterations are now completed but re-ordering has been requested if nnf > 0
c
        
      if (nnf .lt. 0) go to 30
c
c additional code to rearrange for the case nnf > 0
c        
      do 20 j = 1, nf
         s = zero
         ss = zero
         do 21 i = 1, nv
            s = s + aload(i,j)
            ss = ss + aload(i,j) ** 2
 21      continue
         fnorm(j) = ss
         if (s .gt. zero) go to 23
         do 22 i = 1, nv
            aload(i,j) = - aload(i,j)
 22      continue
 23      continue
      do 20 k = 1, j
         if (fnorm(k) .ge. fnorm(j)) go to 20
         t = fnorm(k)
         fnorm(k) = fnorm(j)
         fnorm(j) = t
         do 25 i = 1, nv
            t = aload(i,j)
            aload(i,j) = aload(i,k)
            aload(i,k) = t
 25      continue
 20   continue
 30   continue
c
c assign iter
c 
      iter = ict
      return
      end
c
