C
C
      SUBROUTINE G03BCF$(STAND, PSCALE, N, M, X, LDX, Y, LDY, YHAT,
     +                   R, LDR, ALPHA, RSS, RES, WK, IFAIL)
C  
C Action: Simfit version of G03BCF
C Author: w.g.bardsley, 01/08/2012  
C 
C Note the following details about workspaces and additional routines called.  
C This version uses WK(1) to WK(M) to store singular values from SVD000
C and WK(M**2 + 6M) to WK(M**2 + 7M) to store the Y centroid for translation.
C It uses DGEMM for matrix multiplication and SVD000 which calls DGESVD
C for the SVD. Additional workspace is allocated dynamically for intermediate
C matrices, rather than trying to stick to the NAG workspace requirement.
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER N, M, LDX, LDY, LDR, IFAIL
      DOUBLE PRECISION X(LDX,M), Y(LDY,M), YHAT(LDY,M), R(LDR,M),
     +                 ALPHA, RSS, RES(N), WK(M*M + 7*M)
      CHARACTER STAND*1, PSCALE*1
C
C Allocatable
C      
      DOUBLE PRECISION, ALLOCATABLE :: Y_COPY(:,:), C(:,:), U(:,:), 
     +                                 VT(:,:)
C
C Locals
C      
      INTEGER    I, IERR, J, K, LDC, LDU, LDVT
      INTEGER    ISEND
      DOUBLE PRECISION DN, CSUM, ROOTX, ROOTY, TRACE, XSSQ, YSSQ, ZSSQ
      DOUBLE PRECISION ZERO, ONE, EPSI
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, EPSI = 1.0D-300)
      CHARACTER (LEN = 1) S_COPY, P_COPY
      EXTERNAL   DGEMM, SVD000
      INTRINSIC  DBLE, SQRT
      IFAIL = 0
C
C Check the dimensions and arguments supplied
C      
      IF (N.LT.M   .OR.
     +    M.LT.1   .OR.
     +    LDX.LT.N .OR.
     +    LDY.LT.N .OR.
     +    LDR.LT.M) THEN
         IFAIL = 1
         RETURN
      ENDIF 
      IF (STAND.EQ.'N' .OR. STAND.EQ.'n') THEN  
         S_COPY = 'N'
      ELSEIF (STAND.EQ.'Z' .OR. STAND.EQ.'z') THEN
         S_COPY = 'Z'  
      ELSEIF (STAND.EQ.'C' .OR. STAND.EQ.'c') THEN
         S_COPY = 'C'
      ELSEIF (STAND.EQ.'U' .OR. STAND.EQ.'u') THEN
         S_COPY = 'U'
      ELSEIF (STAND.EQ.'S' .OR. STAND.EQ.'s') THEN
         S_COPY = 'S'
      ELSEIF (STAND.EQ.'M' .OR. STAND.EQ.'m') THEN
         S_COPY = 'M'  
      ELSE
         IFAIL = 1
         RETURN
      ENDIF 
      IF (PSCALE.EQ.'S' .OR. PSCALE.EQ.'s') THEN
         P_COPY = 'S'
      ELSEIF (PSCALE.EQ.'U' .OR. PSCALE.EQ.'u') THEN
         P_COPY = 'U'
      ELSE
         IFAIL = 1
         RETURN    
      ENDIF 
C
C Save Y if required as Y_COPY to allow return with no rounding 
C      
      IF (S_COPY.EQ.'C' .OR.
     +    S_COPY.EQ.'M') THEN
         IERR = 0
         IF (ALLOCATED(Y_COPY)) DEALLOCATE(Y_COPY, STAT = IERR)
         IF (IERR.NE.0) THEN
            IFAIL = 10
            RETURN
         ENDIF   
         I = N
         J = M  
         ALLOCATE (Y_COPY(I,J), STAT = IERR)
         IF (IERR.NE.0) THEN
            IFAIL = 11
            RETURN
         ENDIF   
         DO J = 1, M
            DO I = 1, N
               Y_COPY(I,J) = Y(I,J)
            ENDDO   
         ENDDO         
      ENDIF   
C
C Scaling X
C     
      DN = DBLE(N)  
      IF (S_COPY.EQ.'Z' .OR.
     +    S_COPY.EQ.'C' .OR. 
     +    S_COPY.EQ.'S' .OR. 
     +    S_COPY.EQ.'M') THEN
         DO J = 1, M
            CSUM = ZERO
            DO I = 1, N
               CSUM = CSUM + X(I,J)
            ENDDO
            CSUM = CSUM/DN
            DO I = 1, N
               X(I,J) = X(I,J) - CSUM
            ENDDO      
         ENDDO 
      ENDIF
      
      XSSQ = ZERO
      DO J = 1, M
         DO I = 1, N
            XSSQ = XSSQ + X(I,J)**2
         ENDDO  
      ENDDO 
      IF (XSSQ.LE.EPSI) THEN
         IFAIL = 2
         RETURN
      ENDIF
      
      IF (S_COPY.EQ.'U' .OR.
     +    S_COPY.EQ.'S' .OR.
     +    S_COPY.EQ.'M') THEN
         ROOTX = SQRT(XSSQ)
         DO J = 1, M
            DO I = 1, N
               X(I,J) = X(I,J)/ROOTX
            ENDDO  
         ENDDO
      ENDIF     
C
C Scaling Y
C     
      IF (S_COPY.EQ.'Z' .OR.
     +    S_COPY.EQ.'C' .OR. 
     +    S_COPY.EQ.'S' .OR.         
     +    S_COPY.EQ.'M') THEN
         K = M**2 + 6*M
         DO J = 1, M
            CSUM = ZERO
            DO I = 1, N
               CSUM = CSUM + Y(I,J)
            ENDDO
            CSUM = CSUM/DN
            DO I = 1, N
               Y(I,J) = Y(I,J) - CSUM
            ENDDO  
C
C Store the Y-centroid in the last M places of WK
C            
            K = K + 1
            WK(K) = CSUM    
         ENDDO 
      ENDIF
      
      YSSQ = ZERO
      DO J = 1, M
         DO I = 1, N
            YSSQ = YSSQ + Y(I,J)**2
         ENDDO  
      ENDDO 
      IF (YSSQ.LE.EPSI) THEN
         IFAIL = 2
         RETURN
      ENDIF
      
      IF (S_COPY.EQ.'U' .OR.
     +    S_COPY.EQ.'S') THEN
         ROOTY = SQRT(YSSQ)
         DO J = 1, M
            DO I = 1, N
               Y(I,J) = Y(I,J)/ROOTY
            ENDDO  
         ENDDO
      ENDIF 
C
C additional X-scaling if required
C      
      IF (S_COPY.EQ.'M') THEN
         ROOTY = SQRT(YSSQ)
         DO J = 1, M
            DO I = 1, N
               X(I,J) = X(I,J)*ROOTY
            ENDDO  
         ENDDO  
      ENDIF 
C
C Allocate temporary workpspaces
C
      IERR = 0
      IF (ALLOCATED(C)) DEALLOCATE(C, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 12
         RETURN
      ENDIF  
      IF (ALLOCATED(U)) DEALLOCATE(U, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 13
         RETURN
      ENDIF
      IF (ALLOCATED(VT)) DEALLOCATE(VT, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 14
         RETURN
      ENDIF  
      LDC = N
      I = M + 2 
      ALLOCATE(C(LDC,I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 15
         RETURN
      ENDIF   
      LDU = M 
      ALLOCATE(U(LDU,I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 16
         RETURN
      ENDIF
      LDVT = M 
      ALLOCATE(VT(LDVT,I), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 17
         RETURN
      ENDIF   
C
C Form C = X^T*Y
C
      CALL DGEMM ('T', 'N', M, M, N,
     +            ONE, X, LDX, Y, LDY, ZERO, C, LDC)      
C
C SVD ... Note that ISEND from SVD000 returns INFO from DGESVD as follows:
C         ISEND < 0 argument(isend) is illegal
C         ISEND = 0 OK
C         ISEND > 0 failed SVD  
C
      ISEND = 5
      CALL SVD000 (ISEND, LDC, LDU, LDVT, M, M,
     +             C, WK, U, VT)
      IF (ISEND.NE.0) THEN
         IFAIL = 4
         RETURN
      ENDIF   
      TRACE = ZERO
      DO I = 1, M
         TRACE = TRACE + WK(I)
      ENDDO   
C
C Form R = U*VT
C 
      CALL DGEMM ('N', 'N', M, M, M,
     +            ONE, U, LDU, VT, LDVT, ZERO, R, LDR) 
     
C
C Form YHAT and ALPHA if required
C 
      IF (P_COPY.EQ.'U') THEN
         ALPHA = ONE
      ELSE
         IF (S_COPY.EQ.'U' .OR.
     +       S_COPY.EQ.'S') THEN
            ALPHA = TRACE
         ELSEIF (S_COPY.EQ.'M') THEN
            ALPHA = TRACE/YSSQ   
         ELSE   
            ALPHA = TRACE/XSSQ
         ENDIF   
      ENDIF     
      CALL DGEMM ('N', 'N', N, M, M,
     +            ALPHA, X, LDX, R, LDR, ZERO, YHAT, LDY) 
C
C Calculate RSS and RES
C 
      RSS = ZERO
      DO I = 1, N
         RES(I) = ZERO
         DO J = 1, M
            ZSSQ = (Y(I,J) - YHAT(I,J))**2 
            RES(I) = RES(I) + ZSSQ
            RSS = RSS + ZSSQ
         ENDDO  
         RES(I) = SQRT(RES(I)) 
      ENDDO  
                 
C
C Restore Y if required and translate YHAT back using stored centroid
C      
      IF (S_COPY.EQ.'C' .OR.
     +    S_COPY.EQ.'M') THEN
         K = M**2 + 6*M
         DO J = 1, M
            K = K + 1
            DO I = 1, N
               Y(I,J) = Y_COPY(I,J)
               YHAT(I,J) = YHAT(I,J) + WK(K) 
            ENDDO   
         ENDDO 
      ENDIF      

C
C Deallocate
C      
      DEALLOCATE(C, STAT = IERR)        
      DEALLOCATE(U, STAT = IERR)        
      DEALLOCATE(VT, STAT = IERR)        
      DEALLOCATE(Y_COPY, STAT = IERR)        
      END
C
C
