C
C------------------------------------
C SIMFIT version of G03CCF 04/03/2013
C------------------------------------
C
      SUBROUTINE G03CCF$(METHOD, ROTATE, NVAR, NFAC, FL, LDFL, PSI,
     +                   E, R, LDR, FS, LDFS, WK, IFAIL) 
      IMPLICIT NONE
C
C arguments
C      
      INTEGER NVAR, NFAC, LDFL, LDR, LDFS, IFAIL
      DOUBLE PRECISION FL(LDFL,NFAC), PSI(NVAR), E(NVAR), 
     +                 R(LDR,*), FS(LDFS,NFAC), WK(NVAR)
      CHARACTER (LEN = 1) METHOD, ROTATE
C
C locals
C     
      INTEGER    I, J, K
      DOUBLE PRECISION FSUM
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER (LEN = 1) METHOD_COPY, ROTATE_COPY
C
C initialise
C      
      IFAIL = 0 
C
C check
C      
      IF (METHOD.EQ.'R' .OR. METHOD.EQ.'r') THEN
         METHOD_COPY = 'R'
      ELSEIF (METHOD.EQ.'B' .OR. METHOD.EQ.'b') THEN
         METHOD_COPY = 'B'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF 
      IF (ROTATE.EQ.'R' .OR. ROTATE.EQ.'r') THEN
         IF (LDR.LT.NFAC) THEN
            IFAIL = 1
            RETURN
         ENDIF   
         ROTATE_COPY = 'R'
      ELSEIF (ROTATE.EQ.'U' .OR. ROTATE.EQ.'u') THEN
         ROTATE_COPY = 'U'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF                     
      IF (NFAC.LT.1     .OR.
     +    NVAR.LT.NFAC  .OR.           
     +    LDFL.LT.NVAR  .OR.           
     +    LDFS.LT.NVAR) THEN           
        IFAIL = 1
        RETURN
      ENDIF              
      DO I = 1, NVAR
         IF (PSI(I).LE.ZERO .OR. E(I).LE.ZERO) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO
C
C premuliply by 1/PSI
C      
      DO I = 1, NVAR
         WK(I) = ONE/PSI(I)
      ENDDO
      DO J = 1, NFAC
         DO I = 1, NVAR
           FS(I,J) = WK(I)*FL(I,J)   
         ENDDO  
      ENDDO  
C
C postmultiply by 1/E if METHOD = 'R' or 1/(E - 1)
C     
      IF (METHOD_COPY.EQ.'R') THEN    
         DO I = 1, NFAC
            WK(I) = ONE/E(I)
         ENDDO
      ELSE   
         DO I = 1, NFAC
            WK(I) = ONE/(E(I) - ONE)
         ENDDO
      ENDIF   
      DO J = 1, NFAC
         DO I = 1, NVAR
            FS(I,J) = WK(J)*FS(I,J)
         ENDDO  
      ENDDO
C
C rotate if required
C         
      IF (ROTATE_COPY.EQ.'R') THEN
         DO I = 1, NVAR
            DO J = 1, NFAC
               FSUM = ZERO 
               DO K = 1, NFAC
                  FSUM = FSUM + FS(I,K)*R(K,J)
               ENDDO 
               WK(J) = FSUM
            ENDDO  
            DO K = 1, NFAC
               FS(I,K) = WK(K)
            ENDDO
         ENDDO  
      ENDIF
      END      
C
C
