C
C
      SUBROUTINE G03DAF$(WEIGHT, N, M, X, LDX, ISX, NVAR, ING, NG,
     +                   WT, NIG, GMEAN, LDG, DET, GC, STAT, DF,
     +                   SIG, WK, IWK, IFAIL)
C
C Replacement for G03DAF: W.G.Bardsley, University of Manchester, 23/10/2003
C 15/01/2006 introduced allocatable workspaces
C WARNING: This version does not yet do weighting and it does not change X
C It uses LAPACK DGEQRF (and DPOTRF in UTRANU for factorising and inverting C = (U^T)*U)
C Note: unlikely failure in my routine UTRANU returns IFAIL = 5 or 6
C       failure to allocate leads to exit wirh IFAIL = 10
C
      IMPLICIT NONE
C
C Arguments supplied
C
      INTEGER N, M, LDX, ISX(M), NVAR, ING(N), NG, NIG(NG), LDG,
     +        IWK(NG), IFAIL
      DOUBLE PRECISION X(LDX,M), WT(*), GMEAN(LDG,NVAR), DET(NG),
     +                 GC((NG + 1)*NVAR*(NVAR + 1)/2), STAT, DF, SIG,
     +                 WK(N,NVAR + 1)
      CHARACTER*1 WEIGHT
C
C Local allocatable arrays (TAU and Work are required for LAPACK routine DGEQRF)
C
      DOUBLE PRECISION, ALLOCATABLE :: TAU(:), WORK(:)
C
C Locals
C
      INTEGER    I, IERR, IFSAV, INFO, ISEND, J, K, L, NBIG, NCOL, NROW
      INTEGER    LWORK, NB, NTAU
      PARAMETER (NB = 64)
      DOUBLE PRECISION C, DENOM, DNVAR, FACTOR, G
      DOUBLE PRECISION ZERO, ONE, TWO, THREE, SIX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           THREE = 3.0D+00, SIX = 6.0D+00)
      DOUBLE PRECISION G01ECF$
      CHARACTER  W*1, TAIL*1
      PARAMETER (TAIL = 'U')
      LOGICAL    ABORT
      INTRINSIC  DBLE, SQRT, LOG
      EXTERNAL   DGEQRF, UTRANU
      EXTERNAL   G01ECF$
      INTRINSIC  MIN
C
C Check WEIGHT and initialise IFAIL
C
      IF (WEIGHT.EQ.'u' .OR. WEIGHT.EQ.'U') THEN
         W = 'U'
         IFAIL = 0
      ELSEIF (WEIGHT.EQ.'w' .OR. WEIGHT.EQ.'W') THEN
         W = 'W'
         IFAIL = -10
         RETURN
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Is it safe ?
C
      IF (NVAR.LT.1 .OR. NG.LT.2 .OR. M.LT.NVAR .OR. LDX.LT.N .OR.
     +    LDG.LT.NG) THEN
          IFAIL = 1
          RETURN
      ENDIF
      IF (W.EQ.'W') THEN
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ENDIF
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (J.NE.NVAR) THEN
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 1, NG
         NIG(I) = 0
      ENDDO
      DO I = 1, N
         J = ING(I)
         IF (J.LT.1 .OR. J.GT.NG) THEN
            IFAIL = 3
            RETURN
         ENDIF
         NIG(J) = NIG(J) + 1
      ENDDO
      DO I = 1, NG
         IF (NIG(I).LT.NVAR) THEN
            IFAIL = 3
            RETURN
         ENDIF
         IWK(I) = NIG(I) - 1
      ENDDO
C
C Allocate workspace
C
      IERR = 0
      IFSAV = IFAIL
      IFAIL = 10
      LWORK = N*NB
      NTAU = MIN(N,M) + 1
      IF (ALLOCATED(TAU)) DEALLOCATE(TAU, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(TAU(NTAU), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Calculate the means
C
      DO J = 1, NVAR
         DO I = 1, NG
            GMEAN(I,J) = ZERO
         ENDDO
      ENDDO
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            K = K + 1
            DO I = 1, N
               L = ING(I)
               GMEAN(L,K) = GMEAN(L,K) + X(I,J)
            ENDDO
         ENDIF
      ENDDO
      DO I = 1, NG
         DENOM = DBLE(NIG(I))
         DO J = 1, NVAR
            GMEAN(I,J) = GMEAN(I,J)/DENOM
         ENDDO
      ENDDO
C
C QR factorisation 1. initialise GC then create the ordered and centered matrix
C
      NBIG = NVAR*(NVAR + 1)/2
      DO I = 1, NBIG*(NG + 1)
         GC(I) = ZERO
      ENDDO
      DO K = 1, NG
         NROW = 0
         DO I = 1, N
            IF (ING(I).EQ.K) THEN
               NCOL = 0
               NROW = NROW + 1
               DO J = 1, M
                  IF (ISX(J).GT.0) THEN
                     NCOL = NCOL + 1
                     WK(NROW,NCOL) = X(I,J) - GMEAN(K,NCOL)
                  ENDIF
               ENDDO
            ENDIF
         ENDDO
C
C QR factorisation 2: factorise the ordered and centered matrix for group K
C
         CALL DGEQRF (NROW, NCOL, WK, N, TAU, WORK, LWORK, INFO)
         IF (INFO.NE.0) THEN
            IFAIL = 4
            RETURN
         ENDIF
C
C QR factorisation 3: store the log of the determinants for group K
C
         DET(K) = ONE
         FACTOR = DBLE(IWK(K))
         DENOM = SQRT(FACTOR)
         NROW = K*NBIG
         DO J = 1, NVAR
            DO I = 1, J
               NROW = NROW + 1
               GC(NROW) = WK(I,J)/DENOM
               IF (I.EQ.J) DET(K) = DET(K)*(GC(NROW)**2)
            ENDDO
         ENDDO
         DET(K) = LOG(DET(K))
      ENDDO
C
C The statistic 1: zeroise WK then use GC to form the CV for group I
C
      DO J = 1, NVAR
         DO I = 1, 2*NVAR
            WK(I,J) = ZERO
         ENDDO
      ENDDO
      DO I = 1, NG
         J = I*NBIG + 1
         FACTOR = DBLE(IWK(I))
         ISEND = 1
         CALL UTRANU (ISEND, NVAR, N, WK, GC(J), ABORT)
         IF (ABORT) THEN
            IFAIL = 5
            RETURN
         ENDIF
C
C The statistic 2: Add a multiple of the CV in WK to WK offset
C
         DO J = 1, NVAR
            DO K = 1, NVAR
               WK(K + NVAR,J) = WK(K + NVAR,J) + FACTOR*WK(K,J)
            ENDDO
         ENDDO
      ENDDO
C
C The statistic 3: Copy the pooled CV into the top of WK then extract U  into GC
C
      DO J = 1, NVAR
         DO I = 1, NVAR
            WK(I,J) = WK(I + NVAR,J)
         ENDDO
      ENDDO
      ISEND = 2
      CALL UTRANU (ISEND, NVAR, N, WK, GC, ABORT)
      IF (ABORT) THEN
         IFAIL = 6
         RETURN
      ENDIF
C
C The statistic 4: Normalise the pooled covariance matrix
C
      FACTOR = DBLE(N - NG)
      DENOM = SQRT(FACTOR)
      DO I = 1, NBIG
         GC(I) = GC(I)/DENOM
      ENDDO
C
C The statistic 5: Work out the log of the determinant of the pooled CV
C
      G = ONE
      K = 0
      DO J = 1, NVAR
         DO I = 1, J
            K = K + 1
            IF (I.EQ.J) G = G*GC(K)*GC(K)
         ENDDO
      ENDDO
      G = FACTOR*LOG(G)
C
C The statistic 6: Work out the function of the logs of all the determinants
C
      DO I = 1, NG
         G = G - DBLE(IWK(I))*DET(I)
      ENDDO
C
C The statistic 7: Work out the scalar factor then the test statistic
C
      C = ZERO
      DO I = 1, NG
         C = C + ONE/DBLE(IWK(I))
      ENDDO
      C = C - ONE/FACTOR
      DNVAR = DBLE(NVAR)
      DENOM = SIX*(DNVAR + ONE)*DBLE(NG - 1)
      C = ONE - (TWO*DNVAR*DNVAR + THREE*DNVAR - ONE)*C/DENOM
      STAT = C*G
C
C The statistic 8: Finally the degrees of freedom and p value
C
      DF = DNVAR*(DNVAR + ONE)*(DBLE(NG) - ONE)/TWO
      SIG = G01ECF$(TAIL, STAT, DF, IFAIL)
C
C Deallocate workspaces
C
      DEALLOCATE(TAU, STAT = IERR)
      DEALLOCATE(WORK, STAT = IERR)
      END
C
C
