C
C
      SUBROUTINE G03DBF$(EQUAL, MODE, NVAR, NG, GMEAN, LDG, GC, NOBS,
     +                   M, ISX, X, LDX, D, LDD, WK, IFAIL)
C
C SIMFIT Substitute for G03DBF...w.g.bardsley, 19/04/2004
C Notes: (1) works out Mahalobis distances using DTPSV snd DNRM2
C        (2) only uses NVAR out of the 2*NVBAR workspace elements
C

      IMPLICIT NONE
C
C Arguments
C
      INTEGER NVAR, NG, LDG, NOBS, M, ISX(*), LDX, LDD, IFAIL
      DOUBLE PRECISION GMEAN(LDG,NVAR), GC((NG + 1)*NVAR*(NVAR + 1)/2),
     +                 X(LDX,*), D(LDD,NG), WK(2*NVAR)
      CHARACTER*1 EQUAL, MODE
C
C Locals
C
      INTEGER    I, J, K, L, NBIG
      INTEGER    INCX
      PARAMETER (INCX = 1)
      DOUBLE PRECISION ENORM, RTOL
      DOUBLE PRECISION X02AMF$, DNRM2
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  EQUAL1*1, MODE1*1
      CHARACTER  UPLO*1, TRANS*1, DIAG*1
      PARAMETER (UPLO = 'U', TRANS = 'T', DIAG = 'N')
      EXTERNAL   X02AMF$, DTPSV, DNRM2
      INTRINSIC  ABS
C
C Is it safe ?
C
      IFAIL = 0
      IF (EQUAL.EQ.'E' .OR. EQUAL.EQ.'e') THEN
         EQUAL1 = 'E'
      ELSEIF (EQUAL.EQ.'U' .OR. EQUAL.EQ.'u') THEN
         EQUAL1 = 'U'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (MODE.EQ.'M' .OR. MODE.EQ.'m') THEN
         MODE1 = 'M'
      ELSEIF (MODE.EQ.'S' .OR. MODE.EQ.'s') THEN
         MODE1 = 'S'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (NVAR.LT.1 .OR.
     +    NG.LT.2 .OR.
     +    LDG.LT.NG .OR.
     +    MODE1.EQ.'S' .AND. NOBS .LT.1 .OR.
     +    MODE1.EQ.'S' .AND. M.LT.NVAR .OR.
     +    MODE1.EQ.'S' .AND. LDX.LT.NOBS .OR.
     +    MODE1.EQ.'M' .AND. LDD.LT.NG) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (MODE1.EQ.'S') THEN
         J = 0
         DO I = 1, M
            IF (ISX(I).GT.0) J = J + 1
         ENDDO
         IF (J.NE.NVAR) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDIF
      RTOL = X02AMF$()
      NBIG = NVAR*(NVAR + 1)/2
      IF (EQUAL1.EQ.'E') THEN
         J = 0
         DO I = 1, NVAR
            J = J + I
            IF (ABS(GC(J)).LE.RTOL) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ELSE
         J = NBIG
         DO K = 1, NG
            DO I = 1, NVAR
               J = J + I
               IF (ABS(GC(J)).LE.RTOL) THEN
                  IFAIL = 2
                  RETURN
               ENDIF
            ENDDO
         ENDDO
      ENDIF
C
C Data supplied seems OK so initialise D to zero then proceed to calculations
C
      IF (MODE1.EQ.'S') THEN
         K = NOBS
      ELSE
         K = NG
      ENDIF
      DO J = 1, NG
         DO I = 1, K
            D(I,J) = ZERO
         ENDDO
      ENDDO
      IF (EQUAL1.EQ.'E' .AND. MODE1.EQ.'M') THEN
C
C Equal covariances ... group means
C
         DO I = 2, NG
            DO J = 1, I - 1
               DO K = 1, NVAR
                  WK(K) = GMEAN(I,K) - GMEAN(J,K)
               ENDDO
               CALL DTPSV (UPLO, TRANS, DIAG, NVAR, GC, WK, INCX)
               ENORM = DNRM2 (NVAR, WK, INCX)
               D(I,J) = ENORM*ENORM
            ENDDO
         ENDDO
      ELSEIF (EQUAL1.EQ.'U' .AND. MODE1.EQ.'M') THEN
C
C Unequal covariances ... group means
C
         DO I = 1, NG
            DO J = 1, NG
               IF (I.NE.J) THEN
                  DO K = 1, NVAR
                     WK(K) = GMEAN(I,K) - GMEAN(J,K)
                  ENDDO
                  K = J*NBIG + 1
                  CALL DTPSV (UPLO, TRANS, DIAG, NVAR, GC(K), WK, INCX)
                  ENORM = DNRM2 (NVAR, WK, INCX)
                  D(I,J) = ENORM*ENORM
               ENDIF
            ENDDO
         ENDDO
      ELSEIF (EQUAL1.EQ.'E' .AND. MODE1.EQ.'S') THEN
C
C Equal covariances ... sample
C
         DO I = 1, NOBS
            DO J = 1, NG
               K = 0
               DO L = 1, M
                  IF (ISX(L).GT.0) THEN
                     K = K + 1
                     WK(K) = X(I,L) - GMEAN(J,K)
                  ENDIF
               ENDDO
               CALL DTPSV (UPLO, TRANS, DIAG, NVAR, GC, WK, INCX)
               ENORM = DNRM2 (NVAR, WK, INCX)
               D(I,J) = ENORM*ENORM
            ENDDO
         ENDDO
      ELSEIF (EQUAL1.EQ.'U' .AND. MODE1.EQ.'S') THEN
C
C Unequal covariance ... sample
C
         DO I = 1, NOBS
            DO J = 1, NG
               K = 0
               DO L = 1, M
                  IF (ISX(L).GT.0) THEN
                     K = K + 1
                     WK(K) = X(I,L) - GMEAN(J,K)
                  ENDIF
               ENDDO
               K = J*NBIG + 1
               CALL DTPSV (UPLO, TRANS, DIAG, NVAR, GC(K), WK, INCX)
               ENORM = DNRM2 (NVAR, WK, INCX)
               D(I,J) = ENORM*ENORM
            ENDDO
         ENDDO
      ENDIF
      END
C
C






