C
C
      SUBROUTINE G03DCF$(TYP, EQUAL, PRIORS, NVAR, NG, NIG, GMEAN,
     +                   LDG, GC, DET, NOBS, M, ISX, X, LDX, PRIOR,
     +                   P, LDP, IAG, ATIQ, ATI, WK, IFAIL)
C
C SIMFIT Substitute for G03DCF...w.g.bardsley, 04/06/2004
C 05/11/2012 increased RTOL and trapped division by zero when normalising P    
C

      IMPLICIT NONE
C
C Arguments
C
      INTEGER NVAR, NG, NIG(NG), LDG, NOBS, M, ISX(M), LDX, LDP,
     +        IAG(NOBS), IFAIL
      DOUBLE PRECISION GMEAN(LDG,NVAR), GC((NG + 1)*NVAR*(NVAR + 1)/2),
     +                 DET(NG), X(LDX,M), PRIOR(NG), P(LDP,NG),
     +                 ATI(LDP,*), WK(2*NVAR)
      CHARACTER*1 TYP, EQUAL, PRIORS
      LOGICAL ATIQ
C
C Locals
C
      INTEGER    I, J, K, N, NBIG
      DOUBLE PRECISION C, DIFF, DKJ, DN, DNG, DNJ, DNJM1, DNJP1, DNVAR,
     +                 DF1, DF2, EPSI, EXP1, FACTOR, PART1, PART2, PDF,
     +                 PJLOG, PRJ, PSUM, P1, Q, RTOL, TEMP, Z
      DOUBLE PRECISION X02AJF$, X02AMF$, S14ABF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  EQUAL1*1, PRIOR1*1, TYPE1*1
      EXTERNAL   X02AMF$, G01EEF$, S14ABF$, S14BAF$, X02AJF$, G03DBF$
      INTRINSIC  ABS, DBLE, EXP, LOG, SQRT
C
C Is it safe ?
C
      IFAIL = 0
      IF (EQUAL.EQ.'E' .OR. EQUAL.EQ.'e') THEN
         EQUAL1 = 'E'
      ELSEIF (EQUAL.EQ.'U' .OR. EQUAL.EQ.'u') THEN
         EQUAL1 = 'U'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (TYP.EQ.'E' .OR. TYP.EQ.'e') THEN
         TYPE1 = 'E'
      ELSEIF (TYP.EQ.'P' .OR. TYP.EQ.'p') THEN
         TYPE1 = 'P'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (PRIORS.EQ.'E' .OR. PRIORS.EQ.'e') THEN
         PRIOR1 = 'E'
      ELSEIF (PRIORS.EQ.'P' .OR. PRIORS.EQ.'p') THEN
         PRIOR1 = 'P'
      ELSEIF (PRIORS.EQ.'I' .OR. PRIORS.EQ.'i') THEN
         PRIOR1 = 'I'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (NVAR.LT.1 .OR.
     +    NG.LT.2 .OR.
     +    NOBS.LT.1 .OR.
     +    M.LT.NVAR .OR.
     +    LDG.LT.NG .OR.
     +    LDX.LT.NOBS .OR.
     +    LDP.LT.NOBS) THEN
         IFAIL = 1
         RETURN
      ENDIF
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (J.NE.NVAR) THEN
         IFAIL = 2
         RETURN
      ENDIF
      RTOL = 1.0D+09*X02AMF$()
      NBIG = NVAR*(NVAR + 1)/2
      IF (EQUAL1.EQ.'E') THEN
         J = 0
         DO I = 1, NG
            IF (NIG(I).LE.0) THEN
               IFAIL = 2
               RETURN
            ENDIF
            J = J + NIG(I)
         ENDDO
         IF (J.LE.NG + NVAR) THEN
            IFAIL = 2
            RETURN
          ENDIF
         J = 0
         DO I = 1, NVAR
            J = J + I
            IF (ABS(GC(J)).LE.RTOL) THEN
               IFAIL = 4
               RETURN
            ENDIF
         ENDDO
      ELSE
         DO I = 1, NG
            IF (NIG(I).LE.NVAR) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
         J = NBIG
         DO K = 1, NG
            DO I = 1, NVAR
               J = J + I
               IF (ABS(GC(J)).LE.RTOL) THEN
                  IFAIL = 4
                  RETURN
               ENDIF
            ENDDO
         ENDDO
      ENDIF
      EPSI = 10.0D+00*X02AJF$()
      IF (PRIOR1.EQ.'I') THEN
         PSUM = ZERO
         DO I = 1, NG
            IF (PRIOR(I).LE.ZERO) THEN
               IFAIL = 3
               RETURN
            ENDIF
            PSUM = PSUM + PRIOR(I)
         ENDDO
         IF (ABS(ONE - PSUM).GT.EPSI) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDIF
C
C Data supplied seems OK so initialise PRIOR and make sure it is normalised
C
      IF (PRIOR1.EQ.'E') THEN
         TEMP = ONE/DBLE(NG)
         DO I = 1, NG
            PRIOR(I) = TEMP
         ENDDO
      ELSEIF (PRIOR1.EQ.'P') THEN
         PSUM = ZERO
         DO I = 1, NG
            TEMP = DBLE(NIG(I))
            PSUM = PSUM + TEMP
            PRIOR(I) = TEMP
         ENDDO
         DO I = 1, NG
            PRIOR(I) = PRIOR(I)/PSUM
         ENDDO
      ENDIF
      IF (PRIOR1.NE.'I') THEN
C
C Fine tune the internally generated PRIOR(i)
C
         PSUM = ZERO
         DO I = 1, NG
            PSUM = PSUM + PRIOR(I)
         ENDDO
         DO I = 1, NG
            PRIOR(I) = PRIOR(I)/PSUM
         ENDDO
      ENDIF
C
C Get the Mahalanobis squared distances
C
      CALL G03DBF$(EQUAL, 'S', NVAR, NG, GMEAN, LDG, GC, NOBS, M, ISX,
     +             X, LDX, P, LDP, WK, IFAIL)
      IF (IFAIL.NE.0) THEN
         IFAIL = 10 + IFAIL
         RETURN
      ENDIF
C
C Global type scalars
C
      IF (TYPE1.EQ.'P' .AND. EQUAL1.EQ.'E') THEN
         N = 0
         DO I = 1, NG
            N = N + NIG(I)
         ENDDO
         DN = DBLE(N)
         DNG = DBLE(NG)
         DIFF = DN - DNG
      ENDIF
      DNVAR = DBLE(NVAR)
      DF1 = DNVAR/TWO
      IF (TYPE1.EQ.'E' .AND. EQUAL1.EQ.'E') THEN
C
C Case 1: estimative with equal covariance matrices...Linear discrimination
C
         DO J = 1, NG
            PJLOG = LOG(PRIOR(J))
            DO I = 1, NOBS
               DKJ = P(I,J)
               IF (ATIQ) THEN
                  Z = DKJ/TWO
                  CALL S14BAF$(DF1, Z, EPSI, P1, Q, IFAIL)
                  IF (IFAIL.NE.0) THEN
                     IFAIL = -10
                     RETURN
                  ENDIF
                  ATI(I,J) = P1
               ENDIF
               TEMP = - DKJ/TWO + PJLOG
               P(I,J) = EXP(TEMP)
            ENDDO
         ENDDO
      ELSEIF (TYPE1.EQ.'E' .AND. EQUAL1.EQ.'U') THEN
C
C Case 2: estimative with unequal covariance matrices...Quadratic discrimination
C
         DO J = 1, NG
            PJLOG = LOG(PRIOR(J))
            DO I = 1, NOBS
               DKJ = P(I,J)
               IF (ATIQ) THEN
                  Z = DKJ/TWO
                  CALL S14BAF$(DF1, Z, EPSI, P1, Q, IFAIL)
                  IF (IFAIL.NE.0) THEN
                     IFAIL = -10
                     RETURN
                  ENDIF
                  ATI(I,J) = P1
               ENDIF
               TEMP = - DKJ/TWO + PJLOG - DET(J)/TWO
               P(I,J) = EXP(TEMP)
            ENDDO
         ENDDO
      ELSEIF (TYPE1.EQ.'P' .AND. EQUAL1.EQ.'E') THEN
C
C Case 3: predictive with equal covariance matrices
C
         DF2 = (DIFF - DNVAR + ONE)/TWO
         EXP1 = (DIFF + ONE)/TWO
         DO J = 1, NG
            DNJ = DBLE(NIG(J))
            DNJP1 = DNJ + ONE
            FACTOR = DNJP1/DNJ
            PART1 = FACTOR**DF1
            PART2 = ONE/(DIFF*FACTOR)
            PRJ = PRIOR(J)
            IF (ATIQ) FACTOR = ONE/PART2
            DO I = 1, NOBS
               DKJ = P(I,J)
               IF (ATIQ) THEN
                  Z = DKJ/(DKJ + FACTOR)
                  CALL G01EEF$(Z, DF1, DF2, EPSI, P1, Q, PDF, IFAIL)
                  IF (IFAIL.NE.0) THEN
                     IFAIL = -10
                     RETURN
                  ENDIF
                  ATI(I,J) = P1
               ENDIF
               TEMP = PART1*(ONE + PART2*DKJ)**EXP1
               IF (ABS(TEMP).GT.RTOL) THEN
                  P(I,J) = PRJ/TEMP
               ELSE
                  P(I,J) = PRJ
               ENDIF
            ENDDO
         ENDDO
      ELSEIF (TYPE1.EQ.'P' .AND. EQUAL1.EQ.'U') THEN
C
C Case 4: predictive with unequal covariance matrices
C
         DO J = 1, NG
            DNJ = DBLE(NIG(J))
            DNJP1 = DNJ + ONE
            DNJM1 = DNJ - ONE
            EXP1 = DNJ/TWO
            TEMP = (DNJ - DNVAR)/TWO
            PART1 = S14ABF$(TEMP, IFAIL)
            PART2 = S14ABF$(EXP1, IFAIL)
            C = EXP(PART1 - PART2)
            FACTOR = DNJM1*DNJP1/DNJ
            PART1 = C*(FACTOR**DF1)*SQRT(EXP(DET(J)))
            PRJ = PRIOR(J)
            IF (ATIQ) DF2 = (DNJ - DNVAR)/TWO
            DO I = 1, NOBS
               DKJ = P(I,J)
               IF (ATIQ) THEN
                  Z = DKJ/(DKJ + FACTOR)
                  CALL G01EEF$(Z, DF1, DF2, EPSI, P1, Q, PDF, IFAIL)
                  IF (IFAIL.NE.0) THEN
                     IFAIL = -10
                     RETURN
                  ENDIF
                  ATI(I,J) = P1
               ENDIF
               TEMP = PART1*(ONE + DKJ/FACTOR)**EXP1
               IF (ABS(TEMP).GT.RTOL) THEN
                  P(I,J) = PRJ/TEMP
               ELSE
                  P(I,J) = PRJ
               ENDIF
            ENDDO
         ENDDO
      ENDIF
C
C Normalise the probabilities
C
      DO I = 1, NOBS
         PSUM = ZERO
         DO J = 1, NG
            PSUM = PSUM + P(I,J)
         ENDDO
         IF (PSUM.GT.RTOL) THEN
            DO J = 1, NG
               P(I,J) = P(I,J)/PSUM
            ENDDO
         ENDIF   
      ENDDO
C
C Assign IAG
C
      DO I = 1, NOBS
         IAG(I) = 1
         DO J = 2, NG
            IF (P(I,J).GT.P(I,IAG(I))) IAG(I) = J
         ENDDO
      ENDDO
      END
C
C






