      
C
C
      SUBROUTINE G03EAF$(UPDATE, DIST, SCALE1, N, M, X, LDX, ISX, S, D,
     +                   IFAIL)
C
C ACTION: replacement for G03EAF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 09/06/2001
C         24/05/2008 revised
C         21/06/2008 now allocates space for DENOM with Bray Curtis
C         30/06/2008 removed the 100% with Bray Curtis and added Canberra
C
C         This version also does Bray-Curtis dissimilarity when DIST = 'B'
C         and canberra when DIST = C" with additional IFAIL exits as follows:
C         IFAIL = 3 on exit if called with UPDATE = 'U' and DIST = 'B' 
C         IFAIL = 4 on exit if x(i,j) < 0 with Bray Curtis or Canberra
C         IFAIL = 5 on exit if allocation error
C
C         With canberra, two zero cells do not contribute, but where only one 
C         of the cells in a pair is zero, it has the zero replaced by X_min/5.0
C         There is also a denominator SDENOM
C
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER  N, M, LDX, ISX(M), IFAIL
      DOUBLE PRECISION X(LDX,M), S(M), D((N*(N - 1))/2)
      CHARACTER UPDATE*1, DIST*1, SCALE1*1
C
C Allocatable
C
      DOUBLE PRECISION, ALLOCATABLE :: DENOM(:)      
C
C Locals
C      
      INTEGER  I, IERR, IUPD, ICOUNT, IDIS, ISCA, J, K, LD, NDENOM
      DOUBLE PRECISION DN, DI, DJ, DIJ, DMIN5, DSUM, SDENOM, SUM1, XBAR, 
     +                 XDIFF, XMAX, XMIN
      DOUBLE PRECISION ZERO, ONE, FIVE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, FIVE = 5.0D+00)
      DOUBLE PRECISION DBIG
      PARAMETER (DBIG = 1.0D+300)
      LOGICAL    USEISX
      INTRINSIC  ABS, DBLE, SQRT
C
C Initialise IFAIL
C
      IFAIL = 0
C
C Check UPDATE
C
      IF (UPDATE.EQ.'U' .OR. UPDATE .EQ.'u') THEN
         IUPD = 1
      ELSEIF (UPDATE.EQ.'I' .OR. UPDATE.EQ.'i') THEN
         IUPD = 2
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Check DIST
C
      IF (DIST.EQ.'A' .OR. DIST.EQ.'a') THEN
         IDIS = 1
      ELSEIF (DIST.EQ.'E' .OR. DIST.EQ.'e') THEN
         IDIS = 2
      ELSEIF (DIST.EQ.'S' .OR. DIST.EQ.'s') THEN
         IDIS = 3
      ELSEIF (DIST.EQ.'B' .OR. DIST.EQ.'b') THEN
         IF (IUPD.EQ.1) THEN
            IFAIL = 3
            RETURN
         ELSE   
            IDIS = 4
         ENDIF   
      ELSEIF (DIST.EQ.'C' .OR. DIST.EQ.'c') THEN
         IDIS = 5   
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Check ISCA
C
      IF (SCALE1.EQ.'S' .OR. SCALE1.EQ.'s') THEN
         ISCA = 1
      ELSEIF (SCALE1.EQ.'R' .OR. SCALE1.EQ.'r') THEN
         ISCA = 2
      ELSEIF (SCALE1.EQ.'G' .OR. SCALE1.EQ.'g') THEN
         ISCA = 3
      ELSEIF (SCALE1.EQ.'U' .OR. SCALE1.EQ.'u') THEN
         ISCA = 4
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Check integers
C
      IF (N.LT.2 .OR. LDX.LT.N .OR. M.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C Check ISX and define USEISX
C
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (J.EQ.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
      IF (J.EQ.M) THEN
         USEISX = .FALSE.
      ELSE
         USEISX = .TRUE.
      ENDIF      
C
C Check D
C
      LD = (N*(N - 1))/2
      IF (IUPD.EQ.1) THEN
         DO I = 1, LD
            IF (D(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ELSE
         DO I = 1, LD
            D(I) = ZERO
         ENDDO      
      ENDIF
C
C Check/Calculate S
C
      IF (ISCA.EQ.1) THEN
C
C Standard deviations
C
         DN = DBLE(N)
         DO I = 1, M
            IF (ISX(I).GT.0) THEN
               SUM1 = ZERO
               DO J = 1, N
                  SUM1 = SUM1 + X(J,I)
               ENDDO
               XBAR = SUM1/DN
               SUM1 = ZERO
               DO J = 1, N
                  SUM1 = SUM1 + (X(J,I) - XBAR)**2
               ENDDO
               SUM1 = SQRT(SUM1/(DN - ONE))
               IF (SUM1.GT.ZERO) THEN
                  S(I) = SUM1
               ELSE
                  IFAIL = 2
                  RETURN
               ENDIF
            ENDIF
         ENDDO
      ELSEIF (ISCA.EQ.2) THEN
C
C Range
C
         DO I = 1, M
            IF (ISX(I).GT.0) THEN
               XMAX = X(1,I)
               XMIN = XMAX
               DO J = 2, N
                  IF (X(J,I).GT.XMAX) XMAX = X(J,I)
                  IF (X(J,I).LT.XMIN) XMIN = X(J,I)
               ENDDO
               XDIFF = XMAX - XMIN
               IF (XDIFF.GT.ZERO) THEN
                  S(I) = XDIFF
               ELSE
                  IFAIL = 2
                  RETURN
               ENDIF
            ENDIF
         ENDDO
      ELSEIF (ISCA.EQ.3) THEN
C
C S provided
C
         DO I = 1, M
            IF (ISX(I).GT.0) THEN
               IF (S(I).LE.ZERO) THEN
                  IFAIL = 2
                  RETURN
               ENDIF
            ENDIF
         ENDDO
      ELSE
         DO I = 1, M
            IF (ISX(I).GT.0) S(I) = ONE
         ENDDO
      ENDIF
      
C
C End of checking ... start of calculations so initialise ICOUNT
C      

      ICOUNT = 0
C
C ================================
C Calculate D when ISX is required
C ================================
C
      IF (USEISX) THEN  
         IF (IDIS.EQ.1) THEN
C
C Absolute
C 
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)/S(K)
                           DJ = X(J,K)/S(K)
                           DIJ = DIJ + ABS(DI - DJ)
                        ENDIF
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO
            ELSE 
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DIJ = DIJ + ABS(X(I,K) - X(J,K))
                        ENDIF
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO
            ENDIF       
         ELSEIF (IDIS.EQ.2) THEN
C
C Euclidean
C
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)/S(K)
                           DJ = X(J,K)/S(K)
                           DIJ = DIJ + (DI - DJ)**2
                        ENDIF
                     ENDDO
                    D(ICOUNT) = D(ICOUNT) + SQRT(DIJ)
                  ENDDO
               ENDDO
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DIJ = DIJ + (X(I,K) - X(J,K))**2
                        ENDIF
                     ENDDO
                    D(ICOUNT) = D(ICOUNT) + SQRT(DIJ)
                  ENDDO
               ENDDO   
            ENDIF  
         ELSEIF (IDIS.EQ.3) THEN
C
C Euclidean squared
C
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)/S(K)
                           DJ = X(J,K)/S(K)
                           DIJ = DIJ + (DI - DJ)**2
                        ENDIF
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO 
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DIJ = DIJ + (X(I,K) - X(J,K))**2
                        ENDIF
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO  
            ENDIF    
C
C--------------------------------------------------------------------------
C Note: IDIS = 4 (Bray-Curtis) and 5 (Canberra) are not in the NAG version 
C--------------------------------------------------------------------------
C                 
         ELSEIF (IDIS.EQ.4) THEN
C
C Bray-Curtis dissimilarity
C
            
            DO J = 1, M
               IF (ISX(J).GT.0) THEN
                  DO I = 1, N
                     IF (X(I,J).LT.ZERO) THEN
                        IFAIL = 4
                        RETURN
                     ENDIF   
                  ENDDO  
               ENDIF
            ENDDO  
            IERR = 0
            NDENOM = N
            ALLOCATE (DENOM(NDENOM), STAT = IERR)
            IF (IERR.NE.0) THEN
               IFAIL = 5
               RETURN
            ENDIF       
            IF (ISCA.LT.4) THEN
               DO I = 1, N
                  DENOM(I) = ZERO
                  DO J = 1, M
                     IF (ISX(J).GT.0) THEN
                        DENOM(I) = DENOM(I) + X(I,J)/S(J)
                     ENDIF
                  ENDDO
                  IF (DENOM(I).LE.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF   
               ENDDO            
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)/S(K)
                           DJ = X(J,K)/S(K)
                           DIJ = DIJ + ABS(DI - DJ)
                        ENDIF
                     ENDDO
                     D(ICOUNT) = DIJ/(DENOM(I) + DENOM(J))
                  ENDDO
               ENDDO
            ELSE
               DO I = 1, N
                  DENOM(I) = ZERO
                  DO J = 1, M
                     IF (ISX(J).GT.0) THEN
                        DENOM(I) = DENOM(I) + X(I,J)
                     ENDIF
                  ENDDO
                  IF (DENOM(I).LE.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF   
               ENDDO            
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DIJ = DIJ + ABS(X(I,K) - X(J,K))
                        ENDIF
                     ENDDO
                     D(ICOUNT) = DIJ/(DENOM(I) + DENOM(J))
                  ENDDO
               ENDDO   
            ENDIF 
            DEALLOCATE(DENOM, STAT = IERR)  
        ELSEIF (IDIS.EQ.5) THEN
C
C Canberra dissimilarity
C
            DMIN5 = DBIG
            DO J = 1, M
               IF (ISX(J).GT.0) THEN
                  DO I = 1, N
                     IF (X(I,J).LT.ZERO) THEN
                        IFAIL = 4
                        RETURN
                     ENDIF
                     IF (X(I,J).GT.ZERO .AND.
     +                   X(I,J).LT.DMIN5) DMIN5 = X(I,J)   
                  ENDDO  
               ENDIF
            ENDDO
            DMIN5 = DMIN5/FIVE
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     SDENOM = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)/S(K)
                           DJ = X(J,K)/S(K)
                           IF (DI.GT.ZERO .AND. DJ.GT.ZERO) THEN
                              SDENOM = SDENOM + ONE
                              DSUM = DI + DJ
                              DIJ = DIJ + ABS(DI - DJ)/DSUM
                           ELSEIF (DI.GT.ZERO .AND. DJ.LE.ZERO) THEN  
                              SDENOM = SDENOM + ONE
                              DJ = DMIN5/S(K)
                              DSUM = DI + DJ
                              DIJ = DIJ + ABS(DI - DJ)/DSUM
                           ELSEIF (DI.LE.ZERO .AND. DJ.GT.ZERO) THEN
                              SDENOM = SDENOM + ONE
                              DI = DMIN5/S(K)
                              DSUM = DI + DJ
                              DIJ = DIJ + ABS(DI - DJ)/DSUM
                           ENDIF      
                        ENDIF
                     ENDDO
                     IF (SDENOM.LE.ZERO) THEN
                        IFAIL = 4
                        RETURN
                     ENDIF   
                     D(ICOUNT) = D(ICOUNT) + DIJ/SDENOM
                  ENDDO
               ENDDO
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     SDENOM = ZERO
                     DO K = 1, M
                        IF (ISX(K).GT.0) THEN
                           DI = X(I,K)
                           DJ = X(J,K)
                           IF (DI.GT.ZERO .AND. DJ.GT.ZERO) THEN
                              SDENOM = SDENOM + ONE
                              DSUM = DI + DJ
                              DIJ = DIJ + ABS(DI - DJ)/DSUM
                           ELSEIF (DI.GT.ZERO .AND. DJ.LE.ZERO) THEN
                              SDENOM = SDENOM + ONE
                              DSUM = DI + DMIN5
                              DIJ = DIJ + ABS(DI - DMIN5)/DSUM
                           ELSEIF (DI.LE.ZERO .AND. DJ.GT.ZERO) THEN
                              SDENOM = SDENOM + ONE
                              DSUM = DMIN5 + DJ
                              DIJ = DIJ + ABS(DMIN5 - DJ)/DSUM
                           ENDIF      
                        ENDIF
                     ENDDO
                     IF (SDENOM.LE.ZERO) THEN
                        IFAIL = 4
                        RETURN
                     ENDIF   
                     D(ICOUNT) = D(ICOUNT) + DIJ/SDENOM
                  ENDDO
               ENDDO   
            ENDIF 
         ENDIF            
      ELSE
C
C =====================================
C Calculate D when ISX is NOT required
C =====================================
C        
         IF (IDIS.EQ.1) THEN
C
C Absolute
C 
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DI = X(I,K)/S(K)
                        DJ = X(J,K)/S(K)
                        DIJ = DIJ + ABS(DI - DJ)
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO
            ELSE 
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DIJ = DIJ + ABS(X(I,K) - X(J,K))
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO
            ENDIF       
         ELSEIF (IDIS.EQ.2) THEN
C
C Euclidean
C
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DI = X(I,K)/S(K)
                        DJ = X(J,K)/S(K)
                        DIJ = DIJ + (DI - DJ)**2
                     ENDDO
                    D(ICOUNT) = D(ICOUNT) + SQRT(DIJ)
                  ENDDO
               ENDDO
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DIJ = DIJ + (X(I,K) - X(J,K))**2
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + SQRT(DIJ)
                  ENDDO
               ENDDO   
            ENDIF  
         ELSEIF (IDIS.EQ.3) THEN
C
C Euclidean squared
C
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DI = X(I,K)/S(K)
                        DJ = X(J,K)/S(K)
                        DIJ = DIJ + (DI - DJ)**2
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO 
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DIJ = DIJ + (X(I,K) - X(J,K))**2
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ
                  ENDDO
               ENDDO  
            ENDIF         
C
C--------------------------------------------------------------------------
C Note: IDIS = 4 (Bray-Curtis) and 5 (Canberra) are not in the NAG version 
C--------------------------------------------------------------------------
C            
         ELSEIF (IDIS.EQ.4) THEN
C
C Bray-Curtis dissimilarity
C
            DO J = 1, M
               DO I = 1, N
                  IF (X(I,J).LT.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF   
               ENDDO  
            ENDDO 
            IERR = 0
            NDENOM = N
            ALLOCATE (DENOM(NDENOM), STAT = IERR)
            IF (IERR.NE.0) THEN
               IFAIL = 5
               RETURN
            ENDIF            
            IF (ISCA.LT.4) THEN
               DO I = 1, N
                  DENOM(I) = ZERO
                  DO J = 1, M
                     DENOM(I) = DENOM(I) + X(I,J)/S(J)
                  ENDDO
                  IF (DENOM(I).LE.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF   
               ENDDO   
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DI = X(I,K)/S(K)
                        DJ = X(J,K)/S(K)
                        DIJ = DIJ + ABS(DI - DJ)
                     ENDDO
                     D(ICOUNT) = DIJ/(DENOM(I) + DENOM(J))
                  ENDDO
               ENDDO
            ELSE
               DO I = 1, N
                  DENOM(I) = ZERO
                  DO J = 1, M
                     DENOM(I) = DENOM(I) + X(I,J)
                  ENDDO
                  IF (DENOM(I).LE.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF   
               ENDDO   
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     DO K = 1, M
                        DIJ = DIJ + ABS(X(I,K) - X(J,K))
                     ENDDO
                     D(ICOUNT) = DIJ/(DENOM(I) + DENOM(J))
                  ENDDO
               ENDDO   
            ENDIF   
            DEALLOCATE(DENOM, STAT = IERR)
         ELSEIF (IDIS.EQ.5) THEN
C
C Canberra dissimilarity
C
            DMIN5 = DBIG        
            DO J = 1, M
               DO I = 1, N
                  IF (X(I,J).LT.ZERO) THEN
                     IFAIL = 4
                     RETURN
                  ENDIF 
                  IF (X(I,J).GT.ZERO .AND.
     +                X(I,J).LT.DMIN5) DMIN5 = X(I,J)                       
               ENDDO  
            ENDDO
            DMIN5 = DMIN5/FIVE 
            IF (ISCA.LT.4) THEN
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     SDENOM = ZERO
                     DO K = 1, M
                         DI = X(I,K)/S(K)
                         DJ = X(J,K)/S(K)
                         IF (DI.GT.ZERO .AND. DJ.GT.ZERO) THEN
                            SDENOM = SDENOM + ONE
                            DSUM = DI + DJ
                            DIJ = DIJ + ABS(DI - DJ)/DSUM
                         ELSEIF (DI.GT.ZERO .AND. DJ.LE.ZERO) THEN  
                            SDENOM = SDENOM + ONE
                            DJ = DMIN5/S(K)
                            DSUM = DI + DJ
                            DIJ = DIJ + ABS(DI - DJ)/DSUM
                         ELSEIF (DI.LE.ZERO .AND. DJ.GT.ZERO) THEN
                            SDENOM = SDENOM + ONE
                            DI = DMIN5/S(K)
                            DSUM = DI + DJ
                            DIJ = DIJ + ABS(DI - DJ)/DSUM
                         ENDIF      
                     ENDDO
                     D(ICOUNT) = D(ICOUNT) + DIJ/SDENOM
                  ENDDO
               ENDDO
            ELSE
               DO I = 2, N
                  DO J = 1, I - 1
                     ICOUNT = ICOUNT + 1
                     DIJ = ZERO
                     SDENOM = ZERO
                     DO K = 1, M
                        DI = X(I,K)
                        DJ = X(J,K)
                        IF (DI.GT.ZERO .AND. DJ.GT.ZERO) THEN
                           SDENOM = SDENOM + ONE
                           DSUM = DI + DJ
                           DIJ = DIJ + ABS(DI - DJ)/DSUM
                        ELSEIF (DI.GT.ZERO .AND. DJ.LE.ZERO) THEN  
                           SDENOM = SDENOM + ONE
                           DSUM = DI + DMIN5
                           DIJ = DIJ + ABS(DI - DMIN5)/DSUM
                        ELSEIF (DI.LE.ZERO .AND. DJ.GT.ZERO) THEN
                           SDENOM = SDENOM + ONE
                           DSUM = DMIN5 + DJ
                           DIJ = DIJ + ABS(DMIN5 - DJ)/DSUM
                        ENDIF      
                     ENDDO
                     IF (SDENOM.LE.ZERO) THEN
                        IFAIL = 4
                        RETURN
                     ENDIF    
                     D(ICOUNT) = D(ICOUNT) + DIJ/SDENOM
                  ENDDO
               ENDDO   
            ENDIF   
         ENDIF
      ENDIF      
      END
C
C
 