C
C ============================================================
C Code for G03ECF$  ...  also contains subroutine G03ORD
C ============================================================
C
      SUBROUTINE G03ECF$(METHOD, N, D, ILC, IUC, CD, IORD, DORD,
     +                   IWK, IFAIL)
C
C ACTION: Version of G03ECF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 15/07/2001
C         25/05/2008 revised to speed up calculations by altering
C                    some logical tests and placing G03IJK in-line 
C         22/06/2008 further speed up, by making G03NUD in-line
C
C         IWK is first used to store cardinalities, then it is
C         partitioned for use in block rolling but finally
C         this version returns the merge order in IWK
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    METHOD, N, ILC(N - 1), IUC(N - 1), IORD(N), IWK(2*N),
     +           IFAIL
      DOUBLE PRECISION D((N*(N - 1))/2), CD(N - 1), DORD(N)
C
C Locals
C      
      INTEGER    I, ICOUNT, ISAV, ITEMP, J, JSAV, JTEMP, K, ND
      INTEGER    II, JJ, KK, LL, NI, NJ, NK
      DOUBLE PRECISION DIJ, DIJK, DIK, DJK, DNI, DNJ, DNJK, DNJK2, DNK
      DOUBLE PRECISION DMIN, DTEMP
      DOUBLE PRECISION DMAX, ZERO, HALF
      PARAMETER (DMAX = 1.0D+300, HALF = 0.5D+00, ZERO = 0.0D+00)
      EXTERNAL   G03ORD
      INTRINSIC  MAX, MIN
      
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LT.2 .OR. METHOD.LT.1 .OR. METHOD.GT.6) THEN
         IFAIL = 1
         RETURN
      ENDIF
      ND = (N*(N - 1))/2
      DO I = 1, ND
         IF (D(I).LT.ZERO) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO
C
C Initialise and set the number of elements in each group = 1
C
      DO I = 1, N
         IWK(I) = 1
         IORD(I) = 0
         DORD(I) = ZERO
      ENDDO
      DO I = 1, N - 1
         ILC(I) = 0
         IUC(I) = 0
         CD(I) = ZERO
      ENDDO
      
C
C Start of main loop: Go through all legal D(K) iteratively to find the minimum
C ===================
C

      ICOUNT = 1
      DO WHILE (ICOUNT.LT.N)
         
         DMIN = DMAX
         
         K = 0
              
c
c Start of subsidary loop 1: find the legal minimum
C --------------------------
c    
         DO I = 2, N
           
            IF (IWK(I).GT.0) THEN
              
               DO J = 1, I - 1
                 
                  K = K + 1
                  
                  IF (IWK(J).GT.0) THEN
C
C Only calculate if I and J are both legal (IWK(I) > 0, IWK(J) > 0)
C
                     IF (D(K).LE.DMIN) THEN
C
C DMIN is smaller so save
C
                        DMIN = D(K)
                        ISAV = I
                        JSAV = J
C                     ELSEIF (ABS(D(K) - DMIN).LE.EPSI) THEN
C
C DMIN equals the previous DMIN so we may need to redefine ISAV and JSAV
C
C                        IF (ISAV.LT.I .OR.
C     +                     (ISAV.EQ.I .AND. JSAV.LT.J)) THEN
C                           ISAV = I
C                           JSAV = J
C                        ENDIF
                     ENDIF
                  ENDIF
                  
               ENDDO
               
            ELSE
              
               K = K + I - 1
               
            ENDIF
            
         ENDDO
         
C
C End of subsidiary loop 1: Save details for the two that have now merged
C -------------------------
C

         ITEMP = MIN(ISAV, JSAV)
         JTEMP = MAX(ISAV, JSAV)
         DTEMP = DMIN
         ILC(ICOUNT) = ITEMP
         IUC(ICOUNT) = JTEMP
         CD(ICOUNT) = DMIN
C
C Check for non-decreasing CD
C
         IF (ICOUNT.GT.1) THEN
            IF (CD(ICOUNT).LT.CD(ICOUNT - 1)) THEN
               IFAIL = 3
               RETURN
            ENDIF
         ENDIF
C
C If we are not finished then refresh the legal parts of the D vector
C
         ICOUNT = ICOUNT + 1
         
         IF (ICOUNT.LT.N) THEN
C
C Define J, K, D(J,K) and associated counters J < K
C
             J = ITEMP
             K = JTEMP
             NJ = IWK(J)
             NK = IWK(K)
             DNJ = DBLE(NJ)
             DNK = DBLE(NK)
             DNJK = DNJ + DNK
             DNJK2 = DNJK**2
             DJK = DTEMP
       
C
C Start of subsidiary loop 2: Go through the legal parts of the matrix and redefine D values
C ---------------------------
C
             
             IF (J.GT.1) THEN
                II = J
                DO JJ = 1, II - 1
C
C Refresh all the row indexed by J
C
                   I = JJ
C
C Do not include cancelled items, etc.
C
                   IF (IWK(I).EQ.0 .OR. I.EQ.J .OR. I.EQ.K) I = 0
                   IF (I.GT.0) THEN
C
C Define KK then DIK and NI
C
                      IF (I.GT.K) THEN
                         IF (I.EQ.2) THEN
                            KK = 1
                         ELSEIF (I.EQ.3) THEN
                            KK = K + 1
                         ELSE
                            KK = (I - 2)*(I - 1)/2 + K
                         ENDIF      
                      ELSE
                         IF (K.EQ.2) THEN
                            KK = 1
                         ELSEIF (K.EQ.3) THEN
                            KK = I + 1
                         ELSE
                            KK = (K - 2)*(K - 1)/2 + I
                         ENDIF            
                      ENDIF
                      DIK = D(KK)
                      NI = IWK(I)
C
C Define LL then DIJ
C
                      IF (I.GT.J) THEN
                         IF (I.EQ.2) THEN
                            LL = 1
                         ELSEIF (I.EQ.3) THEN
                            LL = J + 1
                         ELSE
                            LL = (I - 2)*(I - 1)/2 + J
                         ENDIF            
                      ELSE
                         IF (J.EQ.2) THEN
                            LL = 1
                         ELSEIF (J.EQ.3) THEN
                            LL = I + 1
                         ELSE
                            LL = (J - 2)*(J - 1)/2 + I
                         ENDIF            
                      ENDIF
                      DIJ = D(LL)
C
C Calculate the new distances
C
                      IF (METHOD.EQ.1) THEN
                         DIJK = MIN(DIJ, DIK)
                      ELSEIF (METHOD.EQ.2) THEN
                         DIJK = MAX(DIJ, DIK)
                      ELSEIF (METHOD.EQ.3) THEN
                         DIJK = (DNJ*DIJ + DNK*DIK)/DNJK
                      ELSEIF (METHOD.EQ.4) THEN
                         DIJK = (DNJ*DIJ + DNK*DIK)/DNJK -
     +                           DNJ*DNK*DJK/DNJK2
                      ELSEIF (METHOD.EQ.5) THEN
                         DIJK = HALF*(DIJ + DIK - HALF*DJK)
                      ELSEIF (METHOD.EQ.6) THEN
                         DNI = DBLE(NI)
                         DIJK = ((DNI + DNJ)*DIJ + (DNI + DNK)*DIK -
     +                            DNI*DJK)/(DNI + DNJK)
                      ENDIF
C
C Overwrite the original value DIJ using DIJK as just calculated
C
                      D(LL) = DIJK
                   ENDIF
               ENDDO
            ENDIF   

C
C End of subsidiary loop 2...start of subsidiary loop 3
C ------------------------------------------------------
C

            JJ = J
               DO II = J + 1, N
C
C Refresh all the column indexed by J
C
                   I = II
C
C Do not include cancelled items, etc.
C
                   
                   IF (IWK(I).EQ.0 .OR. I.EQ.J .OR. I.EQ.K .OR. 
     +                 II.EQ.J) I = 0
                   IF (I.GT.0) THEN
C
C Define KK then DIK and NI
C
                      IF (I.GT.K) THEN
                         IF (I.EQ.2) THEN
                            KK = 1
                         ELSEIF (I.EQ.3) THEN
                            KK = K + 1
                         ELSE
                            KK = (I - 2)*(I - 1)/2 + K
                         ENDIF      
                      ELSE
                         IF (K.EQ.2) THEN
                            KK = 1
                         ELSEIF (K.EQ.3) THEN
                            KK = I + 1
                         ELSE
                            KK = (K - 2)*(K - 1)/2 + I
                         ENDIF            
                      ENDIF
                      DIK = D(KK)
                      NI = IWK(I)
C
C Define LL then DIJ
C
                      IF (I.GT.J) THEN
                         IF (I.EQ.2) THEN
                            LL = 1
                         ELSEIF (I.EQ.3) THEN
                            LL = J + 1
                         ELSE
                            LL = (I - 2)*(I - 1)/2 + J
                         ENDIF            
                      ELSE
                         IF (J.EQ.2) THEN
                            LL = 1
                         ELSEIF (J.EQ.3) THEN
                            LL = I + 1
                         ELSE
                            LL = (J - 2)*(J - 1)/2 + I
                         ENDIF            
                      ENDIF
                      DIJ = D(LL)
C
C Calculate the new distances
C
                      IF (METHOD.EQ.1) THEN
                         DIJK = MIN(DIJ, DIK)
                      ELSEIF (METHOD.EQ.2) THEN
                         DIJK = MAX(DIJ, DIK)
                      ELSEIF (METHOD.EQ.3) THEN
                         DIJK = (DNJ*DIJ + DNK*DIK)/DNJK
                      ELSEIF (METHOD.EQ.4) THEN
                         DIJK = (DNJ*DIJ + DNK*DIK)/DNJK -
     +                           DNJ*DNK*DJK/DNJK2
                      ELSEIF (METHOD.EQ.5) THEN
                         DIJK = HALF*(DIJ + DIK - HALF*DJK)
                      ELSEIF (METHOD.EQ.6) THEN
                         DNI = DBLE(NI)
                         DIJK = ((DNI + DNJ)*DIJ + (DNI + DNK)*DIK -
     +                            DNI*DJK)/(DNI + DNJK)
                      ENDIF
C
C Overwrite the original value DIJ using DIJK as just calculated
C
                      D(LL) = DIJK
                   ENDIF
               ENDDO

C
C End of subsidiary loop 3
C ------------------------ 
C
               
C
C Adjust the cardinalties after the merge by setting IWK(K) = 0
C to remove K from any further calculations but adding NK to NJ
C
             IWK(J) = NJ + NK
             IWK(K) = 0        
          ENDIF
     
      ENDDO
C
C End of main loop: Finally generate IORD and DORD and fill in IWK
C =================
C
         
      CALL G03ORD (ILC, IUC, IORD, IWK(1), IWK(N + 1), N,
     +             CD, DORD)
     
      END
     
C
C -------------------------------------------------------------------
C
      SUBROUTINE G03ORD (ILC, IUC, IORD, IWK, JWK, N,
     +                   CD, DORD)
C
C ACTION: order output for G03ECF$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 16/07/2001
C         22/06/2008 added INTENTS  
C
      IMPLICIT  NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (IN)    :: ILC(N - 1), IUC(N - 1) 
      INTEGER,          INTENT (OUT)   :: IORD(N), IWK(N), JWK(N)
      DOUBLE PRECISION, INTENT (IN)    :: CD(N - 1)
      DOUBLE PRECISION, INTENT (INOUT) :: DORD(N)
C
C Locals
C      
      INTEGER   I, J, K
      INTEGER   ICOUNT, ITEMP, NJ1, NJ2, NK1, NK2
      LOGICAL   JFOUND, KFOUND
      INTRINSIC MAX, MIN
C
C Initialise
C
      DO I = 1, N
         IORD(I) = I
         IWK(I) = I
         JWK(I) = I
      ENDDO
      ICOUNT = 1
      DO WHILE (ICOUNT.LT.N)
C
C Define J and K (J < K) for merger at step ICOUNT
C
         J = MIN(ILC(ICOUNT), IUC(ICOUNT))
         K = MAX(ILC(ICOUNT), IUC(ICOUNT))
         NJ1 = 0
         NJ2 = 0
         NK1 = 0
         NK2 = 0
         DO I = 1, N
C
C Find where the current J's start and stop, i.e. NJ1 and NJ2
C
            IF (NJ1.EQ.0) THEN
               IF (IWK(I).EQ.J) NJ1 = I
            ENDIF
            IF (IWK(I).EQ.J) NJ2 = I
C
C Find where the current K's start and stop, i.e. NK1 and NK2
C
            IF (NK1.EQ.0) THEN
               IF (IWK(I).EQ.K) NK1 = I
            ENDIF
            IF (IWK(I).EQ.K) NK2 = I
         ENDDO
C
C Copy the block to be moved in IORD into JWK
C
         DO I = NK1, NK2
            JWK(I) = IORD(I)
         ENDDO
C
C Roll the IORD array
C
         ITEMP = NK2 - NK1 + 1
         DO I = NK2, NJ2 + ITEMP, -1
            IORD(I) = IORD(I - ITEMP)
         ENDDO
C
C Re-introduce the stored block
C
         ITEMP = NJ2
         DO I = NK1, NK2
            ITEMP = ITEMP + 1
            IORD(ITEMP) = JWK(I)
         ENDDO
C
C Roll the IWK array
C
         ITEMP = NK2 - NK1 + 1
         DO I = NK2, NJ2 + ITEMP, - 1
            IWK(I) = IWK(I - ITEMP)
         ENDDO
C
C Re-label the K's as J's
C
         ITEMP = NJ2
         DO I = NK1, NK2
            ITEMP = ITEMP + 1
            IWK(ITEMP) = J
         ENDDO
         ICOUNT = ICOUNT + 1
      ENDDO
C
C Re-order the distances
C
      DO ICOUNT = 1, N - 1
         J = IORD(ICOUNT)
         K = IORD(ICOUNT + 1)
         JFOUND = .FALSE.
         KFOUND = .FALSE.
         I = 1
         DO WHILE (I.LT.N .AND. (.NOT.JFOUND .OR. .NOT.KFOUND))
            IF (IUC(I).EQ.J) J = ILC(I)
            IF (IUC(I).EQ.K) K = ILC(I)
            JFOUND = .FALSE.
            KFOUND = .FALSE.
            IF (ILC(I).EQ.J .OR. IUC(I).EQ.J) JFOUND = .TRUE.
            IF (ILC(I).EQ.K .OR. IUC(I).EQ.K) KFOUND = .TRUE.
            IF (JFOUND .AND. KFOUND) THEN
               DORD(ICOUNT) = CD(I)
               IWK(ICOUNT) = I
            ENDIF
            I = I + 1
         ENDDO
      ENDDO
      IWK(N) = N
      DORD(N) = CD(1)
      DO I = 2, N - 1
         IF (CD(I).GT.DORD(N)) DORD(N) = CD(I)
      ENDDO
      END
C
c