C
C
      SUBROUTINE G03EFF$(WEIGHT, N, M, X, LDX, ISX, NVAR, K, CMEANS,
     +                   LDC, WT, INC, NIC, CSS, CSW, MAXIT, IWK,
     +                   WK, IFAIL)
C
C ACTION: replacement for G03EFF
C AUTHOR: W.G.Bardsley, University of manchester, U.K, 18/10/2002
C         15/01/2006 introduced allocatable arrays
C         05/02/2010 corrected error trying to load CSW with nonzero ifail
C                    and also dealt with the special case N = K as NAG does
C                    Note that APS136 and APS136$ simply return IFAULT = 3 
C                    with no calculations when N = K and also return 
C                    IFAULT = 3 on successful exit
C
      IMPLICIT   NONE
      INTEGER    N, M, LDX, ISX(M), NVAR, K, LDC, INC(N), NIC(K),
     +           MAXIT, IWK(N + 3*K), IFAIL
      DOUBLE PRECISION X(LDX,M), CMEANS(LDC,NVAR), WT(*), CSS(K),
     +                 CSW(K), WK(N + 2*K)
      CHARACTER  WEIGHT*1
C
C Local variables including array A to transfer data and weights to APS136
C
      INTEGER    I, IAN1, IAN2, ICOUNT, IERR, ID, IFSAV, J, K1, K2, K3,
     +           K4, L
      INTEGER    NCMAX, NRMAX
      INTEGER    IFAULT, ITER, KMAX, NPTS
      DOUBLE PRECISION, ALLOCATABLE :: A(:,:)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  WTCOPY*1
      EXTERNAL   APS136, APS136$
      INTRINSIC  NINT, DBLE
C
C Is it safe ?
C
      IFAIL = 0
      IF (WEIGHT.EQ.'w' .OR. WEIGHT.EQ.'W') THEN
         WTCOPY = 'W'
      ELSEIF (WEIGHT.EQ.'u' .OR. WEIGHT.EQ.'U') THEN
         WTCOPY = 'U'
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      IF (N.LT.2 .OR. NVAR.LT.1 .OR. M.LT.NVAR .OR. K.LT.2 .OR.
     +    LDX.LT.N .OR. LDC.LT.K .OR. MAXIT.LE.0) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (WTCOPY.EQ.'W') THEN
         ICOUNT = 0
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ELSEIF (WT(I).GT.ZERO) THEN
               ICOUNT = ICOUNT + 1
            ENDIF
         ENDDO
         IF (ICOUNT.LE.1) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDIF
      ICOUNT = 0
      DO I = 1, M
         IF (ISX(I).GT.0) ICOUNT = ICOUNT + 1
      ENDDO
      IF (ICOUNT.NE.NVAR) THEN
         IFAIL = 3
         RETURN
      ENDIF
      IF (K.GT.N) THEN
         IFAIL = 4
         RETURN
      ENDIF  
C
C The special case N = K
C  
      IF (N.EQ.K) THEN
         DO J = 1, M
            DO I = 1, N
               CMEANS(I,J) = X(I,J)
            ENDDO  
         ENDDO    
         DO I = 1, K
            INC(I) = I
            NIC(I) = 1
            CSS(I) = ZERO
            CSW(I) = ONE
         ENDDO
         RETURN
      ENDIF   
C
C Allocate workspace
C                   
      IERR = 0
      IFSAV = IFAIL
      IFAIL = 10   
      NCMAX = M + 1
      NRMAX = N + 1
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(A(NRMAX,NCMAX), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
C
C Make a copy of the data putting weights in last column if weighted
C
      IF (WTCOPY.EQ.'U') THEN
         NPTS = N
         DO I = 1, NPTS
            L = 0
            DO J = 1, M
               IF (ISX(J).GT.0) THEN
                  L = L + 1
                  A(I,L) = X(I,J)
               ENDIF
            ENDDO
         ENDDO
      ELSE
         NPTS = 0
         DO I = 1, N
            IF (WT(I).GT.ZERO) THEN
               NPTS = NPTS + 1
               L = 0
               DO J = 1, M
                  IF (ISX(J).GT.0) THEN
                     L = L + 1
                     A(NPTS,L) = X(I,J)
                  ENDIF
               ENDDO
               L = L + 1
               A(NPTS,L) = WT(I)
            ENDIF
         ENDDO
      ENDIF
C
C Initialise
C
      DO I = 1, K
         NIC(I) = 0
         CSS(I) = ZERO
         CSW(I) = ZERO
      ENDDO
      DO I = 1, N
         INC(I) = 0
      ENDDO
C
C Starting positions for workspaces
C
      IAN1 = 1
      IAN2 = IAN1 + K
      ID = IAN2 + K
      K1 = 1
      K2 = K1 + NPTS
      K3 = K2 + K
      K4 = K3 + K
C
C Adjust ITER if necessary
C
      ITER = MAXIT
      IF (ITER.LT.2) THEN
         ITER = 2
      ELSEIF (ITER.GT.100) THEN
         ITER = 100
      ENDIF
      KMAX = LDC
C
C Call the AS 136 routines but note the extra arguments LDC and NRMAX and
C extra argument CSW when using weights and calling the weighted AS 136
C
      IF (WTCOPY.EQ.'U') THEN
         CALL APS136 (KMAX, NRMAX, A, NPTS, NVAR, CMEANS, K, INC,
     +                IWK(K1), NIC, WK(IAN1), WK(IAN2), IWK(K2), WK(ID),
     +                IWK(K3), IWK(K4), ITER, CSS, IFAULT)
      ELSE
         CALL APS136$(KMAX, NRMAX, CSW, A, NPTS, NVAR, CMEANS, K, INC,
     +                IWK(K1), NIC, WK(IAN1), WK(IAN2), IWK(K2), WK(ID),
     +                IWK(K3), IWK(K4), ITER, CSS, IFAULT)
      ENDIF
C
C Check IFAULT
C
      IF (IFAULT.EQ.1) THEN
         IFAIL = 4
      ELSEIF (IFAULT.EQ.2) THEN
         IFAIL = 5
      ELSE
         IFAIL = 0
      ENDIF
      IF (IFAIL.EQ.0) THEN
         IF (WTCOPY.EQ.'W') THEN
C
C Re-adjust INC if weighted
C
            NPTS = 0
            DO I = 1, N
               IF (WT(I).GT.ZERO) THEN
                  NPTS = NPTS + 1
                  A(I,1) = DBLE(INC(NPTS))
               ELSE
                  A(I,1) = ZERO
               ENDIF
            ENDDO
            DO I = 1, N
               INC(I) = NINT(A(I,1))
            ENDDO
         ELSE
C
C Calculate CSW If unweighted
C
            DO I = 1, N
               CSW(INC(I)) = CSW(INC(I)) + ONE
            ENDDO
         ENDIF               
      ENDIF   
C
C Deallocate workspace
C                     
      DEALLOCATE(A, STAT = IERR)
      END
C
C
