C
C
      SUBROUTINE G03EJF$(N, CD, IORD, DORD, K, DLEVEL, IC, IFAIL)
C
C ACTION: Replacement for G03EJF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 04/01/2005
C         22/06/2008 simplified the test for DORD to "out of range"
C                    instead of every element represented in CD   
C
      IMPLICIT NONE
C
C Arguments
C          
      INTEGER N, IORD(N), K, IC(N), IFAIL
      DOUBLE PRECISION CD(N - 1), DORD(N), DLEVEL
C
C Locals
C               
      INTEGER    I, ICOUNT, INOW 
      DOUBLE PRECISION D1, D2 
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-06, ONE = 1.0D+00)  
C
C Is it safe ?
C                        
      IFAIL = 0
      IF (K.GT.N .OR. N.LT.2) THEN
         IFAIL = 1
         RETURN
      ENDIF   
      IF (K.LE.0) THEN 
         IF (DLEVEL.LE.ZERO) THEN
            IFAIL = 1
            RETURN
         ENDIF  
         IF (DLEVEL.GE.CD(N - 1) .OR. DLEVEL.LT.CD(1)) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDIF
      DO I = 1, N - 2          
         IF (CD(I).GT.CD(I + 1)) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO  
      IF (K.EQ.1 .OR. K.EQ.N) THEN
         IFAIL = 3
         RETURN
      ENDIF            
      D1 = (ONE - EPSI)*CD(1)
      D2 = (ONE + EPSI)*CD(N - 1)
      DO I = 1, N
         IF (DORD(I).LT.D1 .OR. DORD(I).GT.D2) THEN
            IFAIL = 2
            RETURN
         ENDIF  
      ENDDO  
C
C Define D2 depending on K and DLEVEL
C            
      IF (K.GT.0) THEN
         D2 = CD(N - K)
      ELSE
         D2 = DLEVEL
      ENDIF
C
C Initialise ICOUNT or K then calculate IC assuming that each distance that
C exceeds the threshold D2 will mark the end of a grouping as follows:-
C IORD = the order of cases in the dendrogram 
C DORD = the respective distances in coalescing
C IC = the indexed group returned corresponding to IORD
C      
      IF (K.GT.0) THEN
         ICOUNT = 1    
         DO I = 1, N   
            INOW = IORD(I) 
            D1 = DORD(I)  
            IC(INOW) = ICOUNT
            IF (I.LT.N .AND. ICOUNT.LT.K) THEN
C
C Check all data except the last point or until K groups have been formed
C            
              IF (D1.GT.D2) ICOUNT = ICOUNT + 1
            ENDIF 
         ENDDO    
         IF (ICOUNT.LT.K) THEN
            K = ICOUNT
            IFAIL = 4
         ENDIF
      ELSE  
         K = 1    
         DO I = 1, N   
            INOW = IORD(I) 
            D1 = DORD(I)  
            IC(INOW) = K
C
C Check all data except the last point
C             
            IF (I.LT.N .AND. D1.GT.D2) K = K + 1
         ENDDO           
      ENDIF   
      END
C
C              
      