C
C Simfit substitute for NAG routine G03FAF$
C 
C This is a preliminary version of G03FAF$ which does not exploit the symmetry
C of the various matrices or use the integer workspace provided by the NAG
C arguments, presumably put there to use for minimising storage space. It will
C eventually be replaced by a better version using the SVD method.
C
C Note that the eigenvalues are divided by the trace of E, but this is probably
C the wrong thing to do if there are negative eigenvalues. Similarly, scaling
C the eigenvectors by sqrt(abs(eval(i)) is questionable.
C
C w.g.b 27/10/2009
C
      SUBROUTINE G03FAF$(ROOTS, N, D, NDIM, X, LDX, EVAL, WK, IWK, 
     +                   IFAIL)
      IMPLICIT NONE
C
C Arguments
C      
      INTEGER  N, NDIM, LDX, IWK(5*N), IFAIL
      DOUBLE PRECISION D(N*(N - 1)/2), X(LDX,NDIM), EVAL(N),
     +                 WK(N*(N + 17)/2 - 1)
      CHARACTER*1 ROOTS
C
C Locals
C      
      INTEGER    I, ICOUNT, IERR, INFO, J, LWORK, NCOL, NRMAX, NROW
      DOUBLE PRECISION DN, GMEAN
      DOUBLE PRECISION, ALLOCATABLE :: E(:,:)
      DOUBLE PRECISION FACTOR, ZERO
      PARAMETER (FACTOR = -0.5D+00, ZERO = 0.0D+00)
      CHARACTER  JOB*1, UPLO*1
      PARAMETER (JOB = 'V', UPLO = 'L')
      EXTERNAL   DSYEV
      INTRINSIC  ABS, DBLE
C
C Set IFAIL = 0 then check parameters supplied
C      
      IFAIL = 0
      IF (NDIM.LT.1 .OR. N.LT.NDIM .OR. LDX.LT.N) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (ROOTS.NE.'A' .AND. ROOTS.NE.'a' .AND.
     +    ROOTS.NE.'L' .AND. ROOTS.NE.'l') THEN
         IFAIL = 1
         RETURN
      ENDIF  
      DO I = 1, N*(N - 1)/2
         IF (D(I).LT.ZERO) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO              
C
C Allocate E
C      
      NCOL = N
      NROW = N
      NRMAX = N
      DN = DBLE(N)
      IERR = 0
      IF (ALLOCATED(E)) DEALLOCATE(E, STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 5
         RETURN
      ENDIF
      ALLOCATE (E(NRMAX,NRMAX), STAT = IERR)
      IF (IERR.NE.0) THEN
         IFAIL = 6
         RETURN
      ENDIF
C
C Fill E completely with squared distances
C      
      ICOUNT = 0
      DO I = 1, NROW
         DO J = 1, I
            IF (I.EQ.J) THEN
               E(I,J) = ZERO
            ELSE
               ICOUNT = ICOUNT + 1
               E(I,J) = D(ICOUNT)*D(ICOUNT)
               E(J,I) = E(I,J)
            ENDIF      
         ENDDO  
      ENDDO 
C
C Calculate the column means and the global mean
C
      GMEAN = ZERO
      DO J = 1, NCOL
         WK(J) = ZERO
         DO I = 1, NROW
            WK(J) = WK(J) + E(I,J) 
         ENDDO
         WK(J) = WK(J)/DN   
         GMEAN = GMEAN + WK(J)
      ENDDO 
C
C Correct the global mean
C       
      GMEAN = GMEAN/DN
C
C Calculate the row means
C
      DO I = 1, NROW
         EVAL(I) = ZERO
         DO J = 1, NCOL
            EVAL(I) = EVAL(I) + E(I,J) 
         ENDDO
         EVAL(I) = EVAL(I)/DN   
      ENDDO 
C
C Adjust the lower triangle of E before calling DSYEV
C     
      DO I = 1, NROW
         DO J = 1, I
            E(I,J) = FACTOR*(E(I,J) - EVAL(I) - WK(J) + GMEAN)
         ENDDO   
      ENDDO      
C
C Find the eigenvalues and eigenvectors
C          
      LWORK = N*(N + 17)/2 - 1
      CALL DSYEV (JOB, UPLO, NROW, E, NRMAX, EVAL, WK, LWORK, INFO)
C
C Return the INFO value in IWK(1) for diagnostic purposes then check
C      
      IWK(1) = INFO
      IF (INFO.NE.0) THEN
         IFAIL = 4
         DEALLOCATE(E, STAT = IERR)
         RETURN
      ENDIF  
C
C Rearrange the eigenvalues into increasing order 
C      
      DO I = 1, N
         WK(I) = EVAL(I)
      ENDDO
      DO I = 1, N
         EVAL(I) = WK(N - I + 1)
      ENDDO       
C
C Return the re-ordered and scaled eigenvectors 
C          
      DO J = 1, NDIM
         GMEAN = SQRT(ABS(EVAL(J)))
         DO I = 1, NROW
            X(I,J) = GMEAN*E(I,N - J + 1)
         ENDDO  
      ENDDO  
C
C Scale the eigenvalues
C      
      GMEAN = ZERO
      DO I = 1, N
         GMEAN = GMEAN + EVAL(I)
      ENDDO
      DO I = 1, N
         EVAL(I) = EVAL(I)/GMEAN
      ENDDO  
C
C Deallocate the work space
C      
      DEALLOCATE(E, STAT = IERR)
      END
C
C      
        