


C
C Simfit version of G03FCF: w.g.bardsley, university of manchester, u.k., 01/04/2013
C 
C This version is developed from the Kruskal MDSCAL5 code not KYST2A so IOPT is not used. 
C Also, as this code does not return the actual (hat) fit it has to be calculated and also 
C the (tilde) fit is only returned in order of the original distance matrix. So the last 
C segment of DFIT is filled with a dummy value. 
C
cftn95$options(silent)
      SUBROUTINE G03FCF$(TYPE1, N, NDIM, D, X, LDX, STRESS, DFIT, ITER,
     +                   IOPT, WK, IWK, IFAIL)
      IMPLICIT NONE
C
C arguments
C     
      INTEGER N, NDIM, LDX, ITER, IOPT, IFAIL 
      INTEGER IWK(N*(N - 1)/2 + N*NDIM + 5)
      DOUBLE PRECISION D(N*(N - 1)/2), X(LDX,NDIM), STRESS,
     +                 DFIT(2*N*(N - 1)), WK(15*N*NDIM) 
      CHARACTER (LEN = 1) TYPE1
C
C allocatable 
C      
      INTEGER, ALLOCATABLE :: JWK(:)
C
C locals
C
      INTEGER    I, IADD1, IERR, J, K, K2, K3, L, MAXIT	
      DOUBLE PRECISION S
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL    S_STRESS
      EXTERNAL   MDSCAL5_DRIVER
      INTRINSIC  DBLE, MAX, SQRT
C
C check
C
      IFAIL = IOPT!to silnce ftn95
      IFAIL = 0
      IF (NDIM.LT.1 .OR.
     +    N.LE.NDIM .OR.
     +    LDX.LT.N) THEN
         IFAIL = 1
         RETURN
      ENDIF  
      IF (TYPE1.EQ.'T' .OR. TYPE1.EQ.'t') THEN
         S_STRESS = .FALSE.
      ELSEIF (TYPE1.EQ.'S' .OR. TYPE1.EQ.'s') THEN       
         S_STRESS = .TRUE.
      ELSE
         IFAIL = 1
         RETURN
      ENDIF      
      IADD1 = 0
      K = N*(N - 1)/2
      DO I = 1, K
         IF (D(I).LE.ZERO) IADD1 = IADD1 + 1
      ENDDO
      IF (IADD1.EQ.K) THEN
         IFAIL = 2
         RETURN
      ENDIF   
C
C define MAXIT ... seems to require > the minimum of 50 recommended by NAG 
C      
      IF (ITER.LE.0) THEN
         MAXIT = MAX(500,50*N*NDIM)
      ELSE   
         MAXIT = MAX(500,ITER)
      ENDIF   

c      
c define iwk = ij, the row and column indices noting that
c dimension of iwk >= n*(n - 1)/2
c dimension of jwk >= n*(n - 1)/2 + (n + 1) + n 
c and ww must be defined as 1 or 0
c 

c
c allocate then define ij before calling mdscal5
c
      ierr = 0
      if (allocated(jwk)) deallocate(jwk, stat = ierr)
      if (ierr.ne.0) then
        ifail = 10
        return
      endif  
         
      i = n*(n - 1)/2 + 2*n + 1
      allocate (jwk(i),stat = ierr)
      if (ierr.ne.0) then
         ifail = 10
         return
      endif  
      
      iadd1 = 0 
      do i = 2, n
         do j = 1, i - 1
            iadd1 = iadd1 + 1
            iwk(iadd1) = 512*i + j + 262144
         enddo
      enddo    
c
c define weights before calling mdscal5
c      
      k = n*(n - 1)/2
      k2 = 2*k
      do i = 1, k
         if (d(i).gt.zero) then
           dfit(k2 + i) = one
         else
            dfit(k2 + i) = zero
         endif     
      enddo
c
c pass D using dfit as otherwise mdscal5 would rearrange D
c      
      k3 = 3*k
      do i = 1, k
         dfit(k3 + i) = d(i)
      enddo   
      
      
      call mdscal5_driver (ifail, iwk,
     +                     jwk(1), jwk(k + 1), jwk(k + n + 2), 
     +                     ldx, maxit, n, ndim, 
     +                     dfit(k3 + 1), dfit(1), dfit(k + 1),
     +                     wk(1), wk(n*ndim + 1), wk(2*n*ndim + 1),
     +                     stress, dfit(2*k + 1), x,
     +                     s_stress)
      deallocate (jwk, stat = ierr)
c
c scale the best fit matrix to correspond to the NAG version
c        
      s = sqrt(dble(n - 1))
      do j = 1, ndim
         do i = 1, n
            x(i,j) = x(i,j)/s
         enddo   
      enddo  
      do i = 1, n*(n - 1)
         dfit(i) = dfit(i)/s
      enddo  
c
c At this stage extra work is required to output in NAG format as
c the estimates are only returned from MDSCAL5 in rearranged order as follows.
c dfit(1)     to dfit(k)   are now fitted (i.e. tilde) in input order 
c dfit(k + 1) to dfit(2*k) are now for X  (i.e. hat)   in input order. 
c So copy tilde from segment 1 into segment 3 and set segment 4 to 1
c Then calculate hat values directly and copy into into segment 1  
      
      k3 = 3*k  
      do i = 1, k
         dfit(i + k2) = dfit(i)!copy tilde into segment 3
         dfit(i + k3) = one    !set segment 4 = 1 to avoid confusion 
      enddo  
      k = 0 
      do i = 2, n
         do j = 1, i - 1
            s = zero
            do l = 1, ndim
               s = s + (x(i,l) - x(j,l))**2
            enddo
            k = k + 1
            dfit(k) = sqrt(s)    
         enddo
      enddo   
c
c square distances if s_stress = .true.
c
      if (s_stress) then
         do i = 1, 2*n*(n - 1)
            dfit(i) = dfit(i)**2
         enddo
      endif      
      END
C
C
C--------------------------------------------------------------------------      
c
c action: drive the Kruskal MDSCAL5 code from g03fcf$
c author: w.g.bardsley, university of manchester, u.k, 29/03/2013
c         The code has been heavily edited to run only in default mode
c         In particular all the original input/output has been removed,
c         many variables were removed and some subroutines renamed.
c         Note that output_info can be set = .true. to output iteration details.
c         Convergence depends on STRMIN and STRMIN/STRLST as well as several
c         other settings that were originally set for real not double
c         precision variables.
c         If s_stress = .true. on entry then SSTRESS is calculated not STRESS
c
      subroutine mdscal5_driver (ifail, ij, lblock, grno, grsdis, ldx,
     +                           maxit, n, ndim,  
     +                           data, dhat, dist, gl, gr, grstrs,
     +                           stress, ww, x,
     +                           s_stress)
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: maxit
      integer,          intent (inout) :: ifail 
      integer,          intent (in)    :: ldx, n, ndim
      integer,          intent (inout) :: ij(n*(n - 1)/2),
     +                                    lblock(n*(n - 1)/2),   
     +                                    grno(n + 1),
     +                                    grsdis(n)  
      double precision, intent (in)    :: ww(n*(n - 1)/2)   
      double precision, intent (inout) :: data(n*(n - 1)/2),
     +                                    dhat(n*(n - 1)/2),
     +                                    dist(n*(n - 1)/2)
      double precision, intent (inout) :: x(ldx,ndim)
      double precision, intent (inout) :: gl(n,ndim), gr(n,ndim)
      double precision, intent (inout) :: grstrs(n)
      double precision, intent (out)   :: stress  
      logical,          intent (in)    :: s_stress   

C mdscal.f
C The authors of this software are Joseph B Kruskal and Judith B Seery.
 
C Copyright (c) 1993 by AT&T.
C Permission to use, copy, modify, and distribute this software for any
C purpose without fee is hereby granted, provided that this entire
C notice is included in all copies of any software which is or includes
C a copy or modification of this software and in all copies of the
C supporting documentation for such software.
C THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR IMP-
C LIED WARRANTY.  IN PARTICULAR, NEITHER THE AUTHORS NOR AT&T MAKE ANY
C REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
C OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 
C This software comes from the FIRST MDS Package of AT&T Bell Laboratories
 
C The manual of how to use kyst2a is available in several different formats:
C see mds/kyst2a_manual.  It should be quite helpful in using mdscal.
 
C For explanation of the method this software implements, see
C "Multidimensional Scaling" (1978) by Joseph B. Kruskal and Myron Wish,
C Sage Publications: Beverly Hills, Calif.,
 
C "Multidimensional Scaling and Other Methods for Discovering Structure"
C (1977) by Joseph B. Kruskal, pp 296-339 in
C "Statistical Methods for Digital Computers" by Kurt Enslein,
C Anthony Ralston, and Herbert S. Wilf, Wiley: New York,
 
C "Multidimensional Scaling by Optimizing Goodness of Fit to a Nonmetric
C Hypothesis" (1964) by Joseph B. Kruskal in Psychometrika 29, pp 1-27,
 
C "Nonmetric Multidimensional Scaling: A Numerical Method" (1964) by
C Joseph B. Kruskal in Psychometrika 29(2) pp 115-129.
C----+----@----+----@----+----@----+----@----+----@----+----@----+----@
 
c      FORTRAN
C5MS                                                                    5MS    1
C                                                                       5MS    2
CMDSCAL            MDSCAL  MAIN PROGRAM                                 5MS    3
C MULTIDIMENSIONAL SCALING PROGRAM, VERSION 5MS, OCTOBER, 1971          5MS    4
C        DECEMBER, 1971, RELEASE                                        5MS    5
C        SUBROUTINES CCACT AND BLOCK DATA CORRECTED DECEMBER, 1971      5MS    6
C       ADAPTED BY J. KRUSKAL AND J. SEERY, NOVEMBER, 1971              5MS    7
C                                                                       5MS    8
C MULTIDIMENSIONAL SCALING PROGRAM. VERSION 5M                          5MS    9
C                                                                       5MS   10
C                                                                       5MS   11
C        THIS PROGRAM WAS WRITTEN BY                                    5MS   12
C                                                                       5MS   13
C             DR. J. B. KRUSKAL                                         5MS   14
C             BELL TELEPHONE LABORATORIES                               5MS   15
C             MURRAY HILL, N. J.                                        5MS   16
C                                                                       5MS   17
C                                                                       5MS   18
C        ADAPTED FOR IBM S/360 BY                                       5MS   19
C                                                                       5MS   20
C             F. J. CARMONE, JR.                                        5MS   21
C             DEPARTMENT OF MARKETING                                   5MS   22
C             DREXEL UNIVERSITY                                         5MS   23
C             PHILADELPHIA, PENNSYLVANIA    19104                       5MS   24
C             UNITED STATES OF AMERICA                                  5MS   25
C                                                                       5MS   26
C        DISTRIBUTED BY                                                 5MS   27
C                                                                       5MS   28
C             MARKETING SCIENCE INSTITUTE                               5MS   29
C             16 STORY STREET                                           5MS   30
C             CAMBRIDGE, MASS. 02138                                    5MS   31
C                                                                       5MS   32
C        OCTOBER 1, 1970                                                5MS   33
C                                                                       5MS   34
C                                                                       5MS   35
C             CHANGES MADE FOR "FIX" OPTION JAN 14, 1970                5MS   36
C             ROUTINES CHANGED  MAIN, CCACT, BLDA                       5MS   37
C                                                                       5MS   38
C                                                                       5MS   39
C                                                                       5MS   40
C             CHANGES MADE FOR SAVE CONFIGURATION AND RANDOM START      5MS   41
C             ON MAY 17, 1971. ROUTINES CHANGED  MAIN                   5MS   42
C                                                                       5MS   43
C                                                                       5MS   44
C GENERAL REMARKS.                                                      5MS   45
C                                                                       5MS   46
C THIS PROGRAM CONSISTS OF THE FOLLOWING ROUTINES.                      5MS   47
C      MDSCAL  MAIN ROUTINE                                             5MS   48
C      FIT     PERFORMS WEIGHTED-LEAST-SQUARES REGRESSION.              5MS   49
C      NEWSTP  FINDS NEW STEP SIZE FOR ITERATIVE MINIMIZATION.          5MS   50
C      CCACT   READS AND INTERPRETS CONTROL CARDS.                      5MS   51
C      SORT    SORTS ARRAYS. SIMPLE AND FAST,BEST AVAILABLE.            5MS   52
C      PLOTR   PLOTS DIST AND DHAT VERSUS DATA                          5MS   53
C      PLOT1   PLOTS THE TWO SPACE CONFIGURATION AND STRESS VS. DIMEN.  5MS   54
C NOTE   ALTHOUGH TWO PLOTTING ROUTINES ARE USED ARRAYS ARE EQUIVALENCED5MS   55
C        FOR MINIMUM SPACE.                                             5MS   56
C                                                                       5MS   57
C                                                                       5MS   58
C ALL ARE WRITTEN IN FORTRAN IV.                                        5MS   59
C                                                                       5MS   60
C NO USE IS MADE OF SPECIAL OR NON-STANDARD SOFTWARE.                   5MS   61
C                                                                       5MS   62
C ALL NORMAL INPUT-OUTPUT HANDLED BY  MDSCAL  AND  CCACT.               5MS   63
C                                                                       5MS   64
C FIT  HAS EMERGENCY DIAGNOSTIC OUTPUT.                                 5MS   65
C ALL INPUT AND OUTPUT IS ONTO FORTRAN LOGICAL UNITS WITH NUMBERS       5MS   66
C CONTROLLED BY THESE VARIABLES  LREAD,LPRINT,LPUNCH,LSCRAT.            5MS   67
C UNIT NUMBERS 5,6,43,2 HAVE BEEN USED RESPECTIVELY                     5MS   68
C TO CHANGE THESE ASSIGNMENTS, IT SUFFICES TO CHANGE THE VALUES         5MS   69
C FOR THE FOUR VARIABLES SET IN THE BLOCK DATA SUBPROGRAM.              5MS   70
C                                                                       5MS   71
C NOTE THAT THE SCRATCH UNIT IS USED IN A VERY MINOR WAY.               5MS   72
C IT IS USED ONLY BY  CCACT                                             5MS   73
C MANY INSTALLATIONS WILL HAVE ALTERNATE METHODS OF DOING THE SAME THING5MS   74
C                                                                       5MS   75
C      MDSCAL  THIS IS THE MAIN ROUTINE.                                5MS   76
C      IT DIRECTLY USES FIT, NEWSTP, CCACT, SORT.                       5MS   77
C                                                                       5MS   78
C                                                                       5MS   79
C      CARDS PUNCHED ACCORDING TO THE IBMEL 029 CHARACTER SET           5MS   80
C       NOTE   CONTROL PHRASE "TITLE" HAS BEEN DELETED                  5MS   81
C      NOTE   FUNCTIONS RPOWER, RM1POW, RROOT REPLACE RFUNCT            5MS   82
C                                                                       5MS   83

      integer j, ltemp1, l, nbakup, itno, m, mb, ma, k, mz,
     +        my, mx, ng, i, ldim 
      integer lnfixz, noit, lfitsw
      INTEGER NOGRPS, sdswit

      double precision factor, uot3, rut, t, u, dbas, dbar, sumw, 
     +                 strlst, stbamu, sfgl, fldim, sqrtn, fn, fngrps
      double precision sratst, sfgrmn, strmin   
      double precision dummy(100)
      INTEGER TWO9, TWO18
      double precision rm1, recr, rr 
      INTEGER RTYPE

      double precision step, sfgr
      double precision cagrgl, cosav, acsav, cosavw, acsavw, srat,
     +                 sratav
      double precision temp1, temp2 
      double precision rpower_mds, rroot_mds, rm1pow_mds

      logical    output_info, show_info
      parameter (output_info = .false.)
      external   rpower_mds, rroot_mds, rm1pow_mds
      external   sort_mds, fitm_mds, newstp_mds
      intrinsic  dble, sqrt, max
C                                                                       5MS   95
C                                                                       5MS   96
      COMMON /METRIC/ RTYPE,RM1,RECR,RR
C                                                                       5MS  110
C                                                                       5MS  113
       DATA    TWO9, TWO18  /512,  262144 /
C                                                                       5MS  115
C      INITIALIZE PARAMETERS                                            5MS  116

       nogrps = 1
       ldim = ndim
       grsdis(1) = 1
       fngrps = 1.0d+00
       do i = 1, n + 1
          grno(i) = 1
       enddo   
       rtype = 2
       show_info = output_info
       sdswit = 10
C                                                                       5MS  117
c 100   CONTINUE
C                                                                       5MS  119
C               ALPHABETICAL ORDER                                      5MS  120
       ACSAVW=0.66d+00
       COSAVW=0.66d+00
       GRNO(1) = 1
       LFITSW=1
       LNFIXZ = 0
       NOIT=max(100,maxit)
       SFGRMN=0.0d+00
       SRATST=0.999d+00
       STRESS=1.0d+00
c       STRMIN=0.01d+00
       strmin = 0.0001d+00
      
       if (show_info) write (*,'(a)') 'start of subroutine CMSCAL5'
 
C                                                                       5MS  357
C      COMPUTATION                 *************************************5MS  358
C                                                                       5MS  359

C2130  TEMP1=TEMP1+1.0                                                  5MS  420
c       TEMP1=TEMP1+0.01
C                                                                       5MS  422
C      SORT DATA AND IJ AND WW.                                         5MS  423
C      ALSO RECORD BLOCKS OF EQUAL DATA VALUES.                         5MS  424
C                                                                       5MS  425

       fn = dble(n)
       sqrtn = sqrt(fn)
              
       DO 2250 NG = 1,NOGRPS
         
c       MX = GRNO(NG)
c       MY = GRNO(NG+1) - 1
c       MZ = MY - MX + 1
c       SDSWIT = GRSDIS(NG)
c      SDSWIT = MOD(SDSWIT,100)
      
          mx = 1
c      my = n*(n - 1)/2 - 1
          my = n*(n - 1)/2
          mz = my - mx + 1
      
c      IF(SDSWIT.EQ.11)SDSWIT = -10
          call sort_mds( DATA(MX),MZ,IJ(MX),WW(MX),DUMMY,2,SDSWIT)
C                                                                       5MS  436
C               SORT  WILL SORT THE MM ELEMNTS OF  DATA  IN ALGEBRAIC   5MS  437
C              ORDER, ASCENDING OR DESCENDING ACCORDING TO WHETHER      5MS  438
C              SDSWIT IS + OR -.                                        5MS  439
C              AT THE SAME TIME, THE ELEMENTS IN  IJ  AND IN  WW  WILL B5MS  440
C              REARRANGED IN EXACTLY THE SAME ORDER. THUS THE           5MS  441
C              CORRESPONDENCE BETWEEN THE ELEMENTS OF  DATA  AND  IJ    5MS  442
C              AND  WW  IS PRESERVED.                                   5MS  443
C                                                                       5MS  444
C                                                                       5MS  445
          K=1
          MA = MX
          DO 2240 MB = MX,MY
             if (mb.eq.my) goto 2220  
             if (data(mb+1).ne.data(mb)) goto 2220  
c       IF(DATA(MB+1).NE.DATA(MB) .OR. MB .EQ. MY ) GO TO 2220
             K=K+1
             GO TO 2240
 2220        CONTINUE            
             DO 2230 M=MA,MB
                IJ(M) = MOD(IJ(M),TWO18)
                IJ(M) = IJ(M) + TWO18 * K
 2230        CONTINUE
             K=1
             MA=MB+1
 2240     CONTINUE
 2250  CONTINUE
C                                                                       5MS  459
C      START COMPUTATION IN CURRENT DIMENSION                           5MS  460
C                                                                       5MS  461
       FLDIM=DBLE(LDIM)
       ITNO=0
       COSAV=0.0d+00
       SRATAV=0.8d+00
       ACSAV=0.0d+00
       STEP = 0.0d+00
       NBAKUP = 0
C                                                                       5MS  469
C      INITIALIZE GRADIENT                                              5MS  470
C                                                                       5MS  471
       TEMP1=SQRT(1.0d+00/FLDIM)
       DO 2410 I=1,N
       DO 2410 L=1,LDIM
          GR(I,L)=TEMP1
 2410  CONTINUE
       SFGR=SQRTN
C                                                                       5MS  492
C      START CURRENT ITERATION     *************************************5MS  493
C                                                                       5MS  494
C      NORMALIZE CONFIGURATION. MOVE AND CLEAR GRADIENT.                5MS  495
C                                                                       5MS  496
 3000  TEMP1=0.0d+00
       DO 3030 L=1,LDIM
          TEMP2=0.0d+00
          DO 3010 I=1,N
             TEMP2=TEMP2+X(I,L)
 3010     CONTINUE
          TEMP2=TEMP2/FN
          DO 3020 I=1,N
             X(I,L)=X(I,L)-TEMP2
             TEMP1=TEMP1+X(I,L)**2
 3020     CONTINUE
 3030  CONTINUE
       TEMP1=SQRT (FN/TEMP1)
       DO 3040 L=1,LDIM
       DO 3040 I=1,N
          X(I,L)=TEMP1*X(I,L)
          GL(I,L)=TEMP1*GR(I,L)
          GR(I,L)=0.0d+00
 3040  CONTINUE
       SFGL=TEMP1*SFGR
C                                                                       5MS  514
       STBAMU = TEMP1
C      LOOP THROUGH THE DATA GROUPS                                     5MS  516
C                                                                       5MS  517
       STRLST = STRESS
       STRESS = 0.0d+00
       DO 3340 NG = 1,NOGRPS
c       MX = GRNO(NG)
c       MY = GRNO(NG+1) - 1
c       MZ = MY - MX + 1
c       SDSWIT = GRSDIS(NG)
c      LFITRM = SDSWIT/100
c      SDSWIT = MOD(SDSWIT,100)
c      IF(SDSWIT.EQ.11)SDSWIT = -10
C                                                                       5MS  528
C      COMPUTE DISTANCES AND FIND BEST-FITTING MONOTONE PSEUDO-DISTANCES5MS  529
C                                                                       5MS  530
       SUMW = 0.0d+00
       DBAR = 0.0d+00

       mx = 1
c       my = n*(n - 1)/2 - 1 
       my = n*(n - 1)/2      
       mz = my - mx + 1
       sdswit = 10
       lfitsw = 1
       
       DO 3120 M=MX,MY
          LTEMP1 = MOD(IJ(M),TWO18)
          I = LTEMP1/TWO9
          J = MOD(LTEMP1,TWO9)
          TEMP1=0.0d+00
          DO 3110 L=1,LDIM
            TEMP1=TEMP1+RPOWER_mds (X(I,L)-X(J,L))
 3110     CONTINUE
          DIST(M)=RROOT_mds (TEMP1)
          DBAR=DBAR+DIST(M)*WW(M)
          SUMW = SUMW + WW(M)
 3120  CONTINUE
 
      DBAR=DBAR/SUMW
C              DBAS IS EITHER  0  OR  DBAR  ACCORDING TO WHETHER        5MS  545
C              STRESS FORMULA 1 OR 2 IS BEING USED.                     5MS  546
       DBAS = 0.0d+00
       
C      IF(LSCH.EQ.2) DBAS = DBAR
       
       IF(IABS(SDSWIT).GE.10)
     1 CALL FITM_mds(DATA(MX),IJ(MX),DIST(MX),DHAT(MX), WW(MX),
     2 MZ, SDSWIT, LFITSW, lblock)
c       IF(IABS(SDSWIT).LT.10)
c     1 CALL FITP(DATA(MX),IJ(MX),DIST(MX),DHAT(MX),           WW(MX),
c     2 MZ, SDSWIT, LFITRM  )
C                                                                       5MS  555
C      CALCULATE U, T, AND STRESS                                       5MS  556
C                                                                       5MS  557
       U=0.0d+00
       T=0.0d+00
       
       IF (S_STRESS) THEN
          DO M = MX, MY
             U = U + (DIST(M)**2 - DHAT(M)**2)**2*WW(M)
             T = T + (DIST(M) - DBAS)**4*WW(M)
          ENDDO
       ELSE  
          DO 3210 M=MX,MY
             U=U+(DIST(M)-DHAT(M))**2*WW(M)
             T=T+(DIST(M)-DBAS)**2*WW(M)
 3210     CONTINUE
       ENDIF
       
       U=SQRT (U)
       TEMP1=T
       T=SQRT (T)
       GRSTRS(NG) = U/T
       STRESS = STRESS + GRSTRS(NG)**2
       IF(U.EQ.0.0d+00)   GO TO 3340
       RUT=1.0d+00/(U*T)
       UOT3=U/(TEMP1*T)
C                                                                       5MS  571
C      CALCULATE THE (NEGATIVE) GRADIENT                                5MS  572
C                                                                       5MS  573
       IF (S_STRESS) THEN
          DO 3331 M = MX,MY
             IF(DIST(M).EQ.0.0) GO TO 3331
             LTEMP1 = MOD(IJ(M),TWO18)
             I = LTEMP1/TWO9
             J = MOD(LTEMP1,TWO9)
             FACTOR = UOT3*(DIST(M) - DBAS)**3
     +      -RUT*(DIST(M)**2 - DHAT(M)**2)*dist(m)
             factor = 2.0d+00*factor
             FACTOR = (FACTOR/RM1POW_mds(DIST(M)) ) * WW(M)
             FACTOR = FACTOR * GRSTRS(NG)
             DO L = 1, LDIM
                TEMP1 = FACTOR * RM1POW_mds(X(I,L) - X(J,L))
                GR(I,L) = GR(I,L) + TEMP1
                GR(J,L) = GR(J,L) - TEMP1
             ENDDO
 3331     CONTINUE
       ELSE  
          DO 3330 M = MX,MY
             IF(DIST(M).EQ.0.0) GO TO 3330
             LTEMP1 = MOD(IJ(M),TWO18)
             I = LTEMP1/TWO9
             J = MOD(LTEMP1,TWO9)
             FACTOR=UOT3*(DIST(M)-DBAS)-RUT*(DIST(M)-DHAT(M))
             FACTOR = (FACTOR/RM1POW_mds(DIST(M)) ) * WW(M)
             FACTOR = FACTOR * GRSTRS(NG)
             DO 3320 L=1,LDIM
                TEMP1 = FACTOR * RM1POW_mds(X(I,L)-X(J,L))
                GR(I,L)=GR(I,L)+TEMP1
                GR(J,L)=GR(J,L)-TEMP1
 3320        CONTINUE
 3330     CONTINUE
       ENDIF
 
 3340  CONTINUE
       IF(STRESS .EQ. 0.0d+00 ) GO TO 3700
       STRESS = SQRT( STRESS / FNGRPS )
C                                                                       5MS  590
C             AVOID MOVING FIXED POINTS                                 5MS  591
C                                                                       5MS  592
       IF( LNFIXZ .EQ. 0) GO TO 3400
       DO 3360 I=1,LNFIXZ
       DO 3360 L=1,LDIM
          GR(I,L) = 0.0d+00
 3360  CONTINUE
C                                                                       5MS  597
C      FIND SCALE FACTOR OF GRADIENT, ANGLE-COSINE BETWEEN GRADIENT     5MS  598
C      AND PREVIOUS GRADIENT.                                           5MS  599
C                                                                       5MS  600
 3400  SFGR=0.0d+00
       CAGRGL=0.0d+00
       DO 3410 I=1,N
       DO 3410 L=1,LDIM
          GR(I,L) = GR(I,L) / STRESS
          SFGR=SFGR+GR(I,L)**2
          CAGRGL=CAGRGL+GR(I,L)*GL(I,L)
 3410  CONTINUE
       SFGR=SQRT (SFGR/FN)
C              IF GRADIENT   0.0, SKIP AHEAD.                           5MS  609
       IF(SFGR) 3420,3700,3420
 3420  TEMP1=SFGR*SFGL*FN
       CAGRGL=CAGRGL/TEMP1
C                                                                       5MS  613
       IF(ITNO.EQ.0  .OR.  NBAKUP.GE.4) GO TO 3500
       IF(CAGRGL.GT.(-0.95d+00)  .AND. 
     +    STRESS/STRLST.LT. 1.2001d+00 ) GOTO 3500
C                                                                       5MS  616
C      BACK UP ALONG LAST GRADIENT                                      5MS  617
C                                                                       5MS  618
       NBAKUP = NBAKUP + 1
       TEMP1 = STEP
       STEP = STEP / 10.0d+00
c       WRITE  (LPRINT,38)   STRESS, CAGRGL,  STEP
c 38    FORMAT(10X, F7.3, 14X, F7.3, 22X, F8.4 )
       TEMP1 = (TEMP1 - STEP) / SFGL
       TEMP1 = STBAMU * TEMP1
       DO 3430 I = 1,N
       DO 3430 L = 1,LDIM
          X(I,L) = X(I,L) - TEMP1*GL(I,L)
          GR(I,L) = GL(I,L)
 3430  CONTINUE
       SFGR = SFGL
       STRESS = STRLST
       GO TO 3000
C                                                                       5MS  633
C      STEP SIZE CALCULATIONS                                           5MS  634
C                                                                       5MS  635
 3500  IF(ITNO) 9999, 3510, 3520
 3510  SRAT=0.8d+00
       GO TO 3530
 3520  SRAT=STRESS/STRLST
 3530  CALL NEWSTP_mds (STEP, ITNO, SFGR, STRESS,
     1 CAGRGL, COSAV, ACSAV, COSAVW, ACSAVW, SRAT, SRATAV)
       NBAKUP = 0
C                                                                       5MS  643
C      PRINT CURRENT STATUS OF COMPUTATION                              5MS  644
C 
 3700 continue 
C                                                                       5MS  649
C      DECIDE WHETHER TO CONTINUE ITERATING                             5MS  650
C                                                                       5MS  651

       if (show_info) write (*,'(a,i6,a,i6,a,f10.6,a,f10.6)')
     +'iterate =', itno, ', ldim =', ldim, ', step =', step,
     +',  stress =', stress

       IF(STRESS) 9999, 3840, 3810
 3810  IF(SFGR-SFGRMN) 3850, 3850, 3815
 3815  TEMP1 = 0.5d+00 * (1.0d+00+SRATST)
       TEMP2 = 1.0d+00 - TEMP1
       IF( ABS (SRAT-TEMP1) - TEMP2 ) 3816, 3816, 3820
 3816  IF( ABS (SRATAV-TEMP1) - TEMP2 ) 3850, 3850, 3820
 3820  IF(STRESS-STRMIN) 3860, 3860, 3830
 3830  IF(ITNO-NOIT) 3900, 3870, 9999
 
 3840  CONTINUE
       if (show_info) write (*,'(a)') 'zero stress was reached'
       ifail = 0
       GO TO 4000
       
 3850  CONTINUE
       if (show_info) write (*,'(a)') 'minimum was achieved'
       ifail = 0
       GO TO 4000
       
 3860  CONTINUE
       if (show_info) write (*,'(a)') 'satisfactory stress was reached'
       ifail = 0
       GO TO 4000
       
 3870  CONTINUE
       if (show_info) write (*,'(a)') 'maximum iterations were used'
       ifail = 3
       return
C                                                                       5MS  676
C      CONTINUE ITERATING                                               5MS  677
C                                                                       5MS  678
 3900  ITNO=ITNO+1
       TEMP1=STEP/SFGR
       DO 3910 I=1,N
       DO 3910 L=1,LDIM
          X(I,L)=X(I,L)+TEMP1*GR(I,L)
 3910  CONTINUE
       GO TO 3000
C                                                                       5MS  685
C      STOP ITERATING              *************************************5MS  686
C  
 4000 continue                                                          
      return
c*******************************************************************************  
      
      
C                                                                       5MS  783
C      NORMAL TERMINATION, AFTER READING  STOP  ONCONTROL CARD          5MS  784
C                                                                       5MS  785
C                                                                       5MS  787
C      TROUBLE EXIT                                                     5MS  788
C
 9999  continue 
       ifail = 100
c 9999  WRITE            (LPRINT, 99)
c 99    FORMAT(52H0KRUSKAL. IMPOSSIBLE BRANCH TAKEN FROM IF STATEMENT. )
C                                                                       5MS  793
      END
c      
CRROO--------------------------------------------------------------------------
c
      FUNCTION RROOT_mds(ZZ)
      implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               RROO   3
C      WRITTEN BY J. KRUSKAL AND J. SEERY, NOVEMBER, 1971               RROO   4
C                                                                       RROO   5
      double precision rroot_mds, zz
      
      INTEGER RTYPE
      double precision z
      double precision rm1, recr, r
      COMMON /METRIC/ RTYPE,RM1,RECR,R
      Z=ZZ
      GO TO (310,320,330), RTYPE
 310  RROOT_mds=Z
      RETURN
 320  RROOT_mds=SQRT(Z)
      RETURN
 330  RROOT_mds=Z**RECR
      RETURN
      END
c      
CRM1P--------------------------------------------------------------------------
c
      FUNCTION RM1POW_mds(YY)
      implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               RM1P   3
C      WRITTEN BY J. KRUSKAL AND J. SEERY, NOVEMBER, 1971               RM1P   4
C                                                                       RM1P   5

      double precision rm1pow_mds, yy 
      double precision y
      INTEGER RTYPE
      double precision rm1, recr, r
      COMMON /METRIC/ RTYPE,RM1,RECR,R
      intrinsic sign
      Y=YY
      GO TO (210,220,230), RTYPE
 210  RM1POW_mds=0.0d+00
      IF(Y.NE.0.0d+00) RM1POW_mds=SIGN(1.0d+00,Y)
      RETURN
 220  RM1POW_mds=Y
      RETURN
 230  RM1POW_mds=SIGN(ABS(Y)**RM1,Y)
      RETURN
      END
c      
CRPOW--------------------------------------------------------------------------
c
      FUNCTION RPOWER_mds(XX)
      implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               RPOW   3
C      WRITTEN BY J. KRUSKAL AND J. SEERY, NOVEMBER, 1971               RPOW   4
C                                                                       RPOW   5
      double precision rpower_mds, xx
      INTEGER RTYPE
      double precision x
      double precision rm1, recr, r
      COMMON /METRIC/ RTYPE,RM1,RECR,R
      X=XX
      GO TO (110,120,130), RTYPE
 110  RPOWER_mds=ABS(X)
      RETURN
 120  RPOWER_mds=X*X
      RETURN
 130  RPOWER_mds=ABS(X)**R
      RETURN
      END
c      FORTRAN
CFITM                                                                   FITM   1
      SUBROUTINE FITM_mds(DATA, IJ, DIST, DHAT, WW,  MM, SDSWIT, LFITSW,
     +                    lblock )
      implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               FITM   3
C      UNCHANGED FROM VERSION 4, JANUARY,1968                           FITM   4
C                                                                       FITM   5
C      FITM    PERFORMS WEIGHTED-LEAST-SQUARES MONOTONE REGRESSION      FITM   6
C      THIS ROUTINE FINDS THE VALUES FOR  DHAT  WHICH ARE MONOTONIC     FITM   7
C      AND WHICH BEST APPROXIMATE  THE VALUES OF  DIST,                 FITM   8
C      IN THE SENSE THAT THE SUM OF THE SQUARED DEVIATIONS,             FITM   9
C      EACH ONE WEIGHTED BY THE CORRESPONDING VALUE IN  WW ,            FITM  10
C      IS A MINIMUM.                                                    FITM  11
C      IT DIRECTLY USES  SORT.                                          FITM  12
C                                                                       FITM  13
c
c arguments
c
       integer mm, sdswit, lfitsw 
       integer ij(*), lblock(*)
       double precision DATA(*), DIST(*), DHAT(*)
       double precision WW(*)
c
c locals
c       
       integer mbu, ku, mau, knew, mad, kd, mbd, nsatis, lud, m, mb, k,
     +         ma 
       INTEGER TWO18
       double precision davu, wtu, dtonew, davd, wtd, dav, wt, temp2,
     +                  temp1
C                                                                       FITM  18
       DATA    TWO18  /262144/

       external sort_mds
C                                                                       FITM  22
C      FORM FIRST APPROXIMATION TO CORRECT PARTITON                     FITM  23
C                                                                       FITM  24
C              IF LFITSW 1,  USE PRIMARY APPROACH.  THUS WE SORT EACH   FITM  25
C              BLOCK OF EQUAL VALUES OF DATA ACCORDING TO DIST VALUES.  FITM  26
C              THEN WE CREATE PARTITON INTO BLOCKS OF SIZE 1 TO START.  FITM  27
C                                                                       FITM  28
C              IF LFITSW 2,   USE SECONDARY APPROACH. THUS WE START WITHFITM  29
C              PARTITION INTO BLOCKS OF EQUAL DATA VALUES.              FITM  30
C                                                                       FITM  31
C              WITHIN EACH BLOCK  OF WHATEVER SIZE, THE FIRST DHAT VALUEFITM  32
C      GIVES THE WEIGHTED TOTAL OF THE DIST VALUES IN THAT BLOCK, WHILE FITM  33
C              THE LAST DHAT VALUE GIVES THE SUM OF THE WEIGHTS FOR THATFITM  34
C              BLOCK.  SIMILARLY, WITHIN EACH BLOCK, THE FIRST LBLOCK   FITM  35
C              VALUE AND THE LAST LBLOCK VALUE BOTH GIVE THE SIZE OF THEFITM  36
C              BLOCK.                                                   FITM  37
C      BLOCKS OF SIZE 1 FORM A PARTIAL EXCEPTION. EVERYTHIN IS THE SAME FITM  38
C              EXCEPT THAT THE SUM OF THE W VALUES IS NOT FOUND IN THE  FITM  39
C              LAST DHAT VALUE IN THE BLOCK.                            FITM  40
C                                                                       FITM  41
       MA=1
 110   K = IJ(MA) / TWO18
       MB=MA+K-1
       GO TO ( 200, 300 ), LFITSW
C                                                                       FITM  46
C              PRIMARY APPROACH                                         FITM  47
C                                                                       FITM  48
  200  IF(K-1) 9999, 220, 210
C              IF K 1, SAVE SORTING TIME                                FITM  50
  210  call sort_mds( DIST(MA), K, IJ(MA), DATA(MA),WW(MA),3,+1)
C                                                                       FITM  52
C               SORT  WILL SORT THE K ELEMENTS OF  DIST  IN ALGEBRAIC   FITM  53
C              ORDER.                                                   FITM  54
C              BECAUSE THE FINAL ARGUMENT IS ZERO, SORTING WILL BE      FITM  55
C              ASCENDING OR DESCENDING ACCORDING TO THE VALUE OF SDSWIT FITM  56
C              SUPPLIED DURING THE CALL FOR SORT IN MDSCAL.             FITM  57
C              THE ELEMENTS OF IJ  AND  DATA  WILL BE REARRANGED IN     FITM  58
C              EXACTLY THE SAME ORDER AS THOSE OF  DIST .               FITM  59
C      ALSO THE ELEMENTS OF  WW .                                       FITM  60
C                                                                       FITM  61
  220  DO 230 M=MA,MB
       DHAT(M) = DIST(M) * WW(M)
          LBLOCK(M)=1
  230  CONTINUE
       GO TO 400
C                                                                       FITM  66
C              SECONDARY APPROACH                                       FITM  67
C                                                                       FITM  68
C                                                                       FITM  69
  300  LBLOCK(MA)=K
       LBLOCK(MB)=K
       TEMP1=0.0d+00
       TEMP2 = 0.0d+00
       DO 310 M=MA,MB
          TEMP1 = TEMP1 + DIST(M) * WW(M)
          TEMP2 = TEMP2 + WW(M)
 310   CONTINUE
       DHAT(MA)=TEMP1
       IF(K-1) 9999, 400, 320
 320   DHAT(MB) = TEMP2
C              PROCEED TO NEXT BOCK. QUERY. IS IT THE LAST              FITM  81
C                                                                       FITM  82
  400  MA=MA+K
       IF(MA-MM-1) 110, 500, 9999
C                                                                       FITM  85
C      START MAIN COMPUTATION      *************************************FITM  86
C                                                                       FITM  87
  500  MA=1
  510  LUD=2
       NSATIS=0
  520  K=LBLOCK(MA)
       MB=MA+K-1
       IF(K-1) 9999, 530, 540
 530   WT =WW(MB)
       GO TO 550
 540   WT = DHAT(MB)
 550   DAV = DHAT(MA) / WT
       GO TO ( 600, 700 ), LUD
C                                                                       FITM  99
C              IS BLOCK DOWN-SATISFIED. IF NOT, MERGE                   FITM 100
C                                                                       FITM 101
  600  IF(MA-1) 9999, 630, 610
  610  MBD=MA-1
       KD=LBLOCK(MBD)
       MAD=MBD-KD+1
       IF(KD-1) 9999, 613, 615
 613   WTD =WW(MBD)
       GO TO 617
 615   WTD = DHAT(MBD)
 617   DAVD = DHAT(MAD) / WTD
       IF( DAVD-DAV ) 630, 620, 620
  620  KNEW=K+KD
       LBLOCK(MAD)=KNEW
       LBLOCK(MB)=KNEW
       DTONEW = DHAT(MAD) + DHAT(MA)
       DHAT(MAD) = DTONEW
       DHAT(MB) = WT + WTD
       NSATIS=0
       MA=MAD
       GO TO 800
  630  NSATIS=NSATIS+1
       GO TO 800
C                                                                       FITM 123
C              IS BLOCK UP-SATISFIED. IF NOT, MERGE                     FITM 124
C                                                                       FITM 125
  700  IF(MB-MM) 710, 730, 9999
  710  MAU=MB+1
       KU=LBLOCK(MAU)
       MBU=MAU+KU-1
       IF(KU-1) 9999, 713, 715
 713   WTU =WW(MBU)
       GO TO 717
 715   WTU = DHAT(MBU)
 717   DAVU = DHAT(MAU) / WTU
       IF( DAV-DAVU ) 730, 720, 720
  720  KNEW=K+KU
       LBLOCK(MA)=KNEW
       LBLOCK(MBU)=KNEW
       DTONEW = DHAT(MA) + DHAT(MAU)
       DHAT(MA) = DTONEW
       DHAT(MBU) = WT + WTU
       NSATIS=0
       GO TO 800
  730  NSATIS=NSATIS+1
       GO TO 800
C                                                                       FITM 146
C              PROCEED TO NEXT BLOCK IF READY.                          FITM 147
C                                                                       FITM 148
  800  LUD = 3-LUD
C              QUERY. IS BLOCK BOTH UP AND DOWN SATISFIED. IF NOT, RETURFITM 150
       IF(NSATIS-1) 520, 520, 810
C              QUERY. IS THIS LAST BLOCK. IF NOT, GO ON TO NEXT BLOCK.  FITM 152
  810  IF(MB-MM) 820, 900, 9999
  820  MA=MB+1
       GO TO 510
C                                                                       FITM 156
C      MAIN COMPUTATION COMPLETE. PLACE ANSWERS IN DHAT.                FITM 157
C                                                                       FITM 158
  900  MA=1
  910  K=LBLOCK(MA)
       MB=MA+K-1
       IF(K-1) 9999, 940, 920
 920   TEMP1 = DHAT(MA) / DHAT(MB)
       DO 930 M=MA,MB
          DHAT(M)=TEMP1
 930   CONTINUE 
       GO TO 945
 940   DHAT(MA) = DIST(MA)
 945   MA = MB + 1
       IF(MA-MM-1) 910, 950, 9999
  950  RETURN
C                                                                       FITM 171
C      TROUBLE EXIT                                                     FITM 172
C    
 9999 continue    
      sdswit = -sdswit!to silence ftn95
c 9999  WRITE            (LPRINT, 99)
c   99  FORMAT(50H0KRUSKAL. IMPOSSIBLE BRANCH TAKEN ON IF STATEMENT. )
       
C                                                                       FITM 177
      END
c      
CREGR--------------------------------------------------------------------------  
c                                                                 
       FUNCTION REGR(DA,I)
       implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               REGR   3
C      UNCHANGED FROM VERSION 4, JANUARY,1968                           REGR   4
CREGR          CALCULATES VALUES OF FUNCTIONS REGRESSED OVER            REGR   5
C                                                                       REGR   6

c      29/03/2013 edited by w.g.bardsley, university of manchester, u.k.
c
c arguments
c
       integer i
       double precision regr, da
c
c locals
c       
       integer j
       intrinsic min
       
       J=MIN(I,4)
       GO TO (10,20,30,40), J
C                                                                       REGR   9
 10    REGR=1.0d+00
       RETURN
C                                                                       REGR  12
 20    REGR=DA
       RETURN
C                                                                       REGR  15
 30    REGR=DA*DA
       RETURN
C                                                                       REGR  18
 40    REGR=DA**(I-1)
       RETURN
C                                                                       REGR  21
       END
c      
CNEWS----------------------------------------------------------------------------
c
       SUBROUTINE NEWSTP_mds( STEP, ITNO, SFGR, STRESS,
     1 CAGRGL, COSAV, ACSAV, COSAVW, ACSAVW, SRAT, SRATAV )
       implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               NEWS   4
C      UNCHANGED FROM VERSION 4, JANUARY,1968                           NEWS   5
CNEWSTP            NEWSTP  FOR MDSCAL                                   NEWS   6
C                                                                       NEWS   7
C      NEWSTP  THIS SUBROUTINE COMPUTES THE STEP SIZE.                  NEWS   8
C                                                                       NEWS   9
C              THE MAIN PURPOSE OF THIS ROUTINE IS TO COMPUTE THE NEW   NEWS  10
C              VALUE OF  STEP .                                         NEWS  11
C              INCIDENTALLY, IT UPDATES  COSAV ,  ACSAV , AND  SRATAV . NEWS  12
C                                                                       NEWS  13
C      UPDATE THREE AVERAGE QUANTITIES                                  NEWS  14
C                                                                       NEWS  15
c      29/03/2013 edited by w.g.bardsley, university of manchester, u.k.
c
c arguments
c
       integer itno
       double precision step, sfgr, stress, cagrgl, cosav, acsav,
     +                  cosavw, acsavw, srat, sratav
c
c locals
c     
       double precision goodlk, bias, temp2, temp1, ang

       intrinsic sqrt, min, abs
       
       COSAV = CAGRGL*COSAVW  +  COSAV*(1.0d+00-COSAVW)
       ACSAV = ABS (CAGRGL)*ACSAVW  +  ACSAV*(1.0d+00-ACSAVW)
       SRATAV = (SRAT**0.33334d+00)  *  (SRATAV**0.66666d+00)
       IF(ITNO) 100, 100, 200
C                                                                       NEWS  20
C              GUESS INITIAL STEP SIZE                                  NEWS  21
C                                                                       NEWS  22
 100   STEP= (25.0d+00*STRESS) * SFGR
       RETURN
C                                                                       NEWS  25
C              FIND NEW STEP SIZE                                       NEWS  26
C                                                                       NEWS  27
 200   ANG=4.0d+00**COSAV
       TEMP1 = 1.0d+00 + (MIN (1.0d+00,SRATAV) ) ** 5
       TEMP2 = 1.0d+00 + ( ACSAV - ABS (COSAV) )
       BIAS = 1.6d+00 / (TEMP1*TEMP2)
       GOODLK = SQRT (MIN (1.0d+00,SRAT) )
       STEP = STEP * ANG * BIAS * GOODLK
       RETURN
       END
c      
CSORT-------------------------------------------------------------------------
c
       SUBROUTINE SORT_mds (A, N, B, C, D, K, SWITCH )
       implicit none
C      MDSCAL, VERSION 5MS, OCTOBER, 1971                               SORT   3
C      UNCHANGED FROM VERSION 4, JANUARY,1968                           SORT   4
C                                                                       SORT   5
C     THIS ROUTINE SORTS INPUT ARRAY 'A' AND REARRANGES, OPTIONALLY,    SORT   6
C     ARRAYS 'B', 'C', AND 'D', IN ORDER CORRESPONDING TO 'A'.          SORT   7
C     N = NUMBER OF ITEMS IN 'A' (AND 'B', 'C', 'D', IF USED)           SORT   8
C     K = 0--SORT 'A' ONLY, 1--REARRANGE 'B', 2--REARRANGE 'B' AND 'C', SORT   9
C         3--REARRANGE 'B', 'C', AND 'D'.                               SORT  10
C     IF 'SWITCH' IS POSITIVE, SORT WILL BE IN ASCENDING ORDER,         SORT  11
C                 IF ZERO OR NEGATIVE, IN DESCENDING ORDER.             SORT  12
C     ALGORITHM FROM CACM, JULY 1959, PAGE 30 BY D. L. SHELL            SORT  13
C                                                                       SORT  14
c      29/03/2013 edited by w.g.bardsley, university of manchester, u.k.
c 
c arguments
c
       integer n, b(*), k, switch
       double precision A(*), C(*), D(*)
c
c locals
c
       integer i, im, j, kk, kp1, m
       double precision temp
       
       KP1=K+1
       IF(N.LE.1) GO TO 999
      M = 1
  106  M = M + M
       IF( M .LE. N ) GO TO 106
       M = M - 1
 994       M = M/2
       IF(M.EQ.0) GO TO 999
       KK = N-M
       J = 1
992     I = J
996     IM = I + M
       IF(SWITCH)  810,810,800
800     IF(A(I).GT.A(IM)) GO TO 110
       GO TO 995
810    IF(A(I).LT.A(IM))  GO TO 110
995     J = J+1
       IF(J.GT.KK)  GO TO 994
       GO TO 992
 110   TEMP=A(I)
       A(I) = A(IM)
       A(IM) = TEMP
       GO TO ( 140, 130, 120, 115), KP1
 115   TEMP = D(I)
       D(I) = D(IM)
        D(IM) = TEMP
 120   TEMP=C(I)
       C(I) = C(IM)
       C(IM) = TEMP
 130   TEMP=B(I)
       B(I) = B(IM)
       B(IM) = TEMP
140       I = I-M
       IF(I.LT.1)  GO TO 995
        GO TO 996
999      RETURN
      END
c      

