C
C
      SUBROUTINE G04AGF$(Y, N, K, LSUB, NOBS, L, NGP, GBAR, SGBAR,
     +                   GM, SS, IDF, F, FP, IFAIL)
C
C ACTION: Substitute for NAG G04AGF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 06/07/2000
C         All sums are worked out from scratch with no subtractions
C         12/09/2003 corrected error calculating SS(4)
C
      IMPLICIT   NONE
      INTEGER    K, L
      INTEGER    N, LSUB(K), NOBS(L), NGP(K), IDF(4), IFAIL
      INTEGER    II, JJ, KK, LL, MM
      DOUBLE PRECISION Y(N), GBAR(K), SGBAR(L), GM, SS(4), F(2),
     +                 FP(2)
      DOUBLE PRECISION BOT, TOP, G01EDF$
      DOUBLE PRECISION ZERO, EPSI
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-12)
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      EXTERNAL   G01EDF$
      INTRINSIC  ABS, DBLE
      IFAIL = 0
C
C Is it safe ?
C
      IF (K.LE.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
      JJ = 0
      DO II = 1, K
         IF (LSUB(II).LE.0) THEN
            IFAIL = 2
            RETURN
         ENDIF
         JJ = JJ + LSUB(II)
      ENDDO
      IF (JJ.NE.L) THEN
         IFAIL = 3
         RETURN
      ENDIF
      JJ = 0
      DO II = 1, L
         IF (NOBS(II).LE.0) THEN
            IFAIL = 4
            RETURN
         ENDIF
         JJ = JJ + NOBS(II)
      ENDDO
      IF (JJ.NE.N) THEN
         IFAIL = 5
         RETURN
      ENDIF
C
C The grand mean
C
      GM = ZERO
      DO II = 1, N
         GM = GM + Y(II)
      ENDDO
      GM = GM/DBLE(N)
C
C The group means
C
      LL = 0
      MM = 0
      DO II = 1, K
         GBAR(II) = ZERO
         NGP(II) = 0
         DO JJ = 1, LSUB(II)
            LL = LL + 1
            DO KK = 1, NOBS(LL)
               MM = MM + 1
               NGP(II) = NGP(II) + 1
               GBAR(II) = GBAR(II) + Y(MM)
            ENDDO
         ENDDO
         GBAR(II) = GBAR(II)/DBLE(NGP(II))
      ENDDO
C
C The subgroup means
C
      MM = 0
      DO II = 1, L
         SGBAR(II) = ZERO
         DO JJ = 1, NOBS(II)
            MM = MM + 1
            SGBAR(II) = SGBAR(II) + Y(MM)
         ENDDO
         SGBAR(II) = SGBAR(II)/DBLE(NOBS(II))
      ENDDO
C
C Degrees of freedom
C
      IDF(1) = K - 1
      IDF(2) = L - K
      IDF(3) = N - L
      IDF(4) = N - 1
C
C Sums of squares
C
      SS(1) = ZERO
      SS(2) = ZERO
      SS(3) = ZERO
      SS(4) = ZERO
      DO II = 1, K
         SS(1) = SS(1) + DBLE(NGP(II))*(GBAR(II) - GM)**2
      ENDDO
      MM = 0
      DO II = 1, K
         DO JJ = 1, LSUB(II)
            MM = MM + 1
            SS(2) = SS(2) + DBLE(NOBS(MM))*(SGBAR(MM) - GBAR(II))**2
         ENDDO
      ENDDO
      LL = 0
      MM = 0
      DO II = 1, K
         DO JJ = 1, LSUB(II)
            LL = LL + 1
            DO KK = 1, NOBS(LL)
               MM = MM + 1
               SS(3) = SS(3) + (Y(MM) - SGBAR(LL))**2
            ENDDO
         ENDDO
      ENDDO
      DO II = 1, N
         SS(4) = SS(4) + (Y(II) - GM)**2
      ENDDO
C
C Check
C
      IF (ABS(SS(4) - ZERO).LE.EPSI) THEN
         IFAIL = 6
         RETURN
      ENDIF
      IF (ABS(SS(3) - ZERO).LE.EPSI) THEN
         IFAIL = 7
         RETURN
      ENDIF
C
C F ratios
C

      BOT = SS(3)/DBLE(IDF(3))
      TOP = SS(1)/DBLE(IDF(1))
      F(1) = TOP/BOT
      TOP = SS(2)/DBLE(IDF(2))
      F(2) = TOP/BOT
C
C p values
C
      II = 0
      FP(1) = G01EDF$(TAIL, F(1), DBLE(IDF(1)), DBLE(IDF(3)), II)
      II = 0
      FP(2) = G01EDF$(TAIL, F(2), DBLE(IDF(2)), DBLE(IDF(3)), II)
      END
C
C
