C
C
      SUBROUTINE G04CAF$(N, Y, NFAC, LFAC, NBLOCK, INTER, IRDF, MTERM,
     +                   TABLE, ITOTAL, TMEAN, MAXT, E, IMEAN, SEMEAN,
     +                   BMEAN, R, IWK, IFAIL)

C
C ACTION: Substitute for G04CAF
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 29/09/2003
C
C WARNING: This is a very preliminary version which only does low order cases.
C ******** I shall replace it by a more comprehensive version as soon as possible.
C ******** It only analyses the special cases NFAC =< 3 and should be called
C          with INTER = 2 for 2 factors or else INTER = 3 for 3 factors,
C          and IRDF = 0 until higher order cases, etc. have been coded in.
C          Negative IFAIL will be returned for values outside these limits.
C
      IMPLICIT NONE
C
C Arguments supplied
C
      INTEGER N, NFAC, LFAC(NFAC), NBLOCK, INTER, IRDF, MTERM,
     +        ITOTAL, MAXT, IMEAN(MTERM), IWK(N + 3*NFAC), IFAIL
      DOUBLE PRECISION Y(N), TABLE(MTERM,5), TMEAN(MAXT), E(MAXT),
     +                 SEMEAN(MTERM), BMEAN(NBLOCK + 1), R(N)
C
C Local variables
C
      INTEGER    I, J, K, L, M, NBCOPY, NCELL, NLOOP
      INTEGER    NA, NB, NC, NPOS, NPROD, NSUM
      INTEGER    N0, N1, N2, N3, N4, N5
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5)
      DOUBLE PRECISION ARG, FVAL, DF1, DF2, G1, G2, G3, PVAL
      DOUBLE PRECISION S14ABF$, G01EDF$
      DOUBLE PRECISION ABSSQ, ABCSSQ, ACSSQ, ASSQ, BSSQ, BCSSQ, BBAR,
     +                 CSSQ, DENOM, DL, GMEAN, RSSQ, TSSQ, VAREST
      DOUBLE PRECISION DN, DNA, DNB, DNC, DNCELL, DNCOPY
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'U')
      EXTERNAL   S14ABF$, G01EDF$
      INTRINSIC  DBLE, EXP, SQRT, NINT
C
C Special checks as this version only works for NFAC =< 3
C
      IF (NFAC.GT.N3) THEN
         IFAIL = - 10
         RETURN
      ENDIF
      IF (NFAC.EQ.N2 .AND. INTER.NE.N2 .OR.
     +    NFAC.EQ.N3 .AND. INTER.NE.N3) THEN
         IFAIL = - 20
         RETURN
      ENDIF
C
C Is it safe ?
C
      IFAIL = N0
      IF (N.LT.N4 .OR. NFAC.LT.N1 .OR. NBLOCK.LT.N0 .OR.
     +    INTER.LT.N0 .OR. INTER.GT.NFAC .OR. IRDF.LT.N0) THEN
         IFAIL = N1
         RETURN
      ENDIF
C
C Define NPROD as the product of all the combinations
C
      NPROD = N1
      DO I = N1, NFAC
         IF (LFAC(I).LE.N1) THEN
            IFAIL = N2
            RETURN
         ENDIF
         NPROD = NPROD*LFAC(I)
      ENDDO
C
C Define NBCOPY to avoid problems with NBLOCK = 0
C
      IF (NBLOCK.GT.N0) THEN
         NBCOPY = NBLOCK
      ELSE
         NBCOPY = N1
      ENDIF
C
C Calculate NCELL = no. replicates per cell then see if N is consistent
C
      NCELL = N/(NPROD*NBCOPY)
      IF (N.NE.NCELL*NPROD*NBCOPY) THEN
         IFAIL = N2
         RETURN
      ENDIF
      IF (NBLOCK.GT.N1) THEN
         I = N/NBLOCK
         J = N - I*NBLOCK
         IF (J.NE.N0) THEN
            IFAIL = N2
            RETURN
         ENDIF
      ENDIF
C
C Check MAXT
C
      J = N1
      DO I = N1, NFAC
         J = J*(LFAC(I) + N1)
      ENDDO
      J = J - N1
      IF (MAXT.LT.J) THEN
         IFAIL = N2
         RETURN
      ENDIF
C
C Initialise BMEAN
C
      DO I = N1, NBLOCK + N1
         BMEAN(I) = ZERO
      ENDDO
C
C Initialise TABLE
C
      DO J = N1, N5
         DO I = N1, MTERM
            IF (I.EQ.N1) THEN
               TABLE(I,J) = ZERO
             ELSE
               TABLE(I,J) = ONE
             ENDIF
         ENDDO
      ENDDO
C
C Initialise the other arrays TMEAN, IMEAN and SEMEAN
C
      DO I = N1, MAXT
         TMEAN(I) = ZERO
         E(I) = ZERO
      ENDDO
      DO I = N1, MTERM
         IMEAN(I) = N0
         SEMEAN(I) = ZERO
      ENDDO
C
C Initialise sums of squares and double precision version of N
C
      ASSQ = ZERO
      ABSSQ = ZERO
      ABCSSQ = ZERO
      ACSSQ = ZERO
      BSSQ = ZERO
      BCSSQ = ZERO
      CSSQ = ZERO
      RSSQ = ZERO
      TSSQ = ZERO
      DN = DBLE(N)
C
C *********************
C Start of calculations
C *********************
C
C Calculate the grand mean and set BMEAN(1) = grand mean
C
      GMEAN = ZERO
      DO I = N1, N
         GMEAN = GMEAN + Y(I)
      ENDDO
      GMEAN = GMEAN/DN
      BMEAN(1) = GMEAN
C
C Form the first set of residuals and calculate the total sum of squares
C
      DO I = N1, N
         R(I) = Y(I) - GMEAN
         TSSQ = TSSQ + R(I)*R(I)
      ENDDO
      IF (TSSQ.LE.ZERO) THEN
         IFAIL = N3
         RETURN
      ENDIF
C
C Calculate ITOTAL then fill in TABLE(ITOTAL)
C
      ITOTAL = N3
      K = NFAC
      DO I = N1, INTER
         ARG = DBLE(K + N1)
         G1 = S14ABF$(ARG, IFAIL)
         ARG = DBLE(I + N1)
         G2 = S14ABF$(ARG, IFAIL)
         ARG = DBLE(K - I + N1)
         G3 = S14ABF$(ARG, IFAIL)
         ITOTAL = ITOTAL + NINT(EXP(G1 - G2 - G3))
      ENDDO
C
C Check MTERM
C
      IF (MTERM.LT.ITOTAL) THEN
         IFAIL = N2
         RETURN
      ENDIF
      IF (IRDF.LE.N0) THEN
         TABLE(ITOTAL,N1) = DBLE(N - N1)
      ELSE
         TABLE(ITOTAL,N1) = DBLE(N - IRDF)
      ENDIF
      TABLE(ITOTAL,N2) = TSSQ
C
C The block means if NBLOCK > 1
C
      IF (NBCOPY.GT.N1) THEN
         K = N0
         L = N/NBCOPY
         DL = DBLE(L)
         DO I = N2, NBCOPY + N1
            DO J = N1, L
               K = K + N1
               BMEAN(I) = BMEAN(I) + Y(K)
            ENDDO
            BMEAN(I) = BMEAN(I)/DL
         ENDDO
         TABLE(1,1) = DBLE(NBCOPY - N1)
         BBAR = ZERO
         DO I = N2, NBCOPY + N1
            BBAR = BBAR + (BMEAN(I) - GMEAN)**2
         ENDDO
         TABLE(1,2) = DL*BBAR
         TABLE(1,3) = TABLE(1,2)/TABLE(1,1)
      ENDIF

C
C**********************************************************
C The special case of two factors A and B, that is NFAC = 2
C**********************************************************
C
      IF (NFAC.EQ.N2) THEN
         NA = LFAC(1)
         NB = LFAC(2)
         NCELL = N/(NA*NB*NBCOPY)
         DNA = DBLE(NA)
         DNB = DBLE(NB)
         DNCELL = DBLE(NCELL)
         DNCOPY = DBLE(NBCOPY)
         IMEAN(1) = NA
         IMEAN(2) = IMEAN(1) + NB
         IMEAN(3) = IMEAN(2) + NA*NB
C
C 2 factors: Set up the factor A reference vector then calculate the A-means
C
         L = N0
         DO I = N1, NBCOPY
            DO J = N1, NA
               DO K = N1, NB*NCELL
                  L = L + N1
                  IWK(L) = J
               ENDDO
            ENDDO
         ENDDO
         DO I = N1, N
            J = IWK(I)
            TMEAN(J) = TMEAN(J) + Y(I)
         ENDDO
         DENOM = DNB*DNCELL*DNCOPY
         DO I = N1, NA
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 2 factors: Set up the factor B reference vector then calculate the B-means
C
         M = N0
         DO I = N1, NBCOPY
            DO J = N1, NA
               DO K = N1, NB
                  DO L = N1, NCELL
                     M = M + N1
                     IWK(M) = K + NA
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         DO I = N1, N
            J = IWK(I)
            TMEAN(J) = TMEAN(J) + Y(I)
         ENDDO
         DENOM = DNA*DNCELL*DNCOPY
         DO I = NA + N1, NA + NB
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 2 factors: Now calculate the AB-means without using the reference vector
C
         NSUM = NA + NB
         NPROD = NA*NB
         M = N0
         DO I = N1, NBCOPY
            NPOS = NSUM
            DO J = N1, NA
               DO K = N1, NB
                  NPOS = NPOS + N1
                  DO L = N1, NCELL
                     M = M + N1
                     TMEAN(NPOS) = TMEAN(NPOS) + Y(M)
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         DENOM = DNCOPY*DNCELL
         DO I = NSUM + N1, NSUM + NPROD
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 2 factors: Calculate the A-SSQ
C
         DO I = N1, NA
            ASSQ = ASSQ + E(I)*E(I)
         ENDDO
         ASSQ = DNB*DNCELL*DNCOPY*ASSQ
         TABLE(2,1) = DBLE(NA - N1)
         TABLE(2,2) = ASSQ
         TABLE(2,3) = TABLE(2,2)/TABLE(2,1)
C
C 2 factors: Calculate the B-SSQ
C
         DO I = NA + N1, NSUM
            BSSQ = BSSQ + E(I)*E(I)
         ENDDO
         BSSQ = DNA*DNCELL*DNCOPY*BSSQ
         TABLE(3,1) = DBLE(NB - N1)
         TABLE(3,2) = BSSQ
         TABLE(3,3) = TABLE(3,2)/TABLE(3,1)
C
C 2 factors: Calculate the AB-SSQ  = CELL-SSQ - A-SSQ - B-SSQ
C
         DO I = NSUM + N1, NSUM + NPROD
            ABSSQ = ABSSQ + E(I)*E(I)
         ENDDO
         ABSSQ = DNCELL*DNCOPY*ABSSQ - ASSQ - BSSQ
         TABLE(4,1) = DBLE((NA - N1)*(NB - N1))
         TABLE(4,2) = ABSSQ
         TABLE(4,3) = TABLE(4,2)/TABLE(4,1)
C
C 2 factors: Define residuals and R-SSQ
C
         M = N0
         DO I = N1, NBCOPY
            NPOS = NSUM
            DO J = N1, NA
               DO K = NA + N1, NSUM
                  NPOS = NPOS + N1
                  DO L = N1, NCELL
                     M = M + N1
                     R(M) = Y(M) - GMEAN - E(NPOS)
                     IF (NBCOPY.GT.N1)
     +               R(M) = R(M) - (BMEAN(I + 1) - GMEAN)
                     RSSQ = RSSQ + R(M)*R(M)
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
C
C 2 factors: Define residual degrees of freedom
C
         TABLE(5,1) = TABLE(ITOTAL,1)
         DO I = N1, ITOTAL - N2
            TABLE(5,1) = TABLE(5,1) - TABLE(I,1)
         ENDDO
         IF (TABLE(5,1).LE.ZERO .OR. RSSQ.LE.ZERO) THEN
            IFAIL = N4
            RETURN
         ENDIF
         TABLE(5,2) = RSSQ
         TABLE(5,3) = TABLE(5,2)/TABLE(5,1)
C
C 2 factors: define SEMEAN
C
         VAREST = TWO*TABLE(5,3)/DN
         SEMEAN(1) = SQRT(DNA*VAREST)
         SEMEAN(2) = SQRT(DNB*VAREST)
         SEMEAN(3) = SQRT(DNA*DNB*VAREST)
      ELSEIF (NFAC.EQ.3) THEN
C
C***************************************************************
C The special case of three factors A, B and C, that is NFAC = 3
C***************************************************************
C
         NA = LFAC(1)
         NB = LFAC(2)
         NC = LFAC(3)
         NCELL = N/(NA*NB*NC*NBCOPY)
         DNA = DBLE(NA)
         DNB = DBLE(NB)
         DNC = DBLE(NC)
         DNCELL = DBLE(NCELL)
         DNCOPY = DBLE(NBCOPY)
         IMEAN(1) = NA
         IMEAN(2) = IMEAN(1) + NB
         IMEAN(3) = IMEAN(2) + NC
         IMEAN(4) = IMEAN(3) + NA*NB
         IMEAN(5) = IMEAN(4) + NA*NC
         IMEAN(6) = IMEAN(5) + NB*NC
         IMEAN(7) = IMEAN(6) + NA*NB*NC
C
C 3 factors: Set up the factor A reference vector then calculate the A-means
C
         M = N0
         DO I = N1, NBCOPY
            DO J = N1, NA
               DO K = N1, NB
                  DO L = N1, NC*NCELL
                     M = M + N1
                     IWK(M) = J
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         DO I = N1, N
            J = IWK(I)
            TMEAN(J) = TMEAN(J) + Y(I)
         ENDDO
         DENOM = DNB*DNC*DNCELL*DNCOPY
         DO I = N1, NA
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 3 factors: Set up the factor B reference vector then calculate the B-means
C
         M = N0
         DO I = N1, NBCOPY
            DO J = N1, NA
               DO K = N1, NB
                  DO L = N1, NC*NCELL
                     M = M + N1
                     IWK(M) = K + NA
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         DO I = N1, N
            J = IWK(I)
            TMEAN(J) = TMEAN(J) + Y(I)
         ENDDO
         DENOM = DNA*DNC*DNCELL*DNCOPY
         NSUM = NA + NB
         NPROD = NA*NB
         DO I = NA + N1, NSUM
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 3 factors: Set up the factor C reference vector then calculate the C-means
C
         M = N0
         DO I = N1, NBCOPY
            DO J = N1, NA
               DO K = N1, NB
                  DO L = N1, NC
                     DO NPOS = N1, NCELL
                        M = M + N1
                        IWK(M) = L + NA + NB
                     ENDDO
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         DO I = N1, N
            J = IWK(I)
            TMEAN(J) = TMEAN(J) + Y(I)
         ENDDO
         DENOM = DNA*DNB*DNCELL*DNCOPY
         DO I = NSUM + N1, NSUM + NC
            TMEAN(I) = TMEAN(I)/DENOM
            E(I) = TMEAN(I) - GMEAN
         ENDDO
C
C 3 factors: Now calculate the AB-means without using the reference vector
C
          M = N0
          DO NLOOP = N1, NBCOPY
             NPOS = NA + NB + NC
             DO I = N1, NA
                DO J = N1, NB
                   NPOS = NPOS + N1
                   DO K = N1, NC
                      DO L = N1, NCELL
                         M = M + N1
                         TMEAN(NPOS) = TMEAN(NPOS) + Y(M)
                      ENDDO
                   ENDDO
                ENDDO
             ENDDO
          ENDDO
          NSUM = NA + NB + NC
          NPROD = NA*NB
          DENOM = DNC*DNCOPY*DNCELL
          DO I = NSUM + N1, NSUM + NPROD
             TMEAN(I) = TMEAN(I)/DENOM
             E(I) = TMEAN(I) - GMEAN
          ENDDO
C
C 3 factors: Now calculate the AC-means without using the reference vector
C
          M = N0
          DO NLOOP = N1, NBCOPY
             DO I = N1, NA
                DO J = N1, NB
                   NPOS = NSUM + NPROD +(I - N1)*NC
                   DO K = N1, NC
                      NPOS = NPOS + N1
                      DO L = N1, NCELL
                         M = M + N1
                         TMEAN(NPOS) = TMEAN(NPOS) + Y(M)
                      ENDDO
                   ENDDO
                ENDDO
             ENDDO
          ENDDO
          NSUM = NA + NB + NC + NA*NB
          NPROD = NA*NC
          DENOM = DNB*DNCOPY*DNCELL
          DO I = NSUM + N1, NSUM + NPROD
             TMEAN(I) = TMEAN(I)/DENOM
             E(I) = TMEAN(I) - GMEAN
          ENDDO
C
C 3 factors: Now calculate the BC-means without using the reference vector
C
          NSUM = NA + NB + NC + NA*NB + NA*NC
          M = N0
          DO NLOOP = N1, NBCOPY
             DO I = N1, NA
                NPOS = NSUM
                DO J = N1, NB
                   DO K = N1, NC
                      NPOS = NPOS + N1
                      DO L = N1, NCELL
                         M = M + N1
                         TMEAN(NPOS) = TMEAN(NPOS) + Y(M)
                      ENDDO
                   ENDDO
                ENDDO
             ENDDO
          ENDDO
          NPROD = NB*NC
          DENOM = DNA*DNCOPY*DNCELL
          DO I = NSUM + N1, NSUM + NPROD
             TMEAN(I) = TMEAN(I)/DENOM
             E(I) = TMEAN(I) - GMEAN
          ENDDO
C
C 3 factors: Now calculate the ABC-means without using the reference vector
C
          NSUM = NA + NB + NC + NA*NB + NA*NC + NB*NC
          NPROD = NB*NC
          M = N0
          DO NLOOP = N1, NBCOPY
             DO I = N1, NA
                DO J = N1, NB
                   NPOS = NSUM + (I - N1)*NPROD + (J - N1)*NC
                   DO K = N1, NC
                      NPOS = NPOS + N1
                      DO L = N1, NCELL
                         M = M + N1
                         TMEAN(NPOS) = TMEAN(NPOS) + Y(M)
                      ENDDO
                   ENDDO
                ENDDO
             ENDDO
          ENDDO
          DENOM = DNCOPY*DNCELL
          NPROD = NA*NB*NC
          DO I = NSUM + N1, NSUM + NPROD
             TMEAN(I) = TMEAN(I)/DENOM
             E(I) = TMEAN(I) - GMEAN
          ENDDO
C
C 3 factors: Calculate the A-SSQ
C
         DO I = N1, NA
            ASSQ = ASSQ + E(I)*E(I)
         ENDDO
         ASSQ = DNB*DNC*DNCELL*DNCOPY*ASSQ
         TABLE(2,1) = DBLE(NA - N1)
         TABLE(2,2) = ASSQ
         TABLE(2,3) = TABLE(2,2)/TABLE(2,1)
C
C 3 factors: Calculate the B-SSQ
C
         NSUM = NA + NB
         DO I = NA + N1, NSUM
            BSSQ = BSSQ + E(I)*E(I)
         ENDDO
         BSSQ = DNA*DNC*DNCELL*DNCOPY*BSSQ
         TABLE(3,1) = DBLE(NB - N1)
         TABLE(3,2) = BSSQ
         TABLE(3,3) = TABLE(3,2)/TABLE(3,1)
C
C 3 factors: Calculate the C-SSQ
C
         DO I = NSUM + N1, NSUM + NC
            CSSQ = CSSQ + E(I)*E(I)
         ENDDO
         CSSQ = DNA*DNB*DNCELL*DNCOPY*CSSQ
         TABLE(4,1) = DBLE(NC - N1)
         TABLE(4,2) = CSSQ
         TABLE(4,3) = TABLE(4,2)/TABLE(4,1)
C
C 3 factors: calculate the AB-SSQ, AC-SSQ and BC-SSQ
C
         NSUM = NA + NB + NC
         NPROD = NA*NB
         DO I = NSUM + N1, NSUM + NPROD
            ABSSQ = ABSSQ + E(I)*E(I)
         ENDDO
         ABSSQ = DNC*DNCELL*DNCOPY*ABSSQ  - ASSQ - BSSQ
         TABLE(5,1) = DBLE((NA - N1)*(NB - N1))
         TABLE(5,2) = ABSSQ
         TABLE(5,3) = TABLE(5,2)/TABLE(5,1)
         NSUM = NA + NB + NC + NA*NB
         NPROD = NA*NC
         DO I = NSUM + N1, NSUM + NPROD
            ACSSQ = ACSSQ + E(I)*E(I)
         ENDDO
         ACSSQ = DNB*DNCELL*DNCOPY*ACSSQ - ASSQ - CSSQ
         TABLE(6,1) = DBLE((NA - N1)*(NC - N1))
         TABLE(6,2) = ACSSQ
         TABLE(6,3) = TABLE(6,2)/TABLE(6,1)
         NSUM = NA + NB + NC + NA*NB + NA*NC
         NPROD = NB*NC
         DO I = NSUM + N1, NSUM + NPROD
            BCSSQ = BCSSQ + E(I)*E(I)
         ENDDO
         BCSSQ = DNA*DNCELL*DNCOPY*BCSSQ - BSSQ - CSSQ
         TABLE(7,1) = DBLE((NB - N1)*(NC - N1))
         TABLE(7,2) = BCSSQ
         TABLE(7,3) = TABLE(7,2)/TABLE(7,1)
C
C 3 factors: Calculate the ABC-SSQ  = CELL-SSQ - A-SSQ - B-SSQ - C-SSQ etc.
C
         NSUM = NA + NB + NC + NA*NB + NA*NC + NB*NC
         NPROD = NA*NB*NC
         DO I = NSUM + N1, NSUM + NPROD
            ABCSSQ = ABCSSQ + E(I)*E(I)
         ENDDO
         ABCSSQ = DNCELL*DNCOPY*ABCSSQ - ASSQ - BSSQ - CSSQ -
     +            ABSSQ - ACSSQ - BCSSQ
         TABLE(8,1) = DBLE((NA - N1)*(NB - N1)*(NC - N1))
         TABLE(8,2) = ABCSSQ
         TABLE(8,3) = TABLE(8,2)/TABLE(8,1)
C
C 3 factors: Define residuals and R-SSQ
C
         NPROD = NB*NC
         M = N0
         DO NLOOP = N1, NBCOPY
            DO I = N1, NA
               DO J = N1, NB
                  NPOS = NSUM + (I - N1)*NPROD + (J - N1)*NC
                  DO K = N1, NC
                     NPOS = NPOS + N1
                     DO L = N1, NCELL
                        M = M + N1
                        R(M) = Y(M) - GMEAN - E(NPOS)
                        IF (NBCOPY.GT.N1)
     +                  R(M) = R(M) - (BMEAN(NLOOP + N1) - GMEAN)
                        RSSQ = RSSQ + R(M)*R(M)
                     ENDDO
                  ENDDO
               ENDDO
            ENDDO
         ENDDO
         TABLE(9,1) = TABLE(ITOTAL,1)
         DO I = N1, ITOTAL - N2
            TABLE(9,1) = TABLE(9,1) - TABLE(I,1)
         ENDDO
         IF (TABLE(9,1).LE.ZERO .OR. RSSQ.LE.ZERO) THEN
            IFAIL = N4
            RETURN
         ENDIF
         TABLE(9,2) = RSSQ
         TABLE(9,3) = TABLE(9,2)/TABLE(9,1)
         VAREST = TWO*TABLE(9,3)/DN
         SEMEAN(1) = SQRT(DNA*VAREST)
         SEMEAN(2) = SQRT(DNB*VAREST)
         SEMEAN(3) = SQRT(DNC*VAREST)
         SEMEAN(4) = SQRT(DNA*DNB*VAREST)
         SEMEAN(5) = SQRT(DNA*DNC*VAREST)
         SEMEAN(6) = SQRT(DNB*DNC*VAREST)
         SEMEAN(7) = SQRT(DNA*DNB*DNC*VAREST)
      ENDIF
C
C **************************
C Finally the F and p values
C **************************
C
      J = ITOTAL - N1
      DF2 = TABLE(J,N1)
      IF (NBLOCK.GT.N1) THEN
         K = N1
      ELSE
         K = N2
      ENDIF
      DO I = K, ITOTAL - N2
         DF1 = TABLE(I,N1)
         FVAL = TABLE(I,N3)/TABLE(J,N3)
         PVAL = G01EDF$(TAIL, FVAL, DF1, DF2, IFAIL)
         TABLE(I,N4) = FVAL
         TABLE(I,N5) = PVAL
      ENDDO
      END
C
C
