C
C----------------------------------------------------------------
C action: implementation of g05caf$, g05cbf$, and g05ccf$
C author: w.g.bardsley, university of manchester, u.k, 27/01/2012
C         This is a free standing version based on RANDGEN but
C         altered to allow repeat re-initialisation using either
C         g05cbf$ or g05ccf$ and using the date and time routine.
C         Because the date/time seed is only accurate to 1 msec
C         g05ccf$ will set the same seed if called at intervals
C         of less than 1 msec.
C----------------------------------------------------------------
C
      DOUBLE PRECISION FUNCTION G05CAF$ (DUMMY)
      IMPLICIT NONE
      DOUBLE PRECISION, INTENT (INOUT) :: DUMMY
      DOUBLE PRECISION ZBQLU01
      EXTERNAL ZBQLU01
      G05CAF$ = ZBQLU01 (DUMMY)
      END       
C
C
      SUBROUTINE G05CBF$ (ISEED)
      IMPLICIT   NONE
      INTEGER,   INTENT (IN) :: ISEED 
      INTEGER    JSEED
      EXTERNAL   ZBQLINI
      INTRINSIC  ABS
      IF (ISEED.EQ.0) THEN
C
C trap ISEED = 0 which is used for g05ccf
C        
         JSEED = 123456789
      ELSE
         JSEED = ABS(ISEED)
      ENDIF      
      CALL ZBQLINI (JSEED)
      END 
C
C
      SUBROUTINE G05CCF$
      IMPLICIT   NONE
      INTEGER    ISEED
      PARAMETER (ISEED = 0)
      EXTERNAL   ZBQLINI
      CALL ZBQLINI (ISEED)
      END

C*******************************************************************
C********	FILE: randgen.f				***********
C********	AUTHORS: Richard Chandler		***********
C********		 (richard@stats.ucl.ac.uk)	***********
C********		 Paul Northrop 			***********
C********		 (northrop@stats.ox.ac.uk)	***********
C********	LAST MODIFIED: 26/8/03			***********
C********	See file randgen.txt for details	***********
C*******************************************************************
      BLOCK DATA ZBQLBD01
      IMPLICIT NONE
      INTEGER I
      INTEGER CURPOS, CURPOS_SAV, ID22, ID22_SAV, ID43, ID43_SAV      
      DOUBLE PRECISION ZBQLIX(43), ZBQLIX_SAV(43), B, B_SAV, C, C_SAV
C
C       Initializes seed array etc. for random number generator.
C       The values below have themselves been generated using the
C       NAG generator.
C
c
c Extra code added by w.g.bardsley as follows:
c Duplicate data and common block to allow repeated initialisation
c using G05CCF$ or G05CBF$ and allowing restoration of the default state
c

      COMMON /ZBQL0001/ ZBQLIX, ZBQLIX_SAV, B, B_SAV, C, C_SAV
      COMMON /ZBQL0002/ CURPOS, CURPOS_SAV, ID22, ID22_SAV, ID43, 
     +                  ID43_SAV
     
      DATA (ZBQLIX(I), I = 1, 43) /8.001441D7,5.5321801D8,
     +1.69570999D8,2.88589940D8,2.91581871D8,1.03842493D8,
     +7.9952507D7,3.81202335D8,3.11575334D8,4.02878631D8,
     +2.49757109D8,1.15192595D8,2.10629619D8,3.99952890D8,
     +4.12280521D8,1.33873288D8,7.1345525D7,2.23467704D8,
     +2.82934796D8,9.9756750D7,1.68564303D8,2.86817366D8,
     +1.14310713D8,3.47045253D8,9.3762426D7 ,1.09670477D8,
     +3.20029657D8,3.26369301D8,9.441177D6,3.53244738D8,
     +2.44771580D8,1.59804337D8,2.07319904D8,3.37342907D8,
     +3.75423178D8,7.0893571D7 ,4.26059785D8,3.95854390D8,
     +2.0081010D7,5.9250059D7,1.62176640D8,3.20429173D8,
     +2.63576576D8/
     
      DATA (ZBQLIX_SAV(I), I = 1, 43) /8.001441D7,5.5321801D8,
     +1.69570999D8,2.88589940D8,2.91581871D8,1.03842493D8,
     +7.9952507D7,3.81202335D8,3.11575334D8,4.02878631D8,
     +2.49757109D8,1.15192595D8,2.10629619D8,3.99952890D8,
     +4.12280521D8,1.33873288D8,7.1345525D7,2.23467704D8,
     +2.82934796D8,9.9756750D7,1.68564303D8,2.86817366D8,
     +1.14310713D8,3.47045253D8,9.3762426D7 ,1.09670477D8,
     +3.20029657D8,3.26369301D8,9.441177D6,3.53244738D8,
     +2.44771580D8,1.59804337D8,2.07319904D8,3.37342907D8,
     +3.75423178D8,7.0893571D7 ,4.26059785D8,3.95854390D8,
     +2.0081010D7,5.9250059D7,1.62176640D8,3.20429173D8,
     +2.63576576D8/
     
      DATA B / 4.294967291D9 /
      DATA C / 0.0D0 /
      DATA B_SAV / 4.294967291D9 /
      DATA C_SAV / 0.0D0 /
      DATA CURPOS, ID22, ID43 /1, 22, 43/
      DATA CURPOS_SAV, ID22_SAV, ID43_SAV /1, 22, 43/

      END BLOCK DATA ZBQLBD01
C
C-----------------------------------------------------------------
C      
      SUBROUTINE ZBQLINI(SEED)
      IMPLICIT NONE
C******************************************************************
C*       To initialize the random number generator - either
C*       repeatably or nonrepeatably. Need double precision
C*       variables because integer storage can't handle the
C*       numbers involved
C******************************************************************
C*	ARGUMENTS
C*	=========
C*	SEED	(integer, input). User-input number which generates
C*		elements of the array ZBQLIX, which is subsequently used 
C*		in the random number generation algorithm. If SEED=0,
C*		the array is seeded using the system clock  
C******************************************************************
C*	VARIABLES
C*	=========
C*	SEED	See above
C*	ZBQLIX	Seed array for the random number generator. Defined
C*		in ZBQLBD01
C*	B,C	Used in congruential initialisation of ZBQLIX
C*	SS,MM,}	System clock secs, mins, hours and days
C*	HH,DD }
C*
      INTEGER SEED, SS, MM, MS, HH, DD, I
      INTEGER IVALUE(8)
      INTEGER CURPOS, CURPOS_SAV, ID22, ID22_SAV, ID43, ID43_SAV
      DOUBLE PRECISION ZBQLIX(43), ZBQLIX_SAV(43), B, B_SAV, C, C_SAV
      DOUBLE PRECISION TMPVAR1, DSS, DMM, DMS, DHH, DDD

      COMMON /ZBQL0001/ ZBQLIX, ZBQLIX_SAV, B, B_SAV, C, C_SAV
      COMMON /ZBQL0002/ CURPOS, CURPOS_SAV, ID22, ID22_SAV, ID43, 
     +                  ID43_SAV
      SAVE /ZBQL0001/
      SAVE /ZBQL0002/
      
      DO I = 1, 43
         ZBQLIX(I) = ZBQLIX_SAV(I)
      ENDDO 
      B = B_SAV
      C = C_SAV
      CURPOS = CURPOS_SAV
      ID22 = ID22_SAV
      ID43 = ID43_SAV

C*       If SEED = 0, cat the contents of the clock into a file
C*       and transform to obtain ZQBLIX(1), then use a congr.
C*       algorithm to set remaining elements. Otherwise take
C*       specified value of SEED.

      IF (SEED.EQ.0) THEN
c
c Code to use DATE_AND_TIME down to milliseconds added by w.g.bardsley
c        
         CALL DATE_AND_TIME (VALUES = IVALUE)
         MS = IVALUE(8)
         SS = IVALUE(7)
         MM = IVALUE(6)
         HH = IVALUE(5)
         DD = (IVALUE(2) - 1)*30 + IVALUE(3)
         IF (DD.GT.365) DD = 365
         DMS = DINT((DBLE(MS)/1.0D3) * B)  
         DSS = DINT((DBLE(SS)/6.0D1) * B)
         DMM = DINT((DBLE(MM)/6.0D1) * B)
         DHH = DINT((DBLE(HH)/2.4D1) * B)
         DDD = DINT((DBLE(DD)/3.65D2) * B)
         TMPVAR1 = DMOD(DMS + DSS + DMM + DHH + DDD, B)
      ELSE
         TMPVAR1 = DMOD(DBLE(SEED), B)
      ENDIF
      ZBQLIX(1) = TMPVAR1
      DO I = 2, 43
         TMPVAR1 = ZBQLIX(I-1)*3.0269D4
         TMPVAR1 = DMOD(TMPVAR1,B)       
         ZBQLIX(I) = TMPVAR1
      ENDDO

      END
C
C-----------------------------------------------------------------
C     
cftn95$options(silent)       
      DOUBLE PRECISION FUNCTION ZBQLU01(DUMMY)
      IMPLICIT NONE
C*
C*       Returns a uniform random number between 0 & 1, using
C*       a Marsaglia-Zaman type subtract-with-borrow generator.
C*       Uses double precision, rather than integer, arithmetic 
C*       throughout because MZ's integer constants overflow
C*       32-bit integer storage (which goes from -2^31 to 2^31).
C*       Ideally, we would explicitly truncate all integer 
C*       quantities at each stage to ensure that the double
C*       precision representations do not accumulate approximation
C*       error; however, on some machines the use of DNINT to
C*       accomplish this is *seriously* slow (run-time increased
C*       by a factor of about 3). This double precision version 
C*       has been tested against an integer implementation that
C*       uses long integers (non-standard and, again, slow) -
C*       the output was identical up to the 16th decimal place
C*       after 10^10 calls, so we're probably OK ...
C*
      DOUBLE PRECISION  DUMMY, B, B_SAV, C, C_SAV, ZBQLIX(43),
     +      ZBQLIX_SAV(43), X, B2, BINV
      INTEGER CURPOS, CURPOS_SAV, ID22,ID22_SAV, ID43, ID43_SAV

      COMMON /ZBQL0001/ ZBQLIX, ZBQLIX_SAV, B, B_SAV, C, C_SAV
      COMMON /ZBQL0002/ CURPOS, CURPOS_SAV, ID22, ID22_SAV, ID43,
     +                  ID43_SAV
      SAVE /ZBQL0001/
      SAVE /ZBQL0002/

      B2 = B
      BINV = 1.0D0/B
   20 X = ZBQLIX(ID22) - ZBQLIX(ID43) - C
      IF (X.LT.0.0D0) THEN
       X = X + B
       C = 1.0D0
      ELSE
       C = 0.0D0
      ENDIF
      ZBQLIX(ID43) = X
C*
C*     Update array pointers. Do explicit check for bounds of each to
C*     avoid expense of modular arithmetic. If one of them is 0 the others
C*     won't be
C*
      CURPOS = CURPOS - 1
      ID22 = ID22 - 1
      ID43 = ID43 - 1
      IF (CURPOS.EQ.0) THEN
         CURPOS = 43
      ELSEIF (ID22.EQ.0) THEN
         ID22 = 43
      ELSEIF (ID43.EQ.0) THEN
         ID43 = 43
      ENDIF
C*
C*     The integer arithmetic there can yield X=0, which can cause 
C*     problems in subsequent routines (e.g. ZBQLEXP). The problem
C*     is simply that X is discrete whereas U is supposed to 
C*     be continuous - hence if X is 0, go back and generate another
C*     X and return X/B^2 (etc.), which will be uniform on (0,1/B). 
C*
      IF (X.LT.BINV) THEN
         B2 = B2*B
         GOTO 20
      ENDIF

      ZBQLU01 = X/B2

      END
C
C