C
C
      DOUBLE PRECISION FUNCTION G05DCF$(A, B)
C
C ACTION : Logistic random numbers
C          f(x) = exp[(x - a)/b]/{b[1 + exp([a - b]/b)]^2}
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 10/8/97
C
      IMPLICIT  NONE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION DUMMY, G05CAF$, RTOL, Y, Z, X02AMF$
      EXTERNAL  G05CAF$, X02AMF$
      INTRINSIC MAX, LOG
      RTOL = 1.0D+09*X02AMF$()
      Y = MAX(RTOL, G05CAF$(DUMMY))
      Z = MAX(RTOL, ONE - Y)
      G05DCF$ = A + B*LOG(Y/Z)
      END
C
C
