C
C
      DOUBLE PRECISION FUNCTION G05DDF$(A, B)
C
C ACTION : Normal deviates by the Box Muller method (using both).
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 8/5/97
C          28/09/2012 edited to use both numbers   
C
      IMPLICIT   NONE
      DOUBLE PRECISION A, B
      INTEGER    K
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION DUMMY, F, G05CAF$, Q, RTOL, Y1, Y2, X1, X2
      DOUBLE PRECISION X02AMF$
      EXTERNAL   G05CAF$, X02AMF$
      INTRINSIC  ABS, SQRT, LOG
      SAVE       K, Y2
      DATA       K  / 1 /
      IF (K.EQ.1) THEN 
C
C Compute Y1 and Y2 ... then use Y1 but save Y2 and re-set K = 2
C             
         RTOL = 1.0D+09*X02AMF$()
   20    CONTINUE
         Y1 = G05CAF$(DUMMY)
         Y2 = G05CAF$(DUMMY)
         X1 = TWO*Y1 - ONE
         X2 = TWO*Y2 - ONE
         Q = X1**2 + X2**2
         IF (Q.LT.RTOL .OR. Q.GE.ONE) GOTO 20
         F = SQRT(-TWO*LOG(Q)/Q)  
         Y1 = X1*F
         Y2 = X2*F
         G05DDF$ = A + Y1*ABS(B)
         K = 2
      ELSE 
C
C Use the stored value of Y2 then re-set K = 1
C
          
         G05DDF$ = A + Y2*ABS(B)
         K = 1
      ENDIF   
      END
C
C
