C
C
      DOUBLE PRECISION FUNCTION G05DFF$(A, B)
C
C ACTION : Cauchy random numbers
C          f(x) = 1/{pi*b[1 + [(x - a)/b]^2}
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 10/8/97
C
      IMPLICIT  NONE
      DOUBLE PRECISION A, B
      DOUBLE PRECISION ONE, TWO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION DUMMY, G05CAF$, RTOL, YDIFF, Y1, Y2, Z, X02AMF$
      EXTERNAL  G05CAF$, X02AMF$
      INTRINSIC MAX
      RTOL = 1.0D+09*X02AMF$()
   20 CONTINUE
      Y1 = G05CAF$(DUMMY)
      Y2 = MAX(RTOL, G05CAF$(DUMMY))
      YDIFF = TWO*Y1 - ONE
      Z = YDIFF**2 + Y2**2
      IF (Z.GT.ONE) GOTO 20
      G05DFF$ = A + B*YDIFF/Y2
      END
C
C
