C
C
      DOUBLE PRECISION FUNCTION G05DHF$(N, IFAIL)
C
C ACTION : Chi-square random number using G05FFF$
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 10/5/97
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I
      DOUBLE PRECISION TWO
      PARAMETER (TWO = 2.0D+00)
      DOUBLE PRECISION A, B, X(N1)
      EXTERNAL   G05FFF$
      INTRINSIC  DBLE
C
C Is it safe ?
C
      IFAIL = N0
      IF (N.LT.N1) THEN
         IFAIL = N1
         RETURN
      ENDIF
C
C Transform from chi-square to gamma
C
      A = DBLE(N)/TWO
      B = TWO
      I = 0
      CALL G05FFF$(A, B, N1, X, I)
      G05DHF$ = X(N1)
      END
C
C
