C
C
      DOUBLE PRECISION FUNCTION G05DJF$(N, IFAIL)
C
C ACTION : A t-random number using G05FFF$ and G05DFF$
C AUTHOR : W.G.Bardsley, University of manchester, U.K., 10/5/97
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION A, B, DN, G05DDF$, RTOL, X(N1), X02AMF$, Y, Z
      EXTERNAL   G05FFF$, G05DDF$, X02AMF$
      INTRINSIC  DBLE, MAX, SQRT
C
C Is it safe ?
C
      IFAIL = N0
      IF (N.LT.N1) THEN
         IFAIL = N1
         RETURN
      ENDIF
C
C Get a normal deviate Y
C
      A = ZERO
      B = ONE
      Y = G05DDF$(A, B)
C
C Transform from chi-square to gamma
C
      DN = DBLE(N)
      A = DN/TWO
      B = TWO
      I = 0
      CALL G05FFF$(A, B, N1, X, I)
      RTOL = 1.0D+09*X02AMF$()
      Z = MAX(RTOL, X(N1))
      G05DJF$ = Y*SQRT(DN/Z)
      END
C
C
