C
C
      DOUBLE PRECISION FUNCTION G05DPF$(A, B, IFAIL)
C
C ACTION : Weibull random numbers
C          f(x) = (a/b)x^(a - 1) exp(-x^a/b)
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/5/97
C
      IMPLICIT   NONE
      INTEGER    IFAIL
      DOUBLE PRECISION A, B
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION DUMMY, G05CAF$, RTOL, X02AMF$, Z
      EXTERNAL   G05CAF$, X02AMF$
      INTRINSIC  MAX, LOG
      RTOL = 1.0D+09*X02AMF$()
      G05DPF$ = ZERO
      IFAIL = 0
      IF (A.LE.RTOL) THEN
         IFAIL = 1
         RETURN
      ELSEIF (B.LE.RTOL) THEN
         IFAIL = 2
         RETURN
      ENDIF
      Z = MAX(RTOL, G05CAF$(DUMMY))
      G05DPF$ = (-B*LOG(Z))**(ONE/A)
      END
C
C
