C
C
      SUBROUTINE G05ECF$(T, R, NR, IFAIL)
C
C ACTION : Set up a Poisson reference vector for the Simfit package
C          This does not correspond to the NAG method but it works
C          OK for small N
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 10/5/97
C          28/09/2012 extensive editing
C
C Note: This version just sets up start/stop points and CDF values as follows:
C       R(1) = NSTART = lowest  reasonable value for a random Poisson variable
C       R(2) =  NSTOP = highest reasonable value for a random Poisson variable 
C       with R(3) to R(NSTOP - NSTART + 3) set to corresponding CDF values. 
C       This version will only work with the corresponding Simfit version of G05EYF$
C   
      IMPLICIT   NONE
      INTEGER    IFAIL, NR
      INTEGER    NMAX
      PARAMETER (NMAX = 100000)
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, J, K, L, M, NSTART, NSTOP
      DOUBLE PRECISION T, R(NR)
      DOUBLE PRECISION ZERO, ONE, PBOT, PTOP, Q
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PBOT = 1.0D-06,
     +           PTOP = ONE - PBOT, Q = 7.0D+00)
      DOUBLE PRECISION TEMP, PEQK, PGTK, PLEK
      EXTERNAL   G01BKF$
      INTRINSIC  DBLE, NINT, SQRT, MAX
C
C Is it safe ?
C
      IFAIL = N0
      IF (T.LT.ZERO) THEN
         IFAIL = N1
         RETURN
       ENDIF
C
C Initialise
C
      TEMP = MAX(T,PBOT)
      NSTART = - N1
      NSTOP = - N1
      M = NINT(TEMP - Q*SQRT(TEMP))
      IF (M.LE.N0) THEN
         M = N0
         K = - N1
      ELSE   
        K = M - 1
      ENDIF
      L = - N1
C
C Loop until NSTART and NSTOP are located
C
      SEARCH_LOOP : DO I = M, NMAX
         J = N0
         K = K + N1
         IF (NSTART.LT.N0) THEN
C
C Executed only until NSTART is assigned
C
            CALL G01BKF$(TEMP, K, PLEK, PGTK, PEQK, J)
            IF (PLEK.GE.PBOT) THEN
               NSTART = K
               L = N3
               R(L) = PLEK
            ENDIF
         ELSEIF (NSTOP.LT.N0) THEN
C
C Executed until NSTOP is assigned
C
            CALL G01BKF$(TEMP, K, PLEK, PGTK, PEQK, J)
            L = L + N1
            IF (L.GT.NR - N4) THEN
               IFAIL = N2
               RETURN
            ENDIF   
            R(L) = PLEK
            IF (PLEK.GE.PTOP) THEN
               NSTOP = K 
               R(L) = ONE
               EXIT SEARCH_LOOP
            ENDIF
         ENDIF
      ENDDO SEARCH_LOOP
C
C Finally assign R(1) and R(2)
C
      IF (NSTART.LT.N0) NSTART = N0
      IF (NSTOP.LE.NSTART) NSTOP = NSTART + 1
      R(N1) = DBLE(NSTART)
      R(N2) = DBLE(NSTOP)
      END
C
C
