C
C
      SUBROUTINE G05EDF$(N, P, R, NR, IFAIL)
C
C ACTION : Set up a binomial reference vector for the Simfit package
C          This does not correspond to the NAG method but it works
C          OK for fairly small N as explained below.
C AUTHOR : W.G.Bardsley, University of Manchester, U.K, 10/5/97
C          28/09/2012 extensively revised          
C
C Note: this version does not exploit symmetry to allow for differing action if 
C       P =< 0.5 or P > 0.5 but sets up start/stop points and CDF values as follows:
C       R(1) = NSTART = lowest  reasonable value for a random binomial variable
C       R(2) =  NSTOP = highest reasonable value for a random binomial variable 
C       with R(3) to R(NSTOP - NSTART + 3) set to corresponding CDF values. 
C       This version will only work with the corresponding Simfit version of G05EYF$
C       Caution is required if I decide to restore symmetry without editing G05EYF$
C           
      IMPLICIT   NONE
      INTEGER    IFAIL, N, NR
      INTEGER    N0, N1, N2, N3, N4, N20
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N20 = 20)
      INTEGER    I, J, K, L, M, NSTART, NSTOP, NTEMP
      DOUBLE PRECISION DN, P, R(NR)
      DOUBLE PRECISION ZERO, ONE, PBOT, PTOP, Q
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, PBOT = 1.0D-06,
     +           PTOP = ONE - PBOT, Q = 7.0D+00)
      DOUBLE PRECISION PTEMP, PEQK, PGTK, PLEK
      EXTERNAL   G01BJF$
      INTRINSIC  DBLE, NINT, SQRT
C
C Is it safe ?
C
      IFAIL = N0
      IF (N.LT.N1) THEN
         IFAIL = N1
         RETURN
       ENDIF
       IF (P.LT.ZERO .OR. P.GT.ONE) THEN
          IFAIL = N2
          RETURN
       ENDIF
       IF (NR.LT.N4) THEN
          IFAIL = N3
          RETURN
       ENDIF
C
C Initialise and define PTEMP and NTEMP
C
      PTEMP = P
      IF (PTEMP.LT.PBOT) THEN
         PTEMP = PBOT
      ELSEIF (PTEMP.GT.PTOP) THEN
         PTEMP = PTOP
      ENDIF  
      NTEMP = N    
      IF (N.LE.N20) THEN
C
C N =< 20 so set up a full vector of N + 1 values
C        
         IF (NR.LT.N + N3) THEN
            IFAIL = N3
            RETURN
         ENDIF
         NSTART = N0
         NSTOP = N
         R(1) = NSTART
         R(2) = NSTOP
         L = N2
         DO I = NSTART, NSTOP - N1
            J = N0
            K = I
            CALL G01BJF$(NTEMP, PTEMP, K, PLEK, PGTK, PEQK, J)
            L = L + N1
            R(L) = PLEK
         ENDDO    
         L = L + N1
         R(L) = ONE  
      ELSE  
C
C N > 20 so work out a reasonable span
C          
         NSTART = - N1
         NSTOP = - N1
         DN = DBLE(N)
C
C Use mean and variance to guess a sensible starting point
C         
         M = NINT(DN*P - Q*SQRT(DN*P*(ONE - P)))
         IF (M.LT.N0) THEN
            M = N0
         ELSEIF (M.GT.N - N20) THEN
            M = N - N20
         ENDIF        
         K = M - N1
C
C Loop until NSTART and NSTOP are located
C
         SETUP_LOOP : DO I = M, N
            J = N0
            K = K + N1
            IF (NSTART.LT.N0) THEN
C
C Executed only until NSTART is assigned
C
               CALL G01BJF$(NTEMP, PTEMP, K, PLEK, PGTK, PEQK, J)
               IF (PLEK.GE.PBOT) THEN
                  NSTART = K
                  L = N3
                  R(L) = PLEK
               ENDIF
            ELSEIF (NSTOP.LT.N0) THEN
C
C Executed until NSTOP is assigned
C
               CALL G01BJF$(NTEMP, PTEMP, K, PLEK, PGTK, PEQK, J)
               L = L + N1
               IF (NR.LT.L + N1) THEN
                  IFAIL = N3
                  RETURN
               ENDIF
               R(L) = PLEK
               IF (PLEK.GE.PTOP) THEN
                  NSTOP = K
                  R(L) = ONE
                  EXIT SETUP_LOOP
              ENDIF   
            ENDIF
         ENDDO SETUP_LOOP
C
C Finally assign R(1) and R(2) and make sure NSTART >= 0, NSTOP =< N
C
         IF (NSTART.LT.N0) NSTART = N0
         IF (NSTOP.GT.N) NSTOP = N
         R(N1) = DBLE(NSTART)
         R(N2) = DBLE(NSTOP)
      ENDIF
      END

C
C
