C
C SIMFIT version of NAG routine G05EHF
C
      SUBROUTINE G05EHF$ (ISEQ, N, IFAIL)
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      INTEGER    ISEQ(N)
      INTEGER    I, J, K, LOOP
      INTEGER    N0, N1, N2
      PARAMETER (N0 = 0, N1 = 1, N2 = 2)
      DOUBLE PRECISION X, Y
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      DOUBLE PRECISION  G05CAF$
      EXTERNAL   G05CAF$
      INTRINSIC  MIN, INT
C
C Initialise IFAIL and check N
C      
      IFAIL = N0
      IF (N.LT.1) THEN
         IFAIL = N1
         RETURN
      ENDIF   
      IF (N.LT.N2) RETURN
C
C Swap I, J elements randomly
C        
      Y = ONE
      DO I = N2, N
         LOOP = I
         Y = Y + ONE
         J = MIN(LOOP, INT(G05CAF$(X)*Y) + N1)
         K = ISEQ(J)
         ISEQ(J) = ISEQ(I)
         ISEQ(I) = K
      ENDDO
      END
C
C