C
C
      INTEGER FUNCTION G05EYF$(R, NR)
C
C ACTION : Integer random variable using range and CDF values in R 
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/5/97
C          28/09/2012 revised to use bisection
C
C Note: This does not correspond to the NAG method but it works
C       OK for fairly small N as now explained.
C       It must be set up by G05ECF$ and G05EDF$ as follows. 
C       R(1) = starting value,
C       R(2) = stopping value
C       R(3) to R(NSTOP - NSTART + 3) the CDF values 
C       It simply uses bisection to locate the correct CDF values so
C       it could be improved for large N by using a guesswork start
C       routine instead of simple bisection. However, the way that
C       the Simfit routines G05ECF$ and G05EDF$ work means that the
C       table to be searched should never be much longer than about 20. 
C
      IMPLICIT  NONE
      INTEGER   NR
      INTEGER   K, M, NSTART, NSTOP
      DOUBLE PRECISION R(NR)
      DOUBLE PRECISION DUMMY, G05CAF$, P
      EXTERNAL  G05CAF$
      INTRINSIC NINT
      EXTERNAL  BISECT
C
C Get a U(0,1) variate then retrieve NSTART and NSTOP
C
      P = G05CAF$(DUMMY)
      NSTART = NINT(R(1))
      NSTOP = NINT(R(2))
C
C Search the available range of CDF values
C      
      K = NSTOP - NSTART + 1
      CALL BISECT (K, M,
     +             R(3), P) 
C
C Add the offset and make sure values cannot be negative
C         
      G05EYF$ = NSTART + M   
      IF (G05EYF$.LT.0) G05EYF$ = 0
      END
C
C



