C
C
      SUBROUTINE G05FFF$(A, B, N, X, IFAIL)
C
C ACTION : Gamma random variates
C          This version inverts the gamma distribution by inverting
C          a chi-square distribution using G01FCF$ so it may not
C          be suitable for large samples
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 10/5/97
C          01/10/2012 checked
C
C Note: this version has been checked at 01/10/2012 against the NAG 
C       version using G05KGF, and G05SJF and it works perfectly.
C       As the various rejection codes such as RANDGEN and NAG codes
C       are complicated anyway and approaching the code necessary to 
C       invert the distribution I see no need to revise it at this stage.
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I, J
      DOUBLE PRECISION A, B, X(N)
      DOUBLE PRECISION ZERO, TWO
      PARAMETER (ZERO = 0.0D+00, TWO = 2.0D+00)
      DOUBLE PRECISION AT2, BD2, CHI, DUMMY, P, G05CAF$, G01FCF$
      EXTERNAL   G05CAF$, G01FCF$
C
C Is it safe ?
C
      IFAIL = N0
      IF (A.LE.ZERO .OR. B.LE.ZERO .OR. N.LT.1) THEN
         IFAIL = N1
         RETURN
      ENDIF
C
C Define the gamma/chi-square transformation factors
C
      AT2 = A*TWO
      BD2 = B/TWO
C
C Generate uniform(0,1) numbers then chi-square then gamma
C
      DO I = N1, N
         J = N0
         P = G05CAF$(DUMMY)
         CHI = G01FCF$(P, AT2, J)
         X(I) = BD2*CHI
      ENDDO
      END
C
C
