C
C
      SUBROUTINE G07AAF$(N, K, CLEVEL, PL, PU, IFAIL)
C
C ACTION: Binomial confidence limits
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 07/04/2000
C
      IMPLICIT   NONE
      INTEGER    IFAIL, K, N
      INTEGER    NBIG, NMK, NMKBIG
      PARAMETER (NBIG = 1000000, NMKBIG = 1000)
      DOUBLE PRECISION CLEVEL, PL, PU
      DOUBLE PRECISION A, B, C, D, P, Q, X1, X2
      DOUBLE PRECISION ALPHA2, CHISQD, DK, DN, DN2, DOF, Z
      DOUBLE PRECISION G01FEF$, G01FAF$, G01FCF$
      DOUBLE PRECISION ZERO, ONE, TWO, FOUR
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           FOUR = 4.0D+00)
      CHARACTER  TAIL*1
      PARAMETER (TAIL = 'L')
      EXTERNAL   G01FEF$, G01FAF$, G01FCF$
      INTRINSIC  DBLE, MIN, SQRT, MAX
      IFAIL = 0
      PL = ZERO
      PU = ONE
C
C Is it safe ?
C
      IF (N.LT.1 .OR.
     +    K.LT.0 .OR. K.GT.N .OR.
     +    CLEVEL.GE.ONE .OR. CLEVEL.LE.ZERO) THEN
          IFAIL = 1
          RETURN
      ENDIF
C
C Local parameters
C
      NMK = N - K
      DK = DBLE(K)
      DN = DBLE(N)
      DN2 = TWO*DN
      ALPHA2 = (ONE - CLEVEL)/TWO
      IF (MAX(K,NMK).LT.NBIG) THEN
C
C Calculate PL
C
         IF (K.GT.0) THEN
            A = DK
            B = DN - DK + ONE
            P = ALPHA2
            IFAIL = 0
            PL = G01FEF$(P, A, B, ZERO, IFAIL)
         ENDIF
C
C Calculate PU
C
         IF (K.LT.N) THEN
            A = DK + ONE
            B = DN - DK
            P = ONE - ALPHA2
            IFAIL = 0
            PU = G01FEF$(P, A, B, ZERO, IFAIL)
         ENDIF
      ELSEIF (MAX(K,NMK).GE.NBIG .AND.
     +        MIN(K,NMK).LE.NMKBIG) THEN

         ALPHA2 = (ONE - CLEVEL)/TWO
C
C Calculate PL
C
         IF (K.GT.0) THEN
            DOF = TWO*DK
            CHISQD = ALPHA2
            IFAIL = 0
            PL = G01FCF$(CHISQD, DOF, IFAIL)/DN2
         ENDIF
C
C Calculate PU
C
         IF (K.LT.N) THEN
            DOF = TWO*(DK + ONE)
            CHISQD = ONE - ALPHA2
            IFAIL = 0
            PU = G01FCF$(CHISQD, DOF, IFAIL)/DN2
         ENDIF
      ELSE
C
C Calculate PL
C
         IF (K.GT.0) THEN
            P = ONE - ALPHA2
            IFAIL = 0
            Z = G01FAF$(TAIL, P, IFAIL)
            A = DN*(DN + Z**2)
            B = - DN*(TWO*DK + Z**2)
            C = DK**2
            D = SQRT(B**2 - FOUR*A*C)
            Q = - (B - D)/TWO
            X1 = Q/A
            X2 = C/Q
            PL = MIN(X1, X2)
         ENDIF
C
C Calculate PU
C
         IF (K.LT.N) THEN
            P = ALPHA2
            IFAIL = 0
            Z = G01FAF$(TAIL, P, IFAIL)
            A = DN*(DN + Z**2)
            B = - DN*(TWO*DK + Z**2)
            C = DK**2
            D = SQRT(B**2 - FOUR*A*C)
            Q = - (B - D)/TWO
            X1 = Q/A
            X2 = C/Q
            PU = MAX(X1, X2)
         ENDIF
      ENDIF
C
C Final check
C
      IF (PL.LT.ZERO) PL = ZERO
      IF (PL.GT.ONE) PL = ONE
      IF (PU.LT.ZERO) PU = ZERO
      IF (PU.GT.ONE) PU = ONE
      END
C
C
