C
C
      SUBROUTINE G07ABF$(N, XMEAN, CLEVEL, TL, TU, IFAIL)
C
C ACTION: Poisson confidence limits
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 07/04/2000
C         28/02/2002 edited
C
      IMPLICIT   NONE
      INTEGER    IFAIL, N
      DOUBLE PRECISION CLEVEL, TL, TU, XMEAN
      DOUBLE PRECISION ALPHA2, CHISQD, DOF, DN, DN2, T
      DOUBLE PRECISION G01FCF$
      DOUBLE PRECISION ZERO, ONE, TWO
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00)
      EXTERNAL   G01FCF$
      INTRINSIC  DBLE
      IFAIL = 0
C
C Is it safe ?
C
      IF (N.LT.1 .OR.
     +    XMEAN.LT.ZERO .OR.
     +    CLEVEL.GE.ONE .OR. CLEVEL.LE.ZERO) THEN
          TL = ZERO
          TU = ZERO
          IFAIL = 1
          RETURN
      ENDIF
C
C Local parameters
C
      DN = DBLE(N)
      DN2 = TWO*DN
      T = DN*XMEAN
      ALPHA2 = (ONE - CLEVEL)/TWO
C
C Calculate TL
C
      DOF = TWO*T
      CHISQD = ALPHA2
      IFAIL = 0
      TL = G01FCF$(CHISQD, DOF, IFAIL)/DN2
C
C Calculate TU
C
      DOF = TWO*(T + ONE)
      CHISQD = ONE - ALPHA2
      IFAIL = 0
      TU = G01FCF$(CHISQD, DOF, IFAIL)/DN2
C
C Final check
C
      IF (TL.LT.ZERO) TL = ZERO
      IF (TL.GT.XMEAN) TL = XMEAN
      IF (TU.LT.XMEAN) TU = XMEAN
      END
C
C
