
C
C ====================================================================
C Calls G07BEF1 for function evaluation
C Calls G07BEF2 for initial estimates
C ====================================================================
C
      SUBROUTINE G07BEF$(CENS, N, X, IC, BETA, GAMMA, TOL, MAXIT,
     +                   SEBETA, SEGAM, CORR, DEV, NIT, WK, IFAIL)
C
C ACTION: replacement for NAG routine
C         IFAIL is not tested on input
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 19/8/98
C
      IMPLICIT   NONE
      INTEGER    N, IC(N), MAXIT, NIT, IFAIL
      INTEGER    I, ISEND, ND
      INTEGER    IPRINT, M, NPAR, LIW, LW
      PARAMETER (IPRINT = -1, M = 10, NPAR = 2,
     +           LIW = 3*NPAR,
     +           LW = 2*(2*M*NPAR + 4*NPAR + 11*M*M + 8*M))
      INTEGER    ISAVE(44), IW(LIW), MAXIT1, NBD(NPAR)
      DOUBLE PRECISION X(N), BETA, GAMMA, TOL, SEBETA, SEGAM, CORR,
     +                 DEV, WK(N)
      DOUBLE PRECISION D, DL11, DL12, DL22, TEMP
      DOUBLE PRECISION BL(NPAR), BU(NPAR), DSAVE(29), F, FACTR,
     +                 G(NPAR), PGTOL, W(LW), XPAR(NPAR)
      DOUBLE PRECISION DENOM, EPSI, RTOL, X02AJF$, X02AMF$
      DOUBLE PRECISION ZERO, ONE, FTOL
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, FTOL = 1.0D-10)
      DOUBLE PRECISION BL1, BL2, BU1, BU2
      PARAMETER (BL1 = - 1000.0D+00, BL2 = 1.0D-10,
     +           BU1 = - BL1,        BU2 = 100.0D+00)
      CHARACTER  CENS*(*)
      CHARACTER  C*1
      CHARACTER  CSAVE*60, TASK*60
      LOGICAL    CENSOR
      LOGICAL    LSAVE(4)
      EXTERNAL   X02AJF$, X02AMF$
      EXTERNAL   G07BEF1, G07BEF2
      EXTERNAL   SETULB
      INTRINSIC  ABS, DBLE, SQRT
C
C Check the input
C
      WK(1) = 1.0D+00!to silence ftn95
      IFAIL = 0
      C = CENS(1:1)
      IF (C.EQ.'C' .OR. C.EQ.'c') THEN
         CENSOR = .TRUE.
      ELSEIF (C.EQ.'N' .OR. C.EQ.'n') THEN
         CENSOR = .FALSE.
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
      EPSI = X02AJF$()
      IF (N.LT.1 .OR.
     +    TOL.LT.ZERO .OR.
     +   (TOL.GT.ZERO .AND. TOL.LT.EPSI) .OR.
     +    TOL.GT.ONE) THEN
          IFAIL = 1
          RETURN
      ENDIF
      DO I = 1, N
         IF (X(I).LE.ZERO) THEN
            IFAIL = 2
            RETURN
         ENDIF
      ENDDO
      IF (CENSOR) THEN
         ND = 0
         DO I = 1, N
            IF (IC(I).EQ.0) THEN
               ND = ND + 1
            ELSEIF (IC(I).NE.1) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
         IF (ND.EQ.0) THEN
            IFAIL = 3
            RETURN
         ELSEIF (ND.EQ.N) THEN
            CENSOR = .FALSE.
         ENDIF
         D = DBLE(ND)
      ELSE
         D = DBLE(N)
      ENDIF
C
C Set the starting estimates
C
       call g07bef2(n, ic, beta, d, gamma, x, censor)
c
c ======================================================================
c
c We start the iteration by initializing task.
c
      task = 'START'
      nit = 0
      if (maxit.le.100) then
         maxit1 = 100
      elseif (maxit.gt.1000) then
         maxit1 = 1000
      else
         maxit1 = maxit
      endif
c
c Set nbd = 0 (unbound), 1(lower), 2 (both), 3 (upper) as required
c
      nbd(1) = 0
      nbd(2) = 1
      bl(1) = bl1
      bl(2) = bl2
      bu(1) = bu1
      bu(2) = bu2
      xpar(1) = beta
      xpar(2) = gamma
c
c Now we decide on the precision ... low, medium or high
c
      if (tol.gt.zero) then
         factr = 1.0d+7
         pgtol = 1.0d-3
      else
         factr = 1.0d+1
         pgtol = 1.0d-7
      endif
c
c preliminary call for f and g before fitting to store fsav
c
      isend = 1
      call g07bef1(isend, ic, n, npar, beta, d, dl11, dl12, dl22, f,
     +             g, gamma, x, censor)
c
c ------- the beginning of the loop ----------
c

  20  continue
c
c This is the call to the L-BFGS-B code.
c
      call setulb (npar, m, xpar, bl, bu, nbd, f, g, factr, pgtol, w,
     +             iw, task, iprint, csave, lsave, isave, dsave)
c
c Set beta and gamma then check the number of iterations
c
      beta = xpar(1)
      gamma = xpar(2)
      nit = nit + 1
      if (nit.gt.maxit1) then
         ifail = 4
         goto 40
      endif

      if (task(1:2) .eq. 'FG') then
c
c the minimization routine has returned to request the
c function f and gradient g values at the current x.
c
         call g07bef1(isend, ic, n, npar, beta, d, dl11, dl12, dl22, f,
     +                g, gamma, x, censor)
c
c go back to the minimization routine.
c
         goto 20
      endif
c
c
      if (task(1:5) .eq. 'NEW_X')  then
c
c the minimization routine has returned with a new iterate,
c

         if (nit.lt.2 .or. dsave(13).gt.ftol*(one + abs(f))) then
            goto 20
         else
            task =
     +     'CONVERGENCE: projected gradient < 1.d-10*(1 + abs(f))'
         endif
      endif
c           ---------- the end of the loop -------------
c
c If task is neither FG nor NEW_X we terminate execution.
c
   40 continue
c
c Get dl11, dl12 and dl22 by setting isend = 2
c
      isend = 2
      call g07bef1(isend, ic, n, npar, beta, d, dl11, dl12, dl22, f,
     +             g, gamma, x, censor)
c
c ======================================================================
c

C
C Now the final calculations
C
      BETA = XPAR(1)
      GAMMA = XPAR(2)
      SEBETA = ZERO
      SEGAM = ZERO
      CORR = ZERO
      RTOL = 1.0D+09*X02AMF$()
      DENOM = DL11*DL22 - DL12**2
      IF (DENOM.GT.RTOL) THEN
         TEMP = - DL22/DENOM
         IF (TEMP.GT.RTOL) SEBETA = SQRT(TEMP)
         TEMP = - DL11/DENOM
         IF (TEMP.GT.RTOL) SEGAM = SQRT(TEMP)
      ENDIF
      TEMP = DL11*DL22
      IF (TEMP.GT.RTOL) CORR = DL12/SQRT(TEMP)
      DEV = - F
      END
C
C
      SUBROUTINE G07BEF1(ISEND, IC, N, NPAR, BETA, D, DL11, DL12, DL22,
     +                   F, G, GAMMA, X, CENSOR)
C
C ACTION: calculate -log(L) and derivatives for a Weibull distribution
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 18/8/98
C
C         ISEND = 1: calculate F = -log(L) and G the derivatives of F
C         ISEND = 2: calculate higher derivatives of log(L)
C
      IMPLICIT NONE
      INTEGER   N
      INTEGER   ISEND, IC(N), NPAR
      INTEGER   I
      DOUBLE PRECISION BETA, D, DL11, DL12, DL22, F, G(NPAR),
     +                 GAMMA, X(N)
      DOUBLE PRECISION BETA1, GAMMA1, SUM1, SUM2, SUM3, SUM4, TEMP,
     +                 TEMP1
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      LOGICAL   CENSOR
      INTRINSIC LOG, EXP
      IF (ISEND.EQ.1) THEN
C
C F, G(1) and G(2)
C
         BETA1 = EXP(BETA)
         GAMMA1 = GAMMA - ONE
         SUM1 = ZERO
         SUM2 = ZERO
         SUM3 = ZERO
         IF (CENSOR) THEN
C
C The X data is censored
C

            DO I = 1, N
               TEMP1 = LOG(X(I))
               IF (IC(I).EQ.0) SUM1 = SUM1 + TEMP1
               TEMP = X(I)**GAMMA
               SUM2 = SUM2 + TEMP
               TEMP = TEMP1*TEMP
               SUM3 = SUM3 + TEMP
            ENDDO
         ELSE
C
C The x data is not censored
C
            DO I = 1, N
               TEMP1 = LOG(X(I))
               SUM1 = SUM1 + TEMP1
               TEMP = X(I)**GAMMA
               SUM2 = SUM2 + TEMP
               TEMP = TEMP1*TEMP
               SUM3 = SUM3 + TEMP
            ENDDO
         ENDIF
C
C Note that F and G are for F = -log(L) not log(L)
C
         F = - D*LOG(GAMMA) - D*BETA - GAMMA1*SUM1 + BETA1*SUM2
         G(1) = - D + BETA1*SUM2
         G(2) = - D/GAMMA - SUM1 + BETA1*SUM3
      ELSEIF (ISEND.EQ.2) THEN
C
C L11, L12 and L22
C
         BETA1 = EXP(BETA)
         SUM2 = ZERO
         SUM3 = ZERO
         SUM4 = ZERO
         DO I = 1, N
            TEMP1 = LOG(X(I))
            TEMP = X(I)**GAMMA
            SUM2 = SUM2 + TEMP
            TEMP = TEMP1*TEMP
            SUM3 = SUM3 + TEMP
            TEMP = TEMP1*TEMP
            SUM4 = SUM4 + TEMP
         ENDDO
C
C Note that DL11, DL12 and DL22 are derivatives of log(L) not -log(L)
C
         DL11 = - BETA1*SUM2
         DL12 = - BETA1*SUM3
         DL22 = - D/(GAMMA*GAMMA) - BETA1*SUM4
      ENDIF
      END
C
C
       SUBROUTINE G07BEF2(N, IC, BETA, D, GAMMA, X, CENSOR)
C
C ACTION: calculate starting estimates for G07BEF$
C AUTHOR: W.G.Bardsley, University of Manchester, U.K., 19/8/98
C
      IMPLICIT   NONE
      INTEGER    N, IC(N)
      INTEGER    NMAX
      PARAMETER (NMAX = 1000)
      INTEGER    IFREQ(1), IWK(NMAX)
      INTEGER    IFAIL, ND
      INTEGER    I, M, M1
      DOUBLE PRECISION BETA, D, GAMMA, X(N)
      DOUBLE PRECISION RESUL(20), RTOL, SUM1, TEMP
      DOUBLE PRECISION X02AMF$
      DOUBLE PRECISION TP(NMAX), P(NMAX), PSIG(NMAX)
      DOUBLE PRECISION ZERO, ONE, TWO, GAMMAX
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           GAMMAX = 100.0D+00)
      CHARACTER  FREQ*1
      PARAMETER (FREQ = 'S')
      LOGICAL    CENSOR
      INTRINSIC  LOG, MIN
      EXTERNAL   G12AAF$, X02AMF$, G02CAF$
      IF (CENSOR) IFAIL = 1!to silence ftn95
C
C Check-out gamma
C
      IF (D.LT.TWO .AND. GAMMA.LE.ZERO) GAMMA = ONE
      IF (GAMMA.GT.GAMMAX) GAMMA = GAMMAX
      IF (GAMMA.LE.ZERO) THEN
C
C Find the Kaplan-Meier estimate of the survivor function
C
         M = MIN(N,NMAX)
         IFREQ(1) = 1
         IFAIL = 1
         CALL G12AAF$(M, X, IC, FREQ, IFREQ, ND, TP, P, PSIG, IWK,
     +                IFAIL)
         IF (IFAIL.NE.0 .OR. ND.LT.2) THEN
C
C Failure ... guess GAMMA since routine failed or insufficient points
C
            GAMMA = ONE
         ELSE
C
C Success ... try linear regression
C
            RTOL = 1.0D+09*X02AMF$()
            M1 = 0
            DO I = 1, ND
               IF (P(I).GT.RTOL) THEN
                  TEMP = LOG(P(I))
                  IF (TEMP.LT.- RTOL) THEN
                     M1 = M1 + 1
                     P(M1) = LOG(- TEMP)
                  ENDIF
               ENDIF
            ENDDO
            IF (M1.LT.2) THEN
C
C Failure ... insufficient points
C
               GAMMA = ONE
            ELSE
C
C Success ... try to fit a line
C
               IFAIL = 1
               CALL G02CAF$(M1, TP, P, RESUL, IFAIL)
               IF (IFAIL.EQ.0) THEN
C
C Success ... assign GAMMA
C
                  GAMMA = RESUL(6)
               ELSE
C
C failure ... guess GAMMA
C
                  GAMMA = ONE
               ENDIF
            ENDIF
         ENDIF
      ENDIF
C
C Calculate beta
C
      BETA = ZERO
      SUM1 = ZERO
      DO I = 1, N
         SUM1 = SUM1 + X(I)**GAMMA
      ENDDO
      IF (SUM1.GT.ZERO) BETA = LOG(D/SUM1)
      END
C
C
