
C
C
      SUBROUTINE G07DAF$(N, X, Y, XME, XMD, XSD, IFAIL)
C
C Substitute for G07DAF, w.g.bardsley, university of manchester, u.k., 15/06/2004
C This version uses the Monahan codes FSTMED and QSORT
C It does not obey the NAG IFAIL input convention
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER N, IFAIL
      DOUBLE PRECISION X(N), Y(N), XME, XMD, XSD
C
C Locals
C
      INTEGER    I
      DOUBLE PRECISION FSTMED
      DOUBLE PRECISION ZERO, PHI
      PARAMETER (ZERO = 0.0D+00, PHI = 0.6744897502D+00)
      EXTERNAL   FSTMED, QSORT
      INTRINSIC  ABS
C
C Initialise in case  N =< 1
C
      XME = ZERO
      XMD = ZERO
      XSD = ZERO
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LE.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C Copy X into Y
C
      DO I = 1, N
         Y(I) = X(I)
      ENDDO
C
C Work out XME
C
      XME = FSTMED (Y, N)
C
C Work out the deviations then calculate XMD
C

      DO I = 1, N
         Y(I) = ABS(X(I) - XME)
      ENDDO
      XMD = FSTMED (Y, N)
C
C Calculate  XSD
C
      XSD = XMD/PHI
C
C Return Y as sorted observations to agree with NAG
C
      DO I = 1, N
         Y(I) = X(I)
      ENDDO
      CALL QSORT (Y, N)
      END
C
C




