C
C
      SUBROUTINE G07DDF$(N, X, ALPHA, TMEAN, WMEAN, TVAR, WVAR, K, SX,
     +                   IFAIL)
C
C Substitute for G07DDF, w.g.bardsley, university of manchester, u.k., 15/06/2004
C
      IMPLICIT NONE
C
C Arguments
C
      INTEGER N, K, IFAIL
      DOUBLE PRECISION X(N), ALPHA, TMEAN, WMEAN, TVAR, WVAR, SX(N)
C
C Locals
C
      INTEGER I, KP1, NMK
      DOUBLE PRECISION DK, DN, DNSQD
      DOUBLE PRECISION ZERO, HALF, TWO
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, TWO = 2.0D+00)
      INTRINSIC DBLE, NINT
      EXTERNAL NXSORT
C
C Initialise
C
      K = 0
      TMEAN = ZERO
      WMEAN = ZERO
      TVAR = ZERO
      WVAR = ZERO
C
C Is it safe ?
C
      IFAIL = 0
      IF (N.LE.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
      IF (ALPHA.LT.ZERO .OR. ALPHA.GE.HALF) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C Sort
C
      DO I = 1, N
         SX(I) = X(I)
      ENDDO
      CALL NXSORT (N, SX)
C
C Define K then TMEAN and WMEAN
C
      K = NINT(ALPHA*DBLE(N))
      IF (N - 2*K.LT.1) K = K - 1
      KP1 = K + 1
      NMK = N - K
      DN = DBLE(N)
      DK = DBLE(K)
      DNSQD = DN*DN
      DO I = KP1, NMK
         TMEAN = TMEAN + SX(I)
      ENDDO
      WMEAN = TMEAN
      TMEAN = TMEAN/(DN - TWO*DK)
      WMEAN = WMEAN + DK*(SX(KP1) + SX(NMK))
      WMEAN = WMEAN/DN
C
C Calculate TVAR and WVAR
C
      DO I = KP1, NMK
         TVAR = TVAR + (SX(I) - TMEAN)**2
         WVAR = WVAR + (SX(I) - WMEAN)**2
      ENDDO
      TVAR = TVAR + DK*((SX(KP1) - TMEAN)**2 + (SX(NMK) - TMEAN)**2)
      TVAR = TVAR/DNSQD
      WVAR = WVAR + DK*((SX(KP1) - WMEAN)**2 + (SX(NMK) - WMEAN)**2)
      WVAR = WVAR/DNSQD
      END
C
C


