C
C
      SUBROUTINE G08AAF$(X, Y, N, IS, N1, P, IFAIL)
C
C substitute for G08AAF
C w.g.bardsley, university of manchester, u.k., 26/05/2004
C
      IMPLICIT   NONE
      INTEGER    N, IS, N1, IFAIL
      INTEGER    I, N1DIV2
      DOUBLE PRECISION X(N), Y(N), P
      DOUBLE PRECISION PLEK, PGTK, PEQK
      DOUBLE PRECISION ZERO, HALF
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00)
      EXTERNAL   G01BJF$
C
C Initialise
C
      IFAIL = 0
      IS = 0
      N1 = 0
      P = ZERO
C
C Is it safe ?
C

      IF (N.LT.1) THEN
         IFAIL = 1
         RETURN
      ENDIF
C
C Compare X with Y
C
      DO I = 1, N
         IF (X(I).LT.Y(I)) THEN
            N1 = N1 + 1
            IS = IS + 1
         ELSEIF (X(I).GT.Y(I)) THEN
            N1 = N1 + 1
         ENDIF
      ENDDO
      IF (N1.EQ.0) THEN
         IFAIL = 2
         RETURN
      ENDIF
C
C The special case IS = N1/2
C
      N1DIV2 = N1/2
      IF (IS.EQ.N1DIV2) THEN
         P = HALF
         RETURN
      ENDIF
C
C Otherwise calculate binomial parameters
C
      CALL G01BJF$(N1, HALF, IS, PLEK, PGTK, PEQK, IFAIL)
      IF (IS.LT.N1DIV2) THEN
         P = PLEK
      ELSE
         P = PLEK - PEQK
      ENDIF
      END
C
C
