C
C
       SUBROUTINE G08ACF$ (X, N, N1, W, I1, I2, P, IFAIL)
C
C ACTION: substitute for G08ACF 
C AUTHOR: w.g.bardsley, university of manchester, u.k., 18/09/2012
c         28/06/2014 changed Fisher exact from P(NPOS) to MIN(PSUM1,PSUM2)
C
C Note that the Monahan code FSTMED alters X and it also seems to
C return a slightly higher value than NAG so I1 and I2 may be 
C slightly larger than the NAG ones.
C       
       IMPLICIT NONE
C
C Arguments
C
      INTEGER N, N1, I1, I2, IFAIL
      DOUBLE PRECISION X(N), W(N), P
C
C Locals
C  
      INTEGER    I, J1, J2, N2
      INTEGER    MTEMP, NDF, NPOS, NTEMP, NUM
      INTEGER    INOB, IPRED, MM, NN 
      PARAMETER (INOB = 3, IPRED = 3, MM = 3, NN = 3)
      INTEGER    NOBS(INOB,INOB)
      DOUBLE PRECISION CHIS, DOF, FMED, FSTMED
      DOUBLE PRECISION PRED(IPRED,IPRED), PROB(21)
      DOUBLE PRECISION PSUM1, PSUM2
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      DOUBLE PRECISION G01ECF$
      EXTERNAL   FSTMED
      EXTERNAL   G01AFF$, G01ECF$
      INTRINSIC  DBLE, MIN
C
C Initialise and check arguments
C      
      P = ZERO
      I1 = 0
      I2 = 0
      IFAIL = 1
      IF (N.LT.2) RETURN    
      IFAIL = 2
      IF (N1.LT.1 .OR. N1.GE.N) RETURN
      IFAIL = 0 
C
C Define N2 then find copy X into W and use FSTMED to find the median
C        
      N2 = N - N1 
      DO I = 1, N
         W(I) = X(I)
      ENDDO   
      FMED = FSTMED (W, N) 
C
C Fill in the frequencies
C      
      DO I = 1, N1
         IF (X(I).LT.FMED) I1 = I1 + 1
      ENDDO  
      J1 = N1 - I1
      DO I = 1, N2
         IF (X(N1 + I).LT.FMED) I2 = I2 + 1    
      ENDDO 
      J2 = N2 - I2 
      NOBS(1,1) = I1
      NOBS(1,2) = I2
      NOBS(1,3) = I1 + I2
      NOBS(2,1) = J1
      NOBS(2,2) = J2
      NOBS(2,3) = N - (I1 + I2)
      NOBS(3,1) = N1
      NOBS(3,2) = N2
      NOBS(3,3) = N
      IFAIL = 0
      NUM = 0
      CALL G01AFF$(INOB, IPRED, MM, NN, NOBS, NUM, PRED, CHIS, PROB,
     +             NPOS, NDF, MTEMP, NTEMP, IFAIL)
      IF (NUM.GT.0) THEN
C
C Fisher exact test
C        
         PSUM1 = PROB(NPOS)
         PSUM2 = PROB(NPOS)
         DO I = 1, NUM
            IF (I.LT.NPOS) THEN
               PSUM1 = PSUM1 + PROB(I)
            ELSEIF (I.GT.NPOS) THEN
               PSUM2 = PSUM2 + PROB(I)
            ENDIF       
         ENDDO  
         P = MIN(PSUM1,PSUM2)
      ELSE
C
C Chi-squared test
C        
         DOF = DBLE(NDF)
         P = G01ECF$('U', CHIS, DOF, IFAIL)
      ENDIF       
      END
C
C      